/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket;

import com.inet.annotations.JsonData;
import com.inet.error.PersistenceException;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.extension.CreateTicketExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.plugins.attachments.server.AttachmentDuplicator;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import com.inet.helpdesk.plugins.quickticket.ApplyQuickTicketActionExtensionFactory;
import com.inet.plugin.ServerPluginManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class AddQuickTicketAttachmentsActionExtensionFactory
implements TicketActionExtensionFactory {
    public static final ExtensionArguments.ExtArg<AddQuickTicketAttachmentsExtensionData> EXTARG_QT_ATT_NAMES = new ExtensionArguments.JsonizableAndImmutableExtArg("quickticketextension.attachments", AddQuickTicketAttachmentsExtensionData.class);

    public TicketActionExtension createIfApplicable(OperationChangedTicket ticket, ActionVO action, ExtensionArguments arguments, MutableReaStepData reaStepData) {
        AddQuickTicketAttachmentsExtensionData extData = (AddQuickTicketAttachmentsExtensionData)arguments.get(EXTARG_QT_ATT_NAMES);
        if (extData != null) {
            ApplyQuickTicketActionExtensionFactory.ApplyQuickTicketActionExtensionData applyQuickTicketActionExtData = (ApplyQuickTicketActionExtensionFactory.ApplyQuickTicketActionExtensionData)arguments.get(ApplyQuickTicketActionExtensionFactory.EXTARG_APPLY_QUICK_TICKET_DATA);
            if (applyQuickTicketActionExtData == null) {
                throw new IllegalStateException("extension can not be created if part of required data is missing");
            }
            return new AddQuickTicketAttachmentsActionExtension(applyQuickTicketActionExtData.getQuickTicketIntID(), extData);
        }
        return null;
    }

    @JsonData
    public static class AddQuickTicketAttachmentsExtensionData {
        private Set<String> attachmentNames;

        private AddQuickTicketAttachmentsExtensionData() {
        }

        public AddQuickTicketAttachmentsExtensionData(Set<String> attachmentNames) {
            if (attachmentNames == null) {
                throw new IllegalArgumentException("set of attachment names must not be null");
            }
            if (attachmentNames.isEmpty()) {
                throw new IllegalArgumentException("set of attachment names must not be empty");
            }
            this.attachmentNames = new HashSet<String>(attachmentNames);
        }

        public Set<String> getAttachmentNames() {
            return Collections.unmodifiableSet(this.attachmentNames);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.attachmentNames == null ? 0 : this.attachmentNames.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddQuickTicketAttachmentsExtensionData other = (AddQuickTicketAttachmentsExtensionData)obj;
            return !(this.attachmentNames == null ? other.attachmentNames != null : !this.attachmentNames.equals(other.attachmentNames));
        }
    }

    public static class AddQuickTicketAttachmentsActionExtension
    implements TicketActionExtension,
    CreateTicketExtension {
        private int quickTicketIntID;
        private AddQuickTicketAttachmentsExtensionData extData;

        public AddQuickTicketAttachmentsActionExtension(int quickTicketIntID, @Nonnull AddQuickTicketAttachmentsExtensionData extData) {
            this.quickTicketIntID = quickTicketIntID;
            this.extData = extData;
        }

        public void extendTicketAction(ActionVO action, OperationChangedTicket ticket, OperationNewReaStep reaStep, TicketSubOperations operations) {
            AddQuickTicketAttachmentsActionExtension.addQuickTicketAttachments(ticket.getTicketId(), reaStep.getReaStepId(), this.quickTicketIntID, this.extData);
        }

        public void beforeCreate(OperationChangedTicket newTicket, OperationNewReaStep anfrageStep, TicketSubOperations operations) {
            AddQuickTicketAttachmentsActionExtension.addQuickTicketAttachments(newTicket.getTicketId(), anfrageStep.getReaStepId(), this.quickTicketIntID, this.extData);
        }

        public static List<String> addQuickTicketAttachments(int ticketID, int reaStepID, int quickTicketIntID, @Nonnull AddQuickTicketAttachmentsExtensionData extData) {
            List attachmentsToAdd = extData.getAttachmentNames().stream().map(attName -> new AttachmentKey(AttachmentOwnerType.QuickTicketAttachment, Integer.valueOf(quickTicketIntID), Integer.valueOf(-1), Integer.valueOf(-1), attName)).collect(Collectors.toList());
            try {
                AttachmentDuplicator attDuplicator = (AttachmentDuplicator)ServerPluginManager.getInstance().getSingleInstance(AttachmentDuplicator.class);
                List attKeys = attDuplicator.duplicateAttachments(attachmentsToAdd, AttachmentOwnerType.TicketAttachment, ticketID, reaStepID, -1);
                return attKeys.stream().map(AttachmentKey::getFileName).collect(Collectors.toList());
            }
            catch (SQLException ex) {
                throw new PersistenceException((Throwable)ex);
            }
        }
    }
}

