/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.client.ticketlist.handler;

import com.inet.helpdesk.core.data.TicketAccessInformationsProvider;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.quickticket.api.LoadQuickTicketUtil;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketManager;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketVO;
import com.inet.helpdesk.plugins.quickticket.client.ticketlist.data.ApplyQuickTicketInitRequest;
import com.inet.helpdesk.plugins.quickticket.client.ticketlist.data.ApplyQuickTicketInitResponse;
import com.inet.helpdesk.plugins.ticketlist.api.data.TicketUser;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class ApplyQuickTicketInit
extends ServiceMethod<ApplyQuickTicketInitRequest, ApplyQuickTicketInitResponse> {
    public String getMethodName() {
        return "quickticket.applyquickticketinit";
    }

    public short getMethodType() {
        return 1;
    }

    public ApplyQuickTicketInitResponse invoke(HttpServletRequest req, HttpServletResponse resp, ApplyQuickTicketInitRequest payload) throws IOException {
        UserAccount userAccount;
        GUID ownerID;
        Integer ticketID = payload.getTicketID();
        String clientID = payload.getClientID();
        GUID quickTicketID = payload.getQuickTicketID();
        QuickTicketManager quickTicketManager = (QuickTicketManager)ServerPluginManager.getInstance().getSingleInstance(QuickTicketManager.class);
        QuickTicketVO quickTicket = quickTicketManager.getQuickTicket(quickTicketID);
        if (quickTicket == null) {
            throw new ClientMessageException(QuickTicketServerPlugin.CLIENT_MSG.getMsg("ticketlist.quickticket.quickticketnotfound", new Object[0]));
        }
        if (!LoadQuickTicketUtil.checkFolderPermissionsForQuickTicket(quickTicket.getID())) {
            throw new ClientMessageException(QuickTicketServerPlugin.CLIENT_MSG.getMsg("ticketlist.quickticket.quickticketnotfound", new Object[0]));
        }
        GUID ticketOwnerID = null;
        if (ticketID != null) {
            TicketReader ticketReader = TicketManager.getReader();
            TicketVO ticket = ticketReader.getTicket(ticketID.intValue());
            if (ticket != null) {
                ticketOwnerID = ticket.getOwnerID();
                TicketPermissionContext ticketPermissionInfo = TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticketID.intValue());
                boolean hasSupporterWriteAccess = ticketPermissionInfo.hasSupporterWriteAccessToTicket();
                if (!hasSupporterWriteAccess) {
                    throw new ClientMessageException(QuickTicketServerPlugin.CLIENT_MSG.getMsg("ticketlist.writepermission.failed", new Object[]{String.valueOf(ticketID)}));
                }
            }
            boolean writeLock = false;
            TicketAccessInformationsProvider ticketAccessProvider = (TicketAccessInformationsProvider)ServerPluginManager.getInstance().getSingleInstance(TicketAccessInformationsProvider.class);
            if (ticket != null) {
                writeLock = ticketAccessProvider.accessTicketWrite(clientID, ticketID.intValue());
            }
            if (!writeLock) {
                throw new ClientMessageException(QuickTicketServerPlugin.CLIENT_MSG.getMsg("ticketlist.lock.failed", new Object[]{String.valueOf(ticketID)}));
            }
        }
        TicketUser owner = null;
        if (quickTicket.getTicketData() != null && (ownerID = (GUID)quickTicket.getTicketData().get((TicketField)Tickets.FIELD_OWNER_GUID)) != null && (userAccount = UserManager.getInstance().getUserAccount(ownerID)) != null) {
            owner = new TicketUser(userAccount.getID(), userAccount.getDisplayName(), "", "");
        }
        return new ApplyQuickTicketInitResponse(quickTicket.getQuickTicketName(), owner, ticketOwnerID);
    }
}

