/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.client.ticketlist.handler;

import com.inet.helpdesk.config.autotext.handler.AutoTextAttachmentHelper;
import com.inet.helpdesk.core.TicketTextFunctions;
import com.inet.helpdesk.core.data.TicketAccessInformationsProvider;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextManager;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.quickticket.AddQuickTicketAttachmentsActionExtensionFactory;
import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableActionDataVO;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableQuickTicketVO;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketAttachmentProvider;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketManager;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketProcessingTime;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketVO;
import com.inet.helpdesk.plugins.quickticket.api.SendMailFromQuickTicketExtensionData;
import com.inet.helpdesk.plugins.quickticket.client.config.data.QuickTicketActionDescription;
import com.inet.helpdesk.plugins.quickticket.client.ticketlist.data.ApplyQuickTicketFieldsRequest;
import com.inet.helpdesk.plugins.quickticket.client.ticketlist.data.ApplyQuickTicketFieldsResponse;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFieldRendererId;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFunctions;
import com.inet.helpdesk.plugins.ticketlist.api.data.EditDuration;
import com.inet.helpdesk.plugins.ticketlist.api.data.EmailUser;
import com.inet.helpdesk.plugins.ticketlist.api.data.RecipientsCombined;
import com.inet.helpdesk.plugins.ticketlist.api.data.SavedAttachmentData;
import com.inet.helpdesk.plugins.ticketlist.api.data.Sender;
import com.inet.helpdesk.plugins.ticketlist.api.editing.ApplyActionRendererProvider;
import com.inet.helpdesk.plugins.ticketlist.api.editing.FieldEditDescription;
import com.inet.helpdesk.shared.model.Status;
import com.inet.http.ClientMessageException;
import com.inet.http.utils.MimeTypes;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Font;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ApplyQuickTicketFields
extends ServiceMethod<ApplyQuickTicketFieldsRequest, ApplyQuickTicketFieldsResponse> {
    public String getMethodName() {
        return "quickticket.applyquickticketfields";
    }

    public short getMethodType() {
        return 1;
    }

    public ApplyQuickTicketFieldsResponse invoke(HttpServletRequest req, HttpServletResponse resp, ApplyQuickTicketFieldsRequest payload) throws IOException {
        GUID ownerID = payload.getOwnerID();
        Integer ticketID = payload.getTicketID();
        List<Object> tickets = null;
        if (ticketID != null) {
            TicketReader ticketReader = TicketManager.getReader();
            TicketVO ticket = ticketReader.getTicket(ticketID.intValue());
            if (ticket != null) {
                tickets = new ArrayList<TicketVO>();
                tickets.add(ticket);
                TicketPermissionContext ticketPermissionInfo = TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticketID.intValue());
                boolean hasSupporterWriteAccess = ticketPermissionInfo.hasSupporterWriteAccessToTicket();
                if (!hasSupporterWriteAccess) {
                    throw new ClientMessageException(QuickTicketServerPlugin.CLIENT_MSG.getMsg("ticketlist.writepermission.failed", new Object[]{String.valueOf(ticketID)}));
                }
            }
            boolean writeLock = false;
            TicketAccessInformationsProvider ticketAccessProvider = (TicketAccessInformationsProvider)ServerPluginManager.getInstance().getSingleInstance(TicketAccessInformationsProvider.class);
            if (ticket != null) {
                writeLock = ticketAccessProvider.accessTicketWrite(payload.getClientID(), ticketID.intValue());
            }
            if (!writeLock) {
                ticketAccessProvider.leaveAllTickets(payload.getClientID());
                throw new ClientMessageException(QuickTicketServerPlugin.CLIENT_MSG.getMsg("ticketlist.lock.failed", new Object[]{String.valueOf(ticketID)}));
            }
        }
        List fieldDefs = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
        QuickTicketManager quickTicketManager = (QuickTicketManager)ServerPluginManager.getInstance().getSingleInstance(QuickTicketManager.class);
        ArrayList<SavedAttachmentData> attachments = new ArrayList<SavedAttachmentData>();
        if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
            QuickTicketAttachmentProvider attachmentService = (QuickTicketAttachmentProvider)ServerPluginManager.getInstance().getSingleInstance(QuickTicketAttachmentProvider.class);
            List<AttachmentRow> quickTicketAttachments = attachmentService.getQuickTicketAttachments(payload.getQuickTicketID());
            for (AttachmentRow row : quickTicketAttachments) {
                attachments.add(new SavedAttachmentData(row.getOwnerId(), row.getStepId(), row.getAdditionalId(), row.getType().getId(), row.getFileName(), MimeTypes.getMimeType((String)row.getFileName()), row.getFileLength(), row.getLastModified(), row.isEmbedded(), false));
            }
        }
        QuickTicketVO quickTicket = quickTicketManager.getQuickTicket(payload.getQuickTicketID());
        HashMap<String, String> quickTicketValues = new HashMap<String, String>();
        if (quickTicket == null) {
            throw new ClientMessageException(QuickTicketServerPlugin.CLIENT_MSG.getMsg("ticketlist.quickticket.quickticketnotfound", new Object[0]));
        }
        MutableTicketData ticketData = quickTicket.getTicketData();
        TicketVOSingle qtTVO = TicketVOSingle.create((int)Integer.MAX_VALUE, (MutableTicketAttributes)new MutableTicketAttributes(), (MutableTicketData)ticketData);
        Set includedFields = qtTVO.getIncludedFields().stream().map(tf -> tf.getKey()).collect(Collectors.toSet());
        for (TicketFieldDefinition definition : fieldDefs) {
            Object dateStr;
            FieldEditDefinition editDefinition = definition.getEditDefinition();
            if (editDefinition == null || !editDefinition.getFieldKey().equals(Tickets.FIELD_OWNER_GUID.getKey()) && !editDefinition.isAvailable(null) || !includedFields.contains(editDefinition.getFieldKey())) continue;
            editDefinition.updateCurrentValue((TicketVO)qtTVO, ownerID, quickTicketValues);
            if (!editDefinition.getDisplayType().equals("datevalue") && !editDefinition.getDisplayType().equals("dateonlyvalue") || StringFunctions.isEmpty((String)(dateStr = (String)quickTicketValues.get(editDefinition.getFieldKey())))) continue;
            try {
                long deadlineVal = Long.parseLong((String)dateStr);
                deadlineVal = System.currentTimeMillis() + deadlineVal * 60L * 1000L;
                quickTicketValues.put(editDefinition.getFieldKey(), String.valueOf(deadlineVal));
            }
            catch (NumberFormatException deadlineVal) {}
        }
        List<SavedAttachmentData> existingAttachments = null;
        List<ApplicableActionDataVO> actionsData = quickTicket.getActionsData();
        if (actionsData != null) {
            ActionVO editReaStepTextAction = (ActionVO)ActionManager.getInstance().get(-22);
            for (ApplicableActionDataVO actionDataVO : actionsData) {
                AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData attachmentData;
                ExtensionArguments arguments;
                if (!editReaStepTextAction.getUniqueID().equals(actionDataVO.getUniqueActionID())) continue;
                ReaStepTextVO inquiryText = actionDataVO.getReaStepText();
                if (inquiryText != null) {
                    String textContent = inquiryText.getText();
                    textContent = inquiryText.hasHtmlContent() ? TicketTextFunctions.getInlinedHtml((String)textContent, (boolean)false) : TicketTextFunctions.getLightHtmlFromPlainText((String)textContent);
                    quickTicketValues.put(TicketFieldRendererId.htmleditor.name(), textContent);
                    quickTicketValues.put(TicketFieldRendererId.htmlcontent.name(), String.valueOf(inquiryText.hasHtmlContent()));
                }
                if ((arguments = actionDataVO.getExtensionArguments()) == null || !ServerPluginManager.getInstance().isPluginLoaded("attachments") || (attachmentData = (AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData)arguments.get(AddQuickTicketAttachmentsActionExtensionFactory.EXTARG_QT_ATT_NAMES)) == null) break;
                Set<String> attachmentNames = attachmentData.getAttachmentNames();
                existingAttachments = attachments.stream().filter(a -> attachmentNames.contains(a.getFileName())).collect(Collectors.toList());
                break;
            }
            actionsData = actionsData.stream().filter(ad -> !editReaStepTextAction.getUniqueID().equals(ad.getUniqueActionID())).collect(Collectors.toList());
        }
        ArrayList<QuickTicketActionDescription> actionValues = new ArrayList<QuickTicketActionDescription>();
        if (actionsData != null) {
            actionsData.stream().forEach(ad -> {
                ProcessingTime processingTime;
                AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData attachmentsExtensionData;
                String subject;
                MutableReaStepData reaStepData;
                SendMailFromQuickTicketExtensionData mailData;
                QuickTicketActionDescription qtad = new QuickTicketActionDescription();
                ActionVO action = TicketManager.getTicketActionChecker().getActionByUniqueID(ad.getUniqueActionID(), -1);
                qtad.setActionDescription(TicketFunctions.convertToActionDescription((ActionVO)action));
                qtad.setActionDeleted(action.isDeleted());
                ExtensionArguments extensionArguments = ad.getExtensionArguments();
                ApplicableQuickTicketVO.convertRelativeValueOfExtArgAppointmentToNotRelative(extensionArguments);
                HashMap initialProperties = ApplyActionRendererProvider.getInstance().getInitialProperties(null, action, null, null, null, ad.getReaStepText(), extensionArguments);
                if (extensionArguments != null && (mailData = (SendMailFromQuickTicketExtensionData)extensionArguments.get(QuickTicketServerPlugin.EXTARG_SEND_MAIL_FROM_QT_DATA)) != null) {
                    List<SendMailFromQuickTicketExtensionData.EmailEntry> svBCC;
                    List<SendMailFromQuickTicketExtensionData.EmailEntry> svCC;
                    SendMailFromQuickTicketExtensionData.EmailEntry svSender = mailData.getSender();
                    Sender sender = null;
                    if (svSender != null) {
                        Sender.IconType iconType = Sender.IconType.statusid;
                        if (svSender.getType() == SendMailFromQuickTicketExtensionData.EmailEntryType.RESOURCE) {
                            iconType = Sender.IconType.resourceid;
                        }
                        if (svSender.getType() == SendMailFromQuickTicketExtensionData.EmailEntryType.USER) {
                            iconType = Sender.IconType.ownerid;
                        }
                        sender = new Sender(svSender.getDisplayName(), svSender.getEmail(), svSender.getId(), iconType);
                    }
                    ArrayList receiversTo = new ArrayList();
                    ArrayList receiversCC = new ArrayList();
                    ArrayList receiversBCC = new ArrayList();
                    List<SendMailFromQuickTicketExtensionData.EmailEntry> svTo = mailData.getAn();
                    if (svTo != null) {
                        receiversTo.addAll(svTo.stream().map(to -> new EmailUser(to.getId() == null ? null : GUID.valueOf((String)to.getId()), to.getDisplayName(), "", "", to.getEmail())).collect(Collectors.toList()));
                    }
                    if ((svCC = mailData.getCc()) != null) {
                        receiversCC.addAll(svCC.stream().map(cc -> new EmailUser(cc.getId() == null ? null : GUID.valueOf((String)cc.getId()), cc.getDisplayName(), "", "", cc.getEmail())).collect(Collectors.toList()));
                    }
                    if ((svBCC = mailData.getBcc()) != null) {
                        receiversBCC.addAll(svBCC.stream().map(bcc -> new EmailUser(bcc.getId() == null ? null : GUID.valueOf((String)bcc.getId()), bcc.getDisplayName(), "", "", bcc.getEmail())).collect(Collectors.toList()));
                    }
                    RecipientsCombined recipientsCombined = new RecipientsCombined(sender, ((Boolean)ApplyActionRendererProvider.SENDER_ALLOW_CUSTOM.get()).booleanValue(), receiversTo, receiversCC, receiversBCC);
                    initialProperties.put(TicketFieldRendererId.recipients.name(), new Json().toJson((Object)recipientsCombined));
                }
                if ((reaStepData = ad.getReaStepData()) != null && (subject = (String)reaStepData.get((ReaStepField)ReaStepVO.FIELD_DESC)) != null) {
                    initialProperties.put(TicketFieldRendererId.subject.name(), subject);
                }
                qtad.setActionValues(initialProperties);
                qtad.setActionRenderers(ApplyActionRendererProvider.getInstance().getRendererIds(action, null));
                if (ServerPluginManager.getInstance().isPluginLoaded("attachments") && (attachmentsExtensionData = (AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData)ad.getExtensionArguments().get(AddQuickTicketAttachmentsActionExtensionFactory.EXTARG_QT_ATT_NAMES)) != null) {
                    Set<String> fileNames = attachmentsExtensionData.getAttachmentNames();
                    List<SavedAttachmentData> list = attachments.stream().filter(a -> fileNames.contains(a.getFileName())).collect(Collectors.toList());
                    qtad.setExistingAttachments(list);
                }
                boolean supportsEditDuration = action.getId() != -12 && action.getId() != -22 && 2 != (Integer)ApplyActionRendererProvider.EFFORTTIME.get();
                EditDuration editDuration = new EditDuration(null, null, false);
                if (reaStepData != null && (processingTime = (ProcessingTime)reaStepData.get((ReaStepField)ReaStepVO.FIELD_PROCESSING_TIME)) != null) {
                    QuickTicketProcessingTime.toNonRelativeProcessingTime(processingTime);
                    editDuration = new EditDuration(String.valueOf(processingTime.getEffortInMin()), null, false);
                }
                qtad.setSupportsEditDuration(supportsEditDuration);
                qtad.setEditDuration(editDuration);
                actionValues.add(qtad);
            });
        }
        if (tickets != null) {
            tickets = tickets.stream().map(t -> {
                if (Status.isClosedOrDeletedStatus((int)t.getStatusID())) {
                    MutableTicketAttributes manipulatedAttributes = new MutableTicketAttributes();
                    t.getIncludedAttributes().stream().forEach(a -> manipulatedAttributes.put(a, t.getAttribute(a)));
                    manipulatedAttributes.put((TicketAttribute)Tickets.ATTRIBUTE_STATUS_ID, (Object)((ActionVO)ActionManager.getInstance().get(-2)).getStatusID());
                    MutableTicketData manipulatedTicketData = new MutableTicketData();
                    t.getIncludedFields().stream().forEach(f -> manipulatedTicketData.put(f, t.getValue(f)));
                    return TicketVOSingle.create((int)t.getID(), (MutableTicketAttributes)manipulatedAttributes, (MutableTicketData)manipulatedTicketData);
                }
                return t;
            }).collect(Collectors.toList());
        }
        HashMap<String, String> ticketValues = new HashMap<String, String>();
        HashMap<String, FieldEditDescription> fields = new HashMap<String, FieldEditDescription>();
        for (TicketFieldDefinition definition : fieldDefs) {
            FieldEditDefinition editDefinition = definition.getEditDefinition();
            if (editDefinition == null || !editDefinition.getFieldKey().equals(Tickets.FIELD_RESOURCE_GUID.getKey()) && !editDefinition.isAvailable(tickets)) continue;
            if (ticketID == null) {
                editDefinition.updateCurrentValue(null, ownerID, ticketValues);
            } else {
                editDefinition.updateCurrentValue(TicketManager.getReader().getTicket(ticketID.intValue()), ownerID, ticketValues);
            }
            FieldEditDescription description = new FieldEditDescription(editDefinition.getFieldKey(), editDefinition.getDisplayType(), editDefinition.getDisplayName(), definition.getDescription(), definition.getProperties());
            fields.put(editDefinition.getFieldKey(), description);
        }
        fields.put(TicketFieldRendererId.htmleditor.name(), new FieldEditDescription(TicketFieldRendererId.htmleditor.name(), "htmltext", null, null, Collections.emptyMap()));
        ticketValues.put(TicketFieldRendererId.htmlcontent.name(), String.valueOf((Boolean)ApplyActionRendererProvider.DEFAULT_TICKET_PLAINTEXT_REASTEP.get() == false));
        ticketValues.put(TicketFieldRendererId.htmleditor.name(), "");
        Font defaultFont = TicketTextFunctions.getDefaultFont();
        if (defaultFont != null) {
            ticketValues.put(TicketFieldRendererId.fontname.name(), defaultFont.getFamily());
            ticketValues.put(TicketFieldRendererId.fontsize.name(), defaultFont.getSize() + "pt");
        }
        List autoTexts = null;
        AutoTextManager autoTextManager = (AutoTextManager)ServerPluginManager.getInstance().getSingleInstance(AutoTextManager.class);
        List autoTextVOs = autoTextManager.getAutoTexts(ticketID, null, Integer.valueOf(4));
        if (autoTextVOs != null) {
            autoTexts = TicketFunctions.convertAutoTexts((List)autoTextVOs);
        }
        HashMap<Integer, List<SavedAttachmentData>> autoTextAttachments = new HashMap<Integer, List<SavedAttachmentData>>();
        if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
            if (autoTextVOs != null) {
                autoTextVOs.forEach(at -> {
                    List savedAttachments = AutoTextAttachmentHelper.getAutoTextAttachments((int)at.getId());
                    autoTextAttachments.put(at.getId(), savedAttachments);
                });
            }
            fields.put(TicketFieldRendererId.attachments.name(), new FieldEditDescription(TicketFieldRendererId.attachments.name(), "attachmentsadd", null, null, Collections.emptyMap()));
            ticketValues.put(TicketFieldRendererId.attachments.name(), String.valueOf(0));
        }
        return new ApplyQuickTicketFieldsResponse(quickTicket.getQuickTicketName(), quickTicketValues, actionValues, ticketValues, fields, existingAttachments, autoTexts, autoTextAttachments);
    }
}

