/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.client.ticketlist;

import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AdditionalReaStepFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AdditionalReaStepFieldDescription;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.quickticket.ReaStepFieldQuickTicketId;
import com.inet.helpdesk.plugins.quickticket.api.LoadQuickTicketUtil;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketManager;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketVO;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class AdditionalReaStepFieldDefinitionQuickTicketId
extends AdditionalReaStepFieldDefinition<GUID> {
    public AdditionalReaStepFieldDefinitionQuickTicketId() {
        super((ReaStepField)ReaStepFieldQuickTicketId.INSTANCE);
    }

    public List<AdditionalReaStepFieldDescription> convertToDescriptions(ReaStepVO step, Set<Integer> availableStepsIds) {
        if (step == null) {
            return null;
        }
        GUID qtId = (GUID)step.getValue((ReaStepField)ReaStepFieldQuickTicketId.INSTANCE);
        if (qtId == null) {
            return null;
        }
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            return null;
        }
        if (!SystemPermissionChecker.checkAccess((Permission[])new Permission[]{HdPermissions.TEMPLATE_DEFINITION, Permission.CONFIGURATION}) && !HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount)) {
            return null;
        }
        QuickTicketManager qtm = (QuickTicketManager)ServerPluginManager.getInstance().getSingleInstance(QuickTicketManager.class);
        QuickTicketVO quickTicket = qtm.getQuickTicket(qtId);
        boolean hasAccesToQuickTicket = false;
        boolean canManageQuickTicket = false;
        if (quickTicket != null) {
            if (SystemPermissionChecker.checkAccess((Permission[])new Permission[]{HdPermissions.TEMPLATE_DEFINITION, Permission.CONFIGURATION})) {
                hasAccesToQuickTicket = true;
                canManageQuickTicket = true;
            } else if (LoadQuickTicketUtil.checkFolderPermissionsForQuickTicket(qtId)) {
                hasAccesToQuickTicket = true;
                canManageQuickTicket = false;
            }
        }
        ArrayList<AdditionalReaStepFieldDescription> list = new ArrayList<AdditionalReaStepFieldDescription>();
        if (quickTicket != null && hasAccesToQuickTicket) {
            HashMap<String, Object> linkValues = new HashMap<String, Object>();
            if (canManageQuickTicket) {
                linkValues.put("url", "configmanager/page/configuration.quicktickets/editquickticket/" + String.valueOf(qtId));
            }
            linkValues.put("iconclass", "icon-additionalreastepfield-quickticket");
            linkValues.put("title", QuickTicketServerPlugin.MSG.getMsg("ticketlist.additionalreastepfield.qtlink.title", new Object[]{quickTicket.getQuickTicketName()}));
            list.add(new AdditionalReaStepFieldDescription("externallink", linkValues));
            return list;
        }
        HashMap<String, String> linkValues = new HashMap<String, String>();
        linkValues.put("iconclass", "icon-additionalreastepfield-quickticket");
        linkValues.put("title", QuickTicketServerPlugin.MSG.getMsg("ticketlist.additionalreastepfield.qtlink.applied", new Object[0]));
        list.add(new AdditionalReaStepFieldDescription("externallink", linkValues));
        return list;
    }
}

