/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.client.config.handler;

import com.inet.helpdesk.core.TicketTextFunctions;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.quickticket.AddQuickTicketAttachmentsActionExtensionFactory;
import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableActionDataVO;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketAttachmentProvider;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketFolderStructureVO;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketManager;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketProcessingTime;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketVO;
import com.inet.helpdesk.plugins.quickticket.api.SendMailFromQuickTicketExtensionData;
import com.inet.helpdesk.plugins.quickticket.client.config.data.CreateOrEditQuickTicketRequest;
import com.inet.helpdesk.plugins.quickticket.client.config.data.CreateOrEditQuickTicketResponse;
import com.inet.helpdesk.plugins.quickticket.client.config.data.FolderEntry;
import com.inet.helpdesk.plugins.quickticket.client.config.data.QuickTicketActionDescription;
import com.inet.helpdesk.plugins.quickticket.client.shared.data.QuickTicketDescription;
import com.inet.helpdesk.plugins.quickticket.taskplanner.TasksWithQTs;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFieldRendererId;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFunctions;
import com.inet.helpdesk.plugins.ticketlist.api.data.ActionDescription;
import com.inet.helpdesk.plugins.ticketlist.api.data.EditDuration;
import com.inet.helpdesk.plugins.ticketlist.api.data.EmailUser;
import com.inet.helpdesk.plugins.ticketlist.api.data.RecipientsCombined;
import com.inet.helpdesk.plugins.ticketlist.api.data.SavedAttachmentData;
import com.inet.helpdesk.plugins.ticketlist.api.data.Sender;
import com.inet.helpdesk.plugins.ticketlist.api.editing.ApplyActionRendererProvider;
import com.inet.helpdesk.plugins.ticketlist.api.editing.FieldEditDescription;
import com.inet.http.ClientMessageException;
import com.inet.http.utils.MimeTypes;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.Executable;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Font;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class CreateOrEditQuickTicket
extends ServiceMethod<CreateOrEditQuickTicketRequest, CreateOrEditQuickTicketResponse> {
    public String getMethodName() {
        return "quickticket.createoreditquickticket";
    }

    public short getMethodType() {
        return 1;
    }

    public CreateOrEditQuickTicketResponse invoke(HttpServletRequest req, HttpServletResponse resp, CreateOrEditQuickTicketRequest payload) throws IOException {
        GUID qtId = payload.getQuickTicketId();
        HashMap<String, FieldEditDescription> fieldDescriptions = new HashMap<String, FieldEditDescription>();
        QuickTicketManager quickTicketManager = (QuickTicketManager)ServerPluginManager.getInstance().getSingleInstance(QuickTicketManager.class);
        QuickTicketDescription desc = new QuickTicketDescription();
        List fieldDefs = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        HashMap<String, String> fieldDefaultValues = new HashMap<String, String>();
        HashMap<GUID, GUID> foldermapping = new HashMap<GUID, GUID>();
        CreateOrEditQuickTicketResponse createOrEditQuickTicketResponse = new CreateOrEditQuickTicketResponse();
        QuickTicketFolderStructureVO folderStructure = quickTicketManager.getFolderStructure();
        List<QuickTicketFolderStructureVO.NodeVO> nodes = folderStructure.getNodes();
        ArrayList<FolderEntry> folders = new ArrayList<FolderEntry>();
        this.createFolderStructure(nodes, folders, 0, quickTicketManager, foldermapping);
        createOrEditQuickTicketResponse.setFolders(folders);
        QuickTicketVO quickTicket = null;
        TicketVOSingle ticketVOSingle = null;
        Set includedFields = Collections.emptySet();
        List<Object> actionsData = null;
        if (qtId != null) {
            quickTicket = quickTicketManager.getQuickTicket(qtId);
            if (quickTicket == null) {
                throw new ClientMessageException(QuickTicketServerPlugin.CLIENT_MSG.getMsg("configuration.quickticket.edit.notfound", new Object[0]));
            }
            MutableTicketData ticketData = quickTicket.getTicketData();
            ticketVOSingle = TicketVOSingle.create((int)Integer.MAX_VALUE, (MutableTicketAttributes)new MutableTicketAttributes(), (MutableTicketData)ticketData);
            includedFields = ticketVOSingle.getIncludedFields().stream().map(tf -> tf.getKey()).collect(Collectors.toSet());
            String qtName = quickTicket.getQuickTicketName();
            if (payload.isDuplicate()) {
                qtName = this.createUniqueName(qtName, quickTicketManager);
            } else {
                desc.setQuickTicketId(qtId);
            }
            desc.setQuickTicketName(qtName);
            desc.setQuickTicketFolder(foldermapping.get(quickTicket.getID()));
            actionsData = quickTicket.getActionsData();
        }
        ArrayList<SavedAttachmentData> attachments = new ArrayList<SavedAttachmentData>();
        if (qtId != null && ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
            QuickTicketAttachmentProvider attachmentService = (QuickTicketAttachmentProvider)ServerPluginManager.getInstance().getSingleInstance(QuickTicketAttachmentProvider.class);
            List<AttachmentRow> quickTicketAttachments = attachmentService.getQuickTicketAttachments(qtId);
            Iterator<AttachmentRow> iterator = quickTicketAttachments.iterator();
            while (iterator.hasNext()) {
                AttachmentRow row = iterator.next();
                attachments.add(new SavedAttachmentData(row.getOwnerId(), row.getStepId(), row.getAdditionalId(), row.getType().getId(), row.getFileName(), MimeTypes.getMimeType((String)row.getFileName()), row.getFileLength(), row.getLastModified(), row.isEmbedded(), false));
            }
        }
        fieldValues.put(TicketFieldRendererId.htmlcontent.name(), String.valueOf((Boolean)ApplyActionRendererProvider.DEFAULT_TICKET_PLAINTEXT_REASTEP.get() == false));
        if (actionsData != null) {
            ActionVO editReaStepTextAction = (ActionVO)ActionManager.getInstance().get(-22);
            for (ApplicableActionDataVO applicableActionDataVO : actionsData) {
                AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData attachmentData;
                if (!editReaStepTextAction.getUniqueID().equals(applicableActionDataVO.getUniqueActionID())) continue;
                ReaStepTextVO inquiryText = applicableActionDataVO.getReaStepText();
                if (inquiryText != null) {
                    String textContent = inquiryText.getText();
                    textContent = inquiryText.hasHtmlContent() ? TicketTextFunctions.getInlinedHtml((String)textContent, (boolean)false) : TicketTextFunctions.getLightHtmlFromPlainText((String)textContent);
                    fieldValues.put(TicketFieldRendererId.htmleditor.name(), textContent);
                    fieldValues.put(TicketFieldRendererId.htmlcontent.name(), String.valueOf(inquiryText.hasHtmlContent()));
                }
                List existingAttachments = null;
                ExtensionArguments arguments = applicableActionDataVO.getExtensionArguments();
                if (arguments != null && ServerPluginManager.getInstance().isPluginLoaded("attachments") && (attachmentData = (AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData)arguments.get(AddQuickTicketAttachmentsActionExtensionFactory.EXTARG_QT_ATT_NAMES)) != null) {
                    Set<String> attachmentNames = attachmentData.getAttachmentNames();
                    existingAttachments = attachments.stream().filter(a -> attachmentNames.contains(a.getFileName())).collect(Collectors.toList());
                }
                createOrEditQuickTicketResponse.setFieldAttachments(existingAttachments);
                break;
            }
            actionsData = actionsData.stream().filter(ad -> !editReaStepTextAction.getUniqueID().equals(ad.getUniqueActionID())).collect(Collectors.toList());
        }
        for (TicketFieldDefinition definition : fieldDefs) {
            String dateStr;
            UserAccount currentUserAccount;
            FieldEditDefinition fieldEditDefinition = definition.getEditDefinition();
            if (fieldEditDefinition == null || !fieldEditDefinition.getFieldKey().equals(Tickets.FIELD_OWNER_GUID.getKey()) && !fieldEditDefinition.isAvailable(null)) continue;
            if (includedFields.contains(fieldEditDefinition.getFieldKey())) {
                fieldEditDefinition.updateCurrentValue((TicketVO)ticketVOSingle, null, fieldValues);
            }
            fieldEditDefinition.updateCurrentValue(null, (currentUserAccount = UserManager.getInstance().getCurrentUserAccount()) == null ? null : currentUserAccount.getID(), fieldDefaultValues);
            if ((fieldEditDefinition.getDisplayType().equals("datevalue") || fieldEditDefinition.getDisplayType().equals("dateonlyvalue")) && !StringFunctions.isEmpty((String)(dateStr = (String)fieldDefaultValues.get(fieldEditDefinition.getFieldKey())))) {
                try {
                    long deadlineVal = Long.parseLong(dateStr);
                    deadlineVal = (deadlineVal - System.currentTimeMillis()) / 60L / 1000L;
                    fieldDefaultValues.put(fieldEditDefinition.getFieldKey(), String.valueOf(deadlineVal));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            FieldEditDescription description = new FieldEditDescription(fieldEditDefinition.getFieldKey(), fieldEditDefinition.getDisplayType(), fieldEditDefinition.getDisplayName(), definition.getDescription(), definition.getProperties());
            fieldDescriptions.put(description.getFieldKey(), description);
        }
        if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
            fieldDescriptions.put(TicketFieldRendererId.attachments.name(), new FieldEditDescription(TicketFieldRendererId.attachments.name(), "attachmentsadd", QuickTicketServerPlugin.CLIENT_MSG.getMsg("configuration.quickticket.edit.field.attachments", new Object[0]), null, Collections.emptyMap()));
            fieldDefaultValues.put("attachments", "");
        }
        fieldDescriptions.put(TicketFieldRendererId.htmleditor.name(), new FieldEditDescription(TicketFieldRendererId.htmleditor.name(), "htmltext", QuickTicketServerPlugin.CLIENT_MSG.getMsg("configuration.quickticket.edit.field.htmleditor", new Object[0]), null, Collections.emptyMap()));
        fieldDefaultValues.put(TicketFieldRendererId.htmleditor.name(), "");
        fieldDefaultValues.put(TicketFieldRendererId.htmlcontent.name(), String.valueOf((Boolean)ApplyActionRendererProvider.DEFAULT_TICKET_PLAINTEXT_REASTEP.get() == false));
        Font defaultFont = TicketTextFunctions.getDefaultFont();
        if (defaultFont != null) {
            fieldValues.put(TicketFieldRendererId.fontname.name(), defaultFont.getFamily());
            fieldValues.put(TicketFieldRendererId.fontsize.name(), defaultFont.getSize() + "pt");
            fieldDefaultValues.put(TicketFieldRendererId.fontname.name(), defaultFont.getFamily());
            fieldDefaultValues.put(TicketFieldRendererId.fontsize.name(), defaultFont.getSize() + "pt");
        }
        createOrEditQuickTicketResponse.setFieldDescriptions(fieldDescriptions);
        createOrEditQuickTicketResponse.setFieldValues(fieldValues);
        createOrEditQuickTicketResponse.setFieldDefaultValues(fieldDefaultValues);
        ArrayList<QuickTicketActionDescription> actionDescriptions = new ArrayList<QuickTicketActionDescription>();
        List<ActionVO> list = quickTicketManager.getActionsAvailableForQuickTickets();
        List convertTicketActions = TicketFunctions.convertTicketActions(list, null);
        convertTicketActions.stream().sorted((a, b) -> a.getDisplayName().compareToIgnoreCase(b.getDisplayName())).forEach(ad -> {
            QuickTicketActionDescription qtad = new QuickTicketActionDescription();
            qtad.setActionDescription((ActionDescription)ad);
            ExtensionArguments extArgs = ExtensionArguments.create();
            extArgs.put(ExtensionArguments.EXTARG_APPOINTMENT, (Object)10080L);
            qtad.setActionValues(ApplyActionRendererProvider.getInstance().getInitialProperties(null, TicketManager.getTicketActionChecker().getActionByUniqueID(ad.getUid(), -1), null, null, null, null, extArgs));
            qtad.setActionRenderers(ApplyActionRendererProvider.getInstance().getRendererIds(TicketManager.getTicketActionChecker().getActionByUniqueID(ad.getUid(), -1), null));
            boolean supportsEditDuration = ad.getId() != -12 && ad.getId() != -22 && 2 != (Integer)ApplyActionRendererProvider.EFFORTTIME.get();
            qtad.setSupportsEditDuration(supportsEditDuration);
            qtad.setEditDuration(new EditDuration(null, null, false));
            actionDescriptions.add(qtad);
        });
        createOrEditQuickTicketResponse.setActionDescriptions(actionDescriptions);
        ArrayList<QuickTicketActionDescription> actionValues = new ArrayList<QuickTicketActionDescription>();
        if (actionsData != null) {
            actionsData.stream().forEach(ad -> {
                ProcessingTime processingTime;
                AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData attachmentsExtensionData;
                String subject;
                MutableReaStepData reaStepData;
                SendMailFromQuickTicketExtensionData mailData;
                QuickTicketActionDescription qtad = new QuickTicketActionDescription();
                ActionVO action = TicketManager.getTicketActionChecker().getActionByUniqueID(ad.getUniqueActionID(), -1);
                qtad.setActionDescription(TicketFunctions.convertToActionDescription((ActionVO)action));
                qtad.setActionDeleted(action.isDeleted());
                ExtensionArguments extensionArguments = ad.getExtensionArguments();
                HashMap initialProperties = ApplyActionRendererProvider.getInstance().getInitialProperties(null, action, null, null, null, ad.getReaStepText(), extensionArguments);
                if (extensionArguments != null && (mailData = (SendMailFromQuickTicketExtensionData)extensionArguments.get(QuickTicketServerPlugin.EXTARG_SEND_MAIL_FROM_QT_DATA)) != null) {
                    List<SendMailFromQuickTicketExtensionData.EmailEntry> svBCC;
                    List<SendMailFromQuickTicketExtensionData.EmailEntry> svCC;
                    SendMailFromQuickTicketExtensionData.EmailEntry svSender = mailData.getSender();
                    Sender sender = null;
                    if (svSender != null) {
                        Sender.IconType iconType = Sender.IconType.statusid;
                        if (svSender.getType() == SendMailFromQuickTicketExtensionData.EmailEntryType.RESOURCE) {
                            iconType = Sender.IconType.resourceid;
                        }
                        if (svSender.getType() == SendMailFromQuickTicketExtensionData.EmailEntryType.USER) {
                            iconType = Sender.IconType.ownerid;
                        }
                        sender = new Sender(svSender.getDisplayName(), svSender.getEmail(), svSender.getId(), iconType);
                    }
                    ArrayList receiversTo = new ArrayList();
                    ArrayList receiversCC = new ArrayList();
                    ArrayList receiversBCC = new ArrayList();
                    List<SendMailFromQuickTicketExtensionData.EmailEntry> svTo = mailData.getAn();
                    if (svTo != null) {
                        receiversTo.addAll(svTo.stream().map(to -> new EmailUser(to.getId() == null ? null : GUID.valueOf((String)to.getId()), to.getDisplayName(), "", "", to.getEmail())).collect(Collectors.toList()));
                    }
                    if ((svCC = mailData.getCc()) != null) {
                        receiversCC.addAll(svCC.stream().map(cc -> new EmailUser(cc.getId() == null ? null : GUID.valueOf((String)cc.getId()), cc.getDisplayName(), "", "", cc.getEmail())).collect(Collectors.toList()));
                    }
                    if ((svBCC = mailData.getBcc()) != null) {
                        receiversBCC.addAll(svBCC.stream().map(bcc -> new EmailUser(bcc.getId() == null ? null : GUID.valueOf((String)bcc.getId()), bcc.getDisplayName(), "", "", bcc.getEmail())).collect(Collectors.toList()));
                    }
                    RecipientsCombined recipientsCombined = new RecipientsCombined(sender, ((Boolean)ApplyActionRendererProvider.SENDER_ALLOW_CUSTOM.get()).booleanValue(), receiversTo, receiversCC, receiversBCC);
                    initialProperties.put(TicketFieldRendererId.recipients.name(), new Json().toJson((Object)recipientsCombined));
                }
                if ((reaStepData = ad.getReaStepData()) != null && (subject = (String)reaStepData.get((ReaStepField)ReaStepVO.FIELD_DESC)) != null) {
                    initialProperties.put(TicketFieldRendererId.subject.name(), subject);
                }
                qtad.setActionValues(initialProperties);
                qtad.setActionRenderers(ApplyActionRendererProvider.getInstance().getRendererIds(action, null));
                if (ServerPluginManager.getInstance().isPluginLoaded("attachments") && (attachmentsExtensionData = (AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData)ad.getExtensionArguments().get(AddQuickTicketAttachmentsActionExtensionFactory.EXTARG_QT_ATT_NAMES)) != null) {
                    Set<String> fileNames = attachmentsExtensionData.getAttachmentNames();
                    List<SavedAttachmentData> list = attachments.stream().filter(a -> fileNames.contains(a.getFileName())).collect(Collectors.toList());
                    qtad.setExistingAttachments(list);
                }
                boolean supportsEditDuration = action.getId() != -12 && action.getId() != -22 && 2 != (Integer)ApplyActionRendererProvider.EFFORTTIME.get();
                EditDuration editDuration = new EditDuration(null, null, false);
                if (reaStepData != null && (processingTime = (ProcessingTime)reaStepData.get((ReaStepField)ReaStepVO.FIELD_PROCESSING_TIME)) != null) {
                    QuickTicketProcessingTime.toNonRelativeProcessingTime(processingTime);
                    editDuration = new EditDuration(String.valueOf(processingTime.getEffortInMin()), null, false);
                }
                qtad.setSupportsEditDuration(supportsEditDuration);
                qtad.setEditDuration(editDuration);
                actionValues.add(qtad);
            });
        }
        createOrEditQuickTicketResponse.setActionValues(actionValues);
        createOrEditQuickTicketResponse.setDesc(desc);
        ServerPluginManager.getInstance().runIfPluginLoaded("taskplanner.helpdesk", () -> new Executable(){

            public void execute() {
                TasksWithQTs tasksWithQTs = TasksWithQTs.getInstance();
                if (tasksWithQTs.isAvailable()) {
                    tasksWithQTs.addTaskPlannerDetails(createOrEditQuickTicketResponse);
                }
            }
        });
        return createOrEditQuickTicketResponse;
    }

    private String createUniqueName(String qtName, QuickTicketManager quickTicketManager) {
        String testLabel;
        List allQuickTicketNames = quickTicketManager.getAllQuickTicketIDs().stream().filter(Objects::nonNull).map(id -> quickTicketManager.getQuickTicket((GUID)id)).filter(Objects::nonNull).map(qt -> qt.getQuickTicketName()).collect(Collectors.toList());
        if (!allQuickTicketNames.contains(testLabel = qtName + " (" + QuickTicketServerPlugin.CLIENT_MSG.getMsg("configuration.quickticket.duplicate.name.copy", new Object[0]) + ")")) {
            return testLabel;
        }
        for (int counter = 1; counter < 1000; ++counter) {
            testLabel = qtName + " (" + QuickTicketServerPlugin.CLIENT_MSG.getMsg("configuration.quickticket.duplicate.name.copy", new Object[0]) + " " + counter + ")";
            if (allQuickTicketNames.contains(testLabel)) continue;
            return testLabel;
        }
        return qtName;
    }

    private void createFolderStructure(List<QuickTicketFolderStructureVO.NodeVO> nodes, ArrayList<FolderEntry> folders, int level, QuickTicketManager quickTicketManager, HashMap<GUID, GUID> foldermapping) {
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        nodes.stream().sorted((o1, o2) -> o1.getFolder().getFolderName().compareToIgnoreCase(o2.getFolder().getFolderName())).forEach(nodeVO -> {
            GUID folderID = nodeVO.getFolder().getID();
            folders.add(new FolderEntry(folderID.toString(), nodeVO.getFolder().getFolderName(), level));
            List<GUID> idsOfQuickTicketsInFolder = quickTicketManager.listQuickTicketsInFolder(folderID);
            idsOfQuickTicketsInFolder.forEach(qtID -> foldermapping.put((GUID)qtID, folderID));
            this.createFolderStructure(nodeVO.getChildren(), folders, level + 1, quickTicketManager, foldermapping);
        });
    }
}

