/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.api;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableActionData;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableActionDataVO;
import com.inet.helpdesk.plugins.quickticket.api.MutableApplicableActionData;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketException;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketManager;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketProcessingTime;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketVO;
import com.inet.helpdesk.plugins.quickticket.api.SendMailFromQuickTicketExtensionData;
import com.inet.helpdesk.shared.model.Status;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ApplicableQuickTicketVO {
    private final GUID quickTicketID;
    private final MutableTicketData ticketData;
    private final ExtensionArguments extArgs;
    private final List<ApplicableActionDataVO> actionsData;

    private ApplicableQuickTicketVO(GUID quickTicketID, MutableTicketData ticketData, ExtensionArguments extArgs, List<ApplicableActionDataVO> actionsData) {
        this.quickTicketID = quickTicketID;
        this.ticketData = ticketData;
        this.extArgs = extArgs;
        this.actionsData = actionsData;
    }

    public static ApplicableQuickTicketVO createFrom(QuickTicketVO quickTicket) {
        if (quickTicket == null) {
            throw QuickTicketException.forIAE("data of quick-ticket must not be null");
        }
        List<ApplicableActionDataVO> actionsDataFromQtDef = quickTicket.getActionsData();
        ApplicableQuickTicketVO.throwIfContainsUnsupportedActions(actionsDataFromQtDef);
        ApplicableQuickTicketVO.throwIfContainsActionsInIncorrectOrder(actionsDataFromQtDef);
        MutableTicketData ticketData = quickTicket.getTicketData();
        if (ticketData.containsKey((TicketField)Tickets.FIELD_DEADLINE)) {
            Long deadlinevalue = (Long)ticketData.get((TicketField)Tickets.FIELD_DEADLINE);
            if (deadlinevalue != null) {
                Long nonRelativeDeadline = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(deadlinevalue);
                ticketData.put((TicketField)Tickets.FIELD_DEADLINE, (Object)nonRelativeDeadline);
            } else {
                ticketData.put((TicketField)Tickets.FIELD_DEADLINE, null);
            }
        }
        List<ApplicableActionDataVO> actionsData = ApplicableQuickTicketVO.convertIfNeeded(actionsDataFromQtDef);
        return new ApplicableQuickTicketVO(quickTicket.getID(), ticketData, quickTicket.getExtensionArguments(), actionsData);
    }

    private static List<ApplicableActionDataVO> convertIfNeeded(List<ApplicableActionDataVO> actionsData) {
        ArrayList<ApplicableActionDataVO> result = new ArrayList<ApplicableActionDataVO>();
        for (ApplicableActionDataVO data : actionsData) {
            MutableApplicableActionData mutableData = null;
            ProcessingTime processingTime = (ProcessingTime)data.getReaStepData().get((ReaStepField)ReaStepVO.FIELD_PROCESSING_TIME);
            if (processingTime != null && QuickTicketProcessingTime.isRelativeProcessingTime(processingTime)) {
                if (mutableData == null) {
                    mutableData = data.toMutable();
                }
                ProcessingTime nonRelativeProcessingTime = QuickTicketProcessingTime.toNonRelativeProcessingTime(processingTime);
                mutableData.getReaStepData().put((ReaStepField)ReaStepVO.FIELD_PROCESSING_TIME, (Object)nonRelativeProcessingTime);
            }
            if (data.getExtensionArguments().containsExtArg(ExtensionArguments.EXTARG_APPOINTMENT)) {
                if (mutableData == null) {
                    mutableData = data.toMutable();
                }
                ApplicableQuickTicketVO.convertRelativeValueOfExtArgAppointmentToNotRelative(mutableData.getExtensionArguments());
            }
            if (data.getExtensionArguments().containsExtArg(QuickTicketServerPlugin.EXTARG_SEND_MAIL_FROM_QT_DATA)) {
                if (mutableData == null) {
                    mutableData = data.toMutable();
                }
                SendMailFromQuickTicketExtensionData extData = (SendMailFromQuickTicketExtensionData)mutableData.getExtensionArguments().remove(QuickTicketServerPlugin.EXTARG_SEND_MAIL_FROM_QT_DATA);
                MutableReaStepData stepData = mutableData.getReaStepData();
                List<ReaStepField> relatedReaStepFields = Arrays.asList(ReaStepVO.FIELD_EMAIL_IN, ReaStepVO.FIELD_USER_DISPLAY_NAME, ReaStepVO.FIELD_EMAIL_AN, ReaStepVO.FIELD_EMAIL_CC, ReaStepVO.FIELD_EMAIL_BCC);
                boolean valueAlreadyDefinedForAtLeastOneOfRelatedReaStepFields = relatedReaStepFields.stream().anyMatch(field -> stepData.containsField(field));
                if (!valueAlreadyDefinedForAtLeastOneOfRelatedReaStepFields) {
                    String senderDisplayName = "";
                    SendMailFromQuickTicketExtensionData.EmailEntry sender = extData.getSender();
                    if (sender != null) {
                        senderDisplayName = sender.getDisplayName();
                        stepData.put((ReaStepField)ReaStepVO.FIELD_EMAIL_IN, (Object)sender.getEmail());
                    }
                    stepData.put((ReaStepField)ReaStepVO.FIELD_USER_DISPLAY_NAME, (Object)senderDisplayName);
                    stepData.put((ReaStepField)ReaStepVO.FIELD_EMAIL_AN, (Object)SendMailFromQuickTicketExtensionData.concatEmailAddresses(extData.getAn()));
                    stepData.put((ReaStepField)ReaStepVO.FIELD_EMAIL_CC, (Object)SendMailFromQuickTicketExtensionData.concatEmailAddresses(extData.getCc()));
                    stepData.put((ReaStepField)ReaStepVO.FIELD_EMAIL_BCC, (Object)SendMailFromQuickTicketExtensionData.concatEmailAddresses(extData.getBcc()));
                }
            }
            if (mutableData == null) {
                result.add(data);
                continue;
            }
            result.add(mutableData.toImmutable());
        }
        return result;
    }

    public static ApplicableQuickTicketVO create(GUID quickTicketID, MutableTicketData ticketData, ExtensionArguments extArgs, List<? extends ApplicableActionData> actionsData) {
        QuickTicketVO.throwIfIdIsInvalid(quickTicketID);
        QuickTicketVO.throwIfExtArgsAreNull(extArgs);
        QuickTicketVO.throwIfTicketOrActionsDataIsInvalid(ticketData, actionsData);
        ApplicableQuickTicketVO.throwIfContainsRelativeProcessingTime(actionsData);
        ApplicableQuickTicketVO.throwIfContainsSendMailActionsWithExtData(actionsData);
        ApplicableQuickTicketVO.throwIfContainsUnsupportedActions(actionsData);
        ApplicableQuickTicketVO.throwIfContainsActionsInIncorrectOrder(actionsData);
        return new ApplicableQuickTicketVO(quickTicketID, ticketData.copy(), ExtensionArguments.copyOf((ExtensionArguments)extArgs), actionsData.stream().map(ApplicableActionData::toImmutable).collect(Collectors.toList()));
    }

    public GUID getID() {
        return this.quickTicketID;
    }

    public MutableTicketData getTicketData() {
        return this.ticketData.copy();
    }

    public ExtensionArguments getExtensionArguments() {
        return ExtensionArguments.copyOf((ExtensionArguments)this.extArgs);
    }

    public List<ApplicableActionDataVO> getActionsData() {
        return Collections.unmodifiableList(this.actionsData);
    }

    public int hashCode() {
        return Objects.hash(this.actionsData, this.extArgs, this.quickTicketID, this.ticketData);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicableQuickTicketVO other = (ApplicableQuickTicketVO)obj;
        return Objects.equals(this.actionsData, other.actionsData) && Objects.equals(this.extArgs, other.extArgs) && Objects.equals(this.quickTicketID, other.quickTicketID) && Objects.equals(this.ticketData, other.ticketData);
    }

    public String toString() {
        return "ApplicableQuickTicketVO [quickTicketID=" + String.valueOf(this.quickTicketID) + ", ticketData=" + String.valueOf(this.ticketData) + ", extArgs=" + String.valueOf(this.extArgs) + ", actionsData=" + String.valueOf(this.actionsData) + "]";
    }

    public static void convertRelativeValueOfExtArgAppointmentToNotRelative(@Nullable ExtensionArguments extArgs) {
        if (extArgs == null) {
            return;
        }
        Long appointment = (Long)extArgs.get(ExtensionArguments.EXTARG_APPOINTMENT);
        if (appointment != null) {
            extArgs.put(ExtensionArguments.EXTARG_APPOINTMENT, (Object)(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(appointment)));
        }
    }

    private static void throwIfContainsRelativeProcessingTime(List<? extends ApplicableActionData> actionsData) {
        for (int index = 0; index < actionsData.size(); ++index) {
            ApplicableActionData data = actionsData.get(index);
            ProcessingTime processingTime = (ProcessingTime)data.getReaStepData().get((ReaStepField)ReaStepVO.FIELD_PROCESSING_TIME);
            if (processingTime == null || !QuickTicketProcessingTime.isRelativeProcessingTime(processingTime)) continue;
            String msg = "actions data must not contain relative processing time";
            ActionVO action = TicketManager.getTicketActionChecker().getActionByUniqueID(data.getUniqueActionID(), -1);
            String actionDisplayName = action == null ? "" : action.getDisplayValue();
            throw QuickTicketException.forIAE(msg, index, actionDisplayName);
        }
    }

    private static void throwIfContainsSendMailActionsWithExtData(List<? extends ApplicableActionData> actionsData) {
        ActionVO actionSendMail = (ActionVO)ActionManager.getInstance().get(-7);
        String sendMailActionUniqueID = actionSendMail.getUniqueID();
        for (int index = 0; index < actionsData.size(); ++index) {
            ApplicableActionData data = actionsData.get(index);
            if (!Objects.equals(sendMailActionUniqueID, data.getUniqueActionID()) || !data.getExtensionArguments().containsExtArg(QuickTicketServerPlugin.EXTARG_SEND_MAIL_FROM_QT_DATA)) continue;
            String msg = "data of action sendMail must not include sendMail's extension data";
            throw QuickTicketException.forIAE(msg, index, actionSendMail.getDisplayValue());
        }
    }

    public static void throwIfContainsActionsInIncorrectOrder(List<? extends ApplicableActionData> actionsData) {
        Map<String, ActionVO> actionsByUniqueIDs = ActionManager.getInstance().getAll(false).stream().collect(Collectors.toMap(a -> a.getUniqueID(), a -> a));
        List<ActionVO> actions = actionsData.stream().map(data -> (ActionVO)actionsByUniqueIDs.get(data.getUniqueActionID())).collect(Collectors.toList());
        ApplicableQuickTicketVO.throwIfListContainsActionsInIncorrectOrder(actions);
    }

    public static void throwIfContainsUnsupportedActions(List<? extends ApplicableActionData> actionsData) {
        QuickTicketManager qtManager = (QuickTicketManager)ServerPluginManager.getInstance().getSingleInstance(QuickTicketManager.class);
        List supportedActionUniqueIDs = qtManager.getActionsAvailableForQuickTickets().stream().map(ActionVO::getUniqueID).collect(Collectors.toList());
        String editReaStepTextActionUniqueID = ((ActionVO)ActionManager.getInstance().get(-22)).getUniqueID();
        supportedActionUniqueIDs.add(editReaStepTextActionUniqueID);
        for (int index = 0; index < actionsData.size(); ++index) {
            String uniqueActionID = actionsData.get(index).getUniqueActionID();
            if (supportedActionUniqueIDs.contains(uniqueActionID)) continue;
            ActionVO action = TicketManager.getTicketActionChecker().getActionByUniqueID(uniqueActionID, -1);
            String actionDisplayName = action == null ? "" : action.getDisplayValue();
            throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.action.unsupported", new Object[0]), index, actionDisplayName);
        }
    }

    public static void throwIfContainsActionIDsInIncorrectOrder(List<Integer> actionIDs) {
        List<ActionVO> actions = actionIDs.stream().map(id -> (ActionVO)ActionManager.getInstance().get(id.intValue())).collect(Collectors.toList());
        ApplicableQuickTicketVO.throwIfListContainsActionsInIncorrectOrder(actions);
    }

    private static void throwIfListContainsActionsInIncorrectOrder(List<ActionVO> actions) {
        int authorizeActionCount = 0;
        for (int index = 0; index < actions.size(); ++index) {
            boolean lastAction;
            ActionVO action = actions.get(index);
            if (action == null) {
                throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.action.unknown", new Object[0]), index, "");
            }
            if (Status.isDeletedStatus((int)action.getStatusID())) {
                throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.action.invalidStatus", new Object[0]), index, action.getDisplayValue());
            }
            if (5 == action.getId()) {
                if (authorizeActionCount > 0) {
                    throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.action.authorize", new Object[0]), index, action.getDisplayValue());
                }
                ++authorizeActionCount;
            }
            if (!Status.isClosedStatus((int)action.getStatusID())) continue;
            boolean bl = lastAction = index + 1 == actions.size();
            if (lastAction) continue;
            throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.action.closed", new Object[0]), index, action.getDisplayValue());
        }
    }
}

