/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.client.config.handler;

import com.inet.helpdesk.plugin.HelpdeskServerPlugin;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketFolderVO;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketManager;
import com.inet.helpdesk.plugins.quickticket.client.config.data.CreateOrEditQuickTicketFolderRequest;
import com.inet.helpdesk.plugins.quickticket.client.config.data.CreateOrEditQuickTicketFolderResponse;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.remote.gui.angular.usersorgroupsselection.UsersOrGroupsSelection;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class CreateOrEditQuickTicketFolder
extends ServiceMethod<CreateOrEditQuickTicketFolderRequest, CreateOrEditQuickTicketFolderResponse> {
    public String getMethodName() {
        return "quickticket.createoreditquickticketfolder";
    }

    public short getMethodType() {
        return 1;
    }

    public CreateOrEditQuickTicketFolderResponse invoke(HttpServletRequest req, HttpServletResponse resp, CreateOrEditQuickTicketFolderRequest payload) throws IOException {
        CreateOrEditQuickTicketFolderResponse createOrEditQuickTicketFolderResponse;
        String folderId = payload.getFolderId();
        if (folderId != null) {
            GUID folderGuid = GUID.valueOf((String)folderId);
            QuickTicketManager quickTicketManager = (QuickTicketManager)ServerPluginManager.getInstance().getSingleInstance(QuickTicketManager.class);
            QuickTicketFolderVO folder = quickTicketManager.getFolder(folderGuid);
            if (folder == null) {
                throw new ClientMessageException(HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.quickticket.edit.foldernotfound", new Object[0]));
            }
            createOrEditQuickTicketFolderResponse = new CreateOrEditQuickTicketFolderResponse(folder.getID(), folder.getFolderName(), folder.getParentID());
            UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
            if (currentUserAccount == null) {
                throw new ClientMessageException(HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.quickticket.edit.folderaccessdenied", new Object[0]));
            }
            int hdUserID = HDUsersAndGroups.getUserID((GUID)currentUserAccount.getID());
            if (hdUserID == -1) {
                throw new ClientMessageException(HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.quickticket.edit.folderaccessdenied", new Object[0]));
            }
            List<UsersOrGroupsSelection.SelectedMember> folderPermission = folder.getFolderPermission();
            if (folderPermission == null) {
                folderPermission = Collections.singletonList(new UsersOrGroupsSelection.SelectedMember(Type.group, UsersAndGroups.GROUPID_ALLUSERS));
            }
            UsersOrGroupsSelection usersOrGroupsSelection = new UsersOrGroupsSelection(folderPermission);
            createOrEditQuickTicketFolderResponse.setUsersOrGroupsSelection(usersOrGroupsSelection);
        } else {
            createOrEditQuickTicketFolderResponse = new CreateOrEditQuickTicketFolderResponse();
            UsersOrGroupsSelection usersOrGroupsSelection = new UsersOrGroupsSelection(Collections.singletonList(new UsersOrGroupsSelection.SelectedMember(Type.group, UsersAndGroups.GROUPID_ALLUSERS)));
            createOrEditQuickTicketFolderResponse.setUsersOrGroupsSelection(usersOrGroupsSelection);
        }
        return createOrEditQuickTicketFolderResponse;
    }
}

