/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket;

import com.inet.annotations.JsonData;
import com.inet.error.BaseErrorCode;
import com.inet.error.ErrorCode;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.extension.CreateTicketExtension;
import com.inet.helpdesk.core.ticketmanager.extension.CreateTicketExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.plugins.quickticket.ApplyQuickTicketActionExtensionFactory;
import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.quickticket.ReaStepFieldQuickTicketId;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableActionData;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableQuickTicketVO;
import com.inet.helpdesk.plugins.quickticket.api.MutableApplicableActionData;
import com.inet.permissions.AccessDeniedException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class CreateTicketWithQuickTicketExtensionFactory
implements CreateTicketExtensionFactory {
    public static final ExtensionArguments.ExtArg<CreateTicketWithQuickTicketExtensionData> EXTARG_CREATE_TICKET_WITH_QT = new ExtensionArguments.ExtArg<CreateTicketWithQuickTicketExtensionData>(){

        public String getKey() {
            return "quickticketextension.createticketwithqt";
        }

        public Class<CreateTicketWithQuickTicketExtensionData> getValueType() {
            return CreateTicketWithQuickTicketExtensionData.class;
        }

        public String toJson(CreateTicketWithQuickTicketExtensionData value) {
            throw new UnsupportedOperationException("ExtArg with key=\"" + this.getKey() + "\" is not intended to be serialized");
        }

        public CreateTicketWithQuickTicketExtensionData fromJson(String jsonData) {
            throw new UnsupportedOperationException("ExtArg with key=\"" + this.getKey() + "\" is not intended to be serialized");
        }

        public CreateTicketWithQuickTicketExtensionData copyValue(CreateTicketWithQuickTicketExtensionData value) {
            return new CreateTicketWithQuickTicketExtensionData(value.getQuickTicketIntID(), value.getQuickTicketName(), value.getQuickTicket());
        }
    };

    public CreateTicketExtension createIfApplicable(OperationChangedTicket ticket, ExtensionArguments arguments, MutableTicketData ticketFields) {
        CreateTicketWithQuickTicketExtensionData extData = (CreateTicketWithQuickTicketExtensionData)arguments.get(EXTARG_CREATE_TICKET_WITH_QT);
        if (extData == null) {
            return null;
        }
        if (!TicketManager.getTicketActionChecker().checkCurrentUserHasPermissionToExecuteAction(-33)) {
            throw new AccessDeniedException(QuickTicketServerPlugin.MSG.getMsg("CreateFromQuickTicket.QuickTicketActionNotAllowed", new Object[0]), (ErrorCode)BaseErrorCode.AccessDeniedOrFileNotExists);
        }
        return new CreateTicketWithQuickTicketExtension(extData);
    }

    @JsonData
    public static class CreateTicketWithQuickTicketExtensionData {
        private int quickTicketIntID;
        private String quickTicketName;
        private ApplicableQuickTicketVO quickTicket;

        private CreateTicketWithQuickTicketExtensionData() {
        }

        public CreateTicketWithQuickTicketExtensionData(int quickTicketIntID, @Nonnull String quickTicketName, @Nonnull ApplicableQuickTicketVO quickTicket) {
            this.quickTicketIntID = quickTicketIntID;
            this.quickTicketName = quickTicketName;
            this.quickTicket = quickTicket;
        }

        public int getQuickTicketIntID() {
            return this.quickTicketIntID;
        }

        public String getQuickTicketName() {
            return this.quickTicketName;
        }

        public ApplicableQuickTicketVO getQuickTicket() {
            return this.quickTicket;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.quickTicket == null ? 0 : this.quickTicket.hashCode());
            result = 31 * result + this.quickTicketIntID;
            result = 31 * result + (this.quickTicketName == null ? 0 : this.quickTicketName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CreateTicketWithQuickTicketExtensionData other = (CreateTicketWithQuickTicketExtensionData)obj;
            if (this.quickTicket == null ? other.quickTicket != null : !this.quickTicket.equals(other.quickTicket)) {
                return false;
            }
            if (this.quickTicketIntID != other.quickTicketIntID) {
                return false;
            }
            return !(this.quickTicketName == null ? other.quickTicketName != null : !this.quickTicketName.equals(other.quickTicketName));
        }
    }

    private static class CreateTicketWithQuickTicketExtension
    implements CreateTicketExtension {
        private final CreateTicketWithQuickTicketExtensionData extData;

        private CreateTicketWithQuickTicketExtension(@Nonnull CreateTicketWithQuickTicketExtensionData extData) {
            this.extData = extData;
        }

        public void beforeCreate(OperationChangedTicket newTicket, OperationNewReaStep anfrageStep, TicketSubOperations operations) {
            String editStepTextUniqueActionID;
            int quickTicketIntID = this.extData.getQuickTicketIntID();
            String quickTicketName = this.extData.getQuickTicketName();
            ApplicableQuickTicketVO quickTicket = this.extData.getQuickTicket();
            MutableReaStepData reaStepData = new MutableReaStepData();
            reaStepData.put((ReaStepField)ReaStepVO.FIELD_DESC, (Object)quickTicketName);
            reaStepData.put((ReaStepField)ReaStepFieldQuickTicketId.INSTANCE, (Object)quickTicket.getID());
            ActionVO action = (ActionVO)ActionManager.getInstance().get(-33);
            ExtensionArguments extArgs = quickTicket.getExtensionArguments();
            MutableTicketData ticketData = quickTicket.getTicketData();
            List<MutableApplicableActionData> actionsData = quickTicket.getActionsData().stream().map(ApplicableActionData::toMutable).collect(Collectors.toList());
            if (!actionsData.isEmpty() && Objects.equals(editStepTextUniqueActionID = ((ActionVO)ActionManager.getInstance().get(-22)).getUniqueID(), ((MutableApplicableActionData)actionsData.get(0)).getUniqueActionID())) {
                actionsData.remove(0);
            }
            extArgs.put(ApplyQuickTicketActionExtensionFactory.EXTARG_APPLY_QUICK_TICKET_DATA, (Object)new ApplyQuickTicketActionExtensionFactory.ApplyQuickTicketActionExtensionData(quickTicket.getID(), quickTicketIntID, ticketData, actionsData));
            operations.applyAction(newTicket, reaStepData, ReaStepTextVO.empty(), action, extArgs);
        }
    }
}

