/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.swing.shared;

import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.TicketDataConnector;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableActionData;
import com.inet.helpdesk.plugins.quickticket.api.MutableApplicableActionData;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketProcessingTime;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketVO;
import com.inet.helpdesk.shared.model.QuickTicketDataSet;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import java.util.Arrays;
import java.util.List;

public class ConstrainedQuickTicketVO
extends QuickTicketVO {
    private int idint;

    public ConstrainedQuickTicketVO(GUID quickTicketID, String quickTicketName, MutableTicketData ticketData, ExtensionArguments extArgs, List<? extends ApplicableActionData> actionsData, int idint) {
        super(quickTicketID, quickTicketName, ticketData, extArgs, actionsData);
        this.idint = idint;
    }

    public int getIdint() {
        return this.idint;
    }

    public static <X> X convertOldQuickTicketDataSetAndDo(QuickTicketDataSet qt, boolean calledFromApplyQT, QTAction<X> qtAction) {
        MutableTicketData ticketData = new MutableTicketData();
        if (qt.getResID() == 0) {
            HDLogger.warn((Object)String.format("Quick-Ticket with ID=\"%d\" and name=\"%s\" will not be read because reference to resource is missing, therefore data is incomplete and considered as invalid.", qt.getQuiID(), qt.getName()));
            return null;
        }
        UserGroupInfo resource = HDUsersAndGroups.getResource((int)qt.getResID());
        if (resource == null) {
            HDLogger.warn((Object)String.format("Quick-Ticket with ID=\"%d\" and name=\"%s\" references resource with ID=\"%d\", which could not be found.", qt.getQuiID(), qt.getName(), qt.getResID()));
            return null;
        }
        ticketData.put((TicketField)Tickets.FIELD_RESOURCE_GUID, (Object)resource.getID());
        ticketData.put((TicketField)Tickets.FIELD_PRIORITY_ID, (Object)qt.getPriID());
        ticketData.putValidOrDefaultValue((TicketField)Tickets.FIELD_CATEGORY_ID, (Object)qt.getBetID());
        ticketData.putValidOrDefaultValue((TicketField)Tickets.FIELD_SUBJECT, (Object)qt.getSubject());
        ticketData.putValidOrDefaultValue("custom1", (Object)qt.getBunFeld1());
        ticketData.putValidOrDefaultValue("custom2", (Object)qt.getBunFeld2());
        ticketData.putValidOrDefaultValue("custom3", (Object)qt.getBunFeld3());
        ticketData.putValidOrDefaultValue("custom4", (Object)qt.getBunFeld4());
        ticketData.putValidOrDefaultValue((TicketField)Tickets.FIELD_IDENTIFIER, (Object)qt.getIdentifier());
        ticketData.putValidOrDefaultValue((TicketField)Tickets.FIELD_ITIL_ID, (Object)qt.getItiID());
        ticketData.putValidOrDefaultValue((TicketField)Tickets.FIELD_CLASSIFICATION_ID, (Object)qt.getKlaID());
        if (calledFromApplyQT) {
            deadline = qt.getDeadline() == null ? null : Long.valueOf(qt.getDeadline().getTime());
            ticketData.putValidOrDefaultValue((TicketField)Tickets.FIELD_DEADLINE, (Object)deadline);
            targetTime = qt.getTargetTime();
            ticketData.putValidOrDefaultValue((TicketField)Tickets.FIELD_TARGET_TIME, (Object)targetTime);
        } else {
            deadline = qt.getDeadline();
            if (deadline != null) {
                ticketData.putValidOrDefaultValue((TicketField)Tickets.FIELD_DEADLINE, (Object)deadline.getTime());
            }
            if ((targetTime = qt.getTargetTime()) != null) {
                ticketData.putValidOrDefaultValue((TicketField)Tickets.FIELD_TARGET_TIME, (Object)targetTime);
            }
        }
        ActionVO action = (ActionVO)ActionManager.getInstance().get(qt.getAktID());
        if (action == null) {
            HDLogger.warn((Object)String.format("Quick-Ticket with ID=\"%d\" and name=\"%s\" will not be read because it references non-existing action.", qt.getQuiID(), qt.getName()));
            return null;
        }
        ReaStepTextVO stepText = ReaStepTextVO.of((String)qt.getProcessingText(), (boolean)qt.isIshtmlPt());
        MutableReaStepData stepData = new MutableReaStepData();
        stepData.put((ReaStepField)ReaStepVO.FIELD_PROCESSING_TIME, (Object)QuickTicketProcessingTime.createRelativeProcessingTime(qt.getProcessingTime()));
        ExtensionArguments extArgs = ExtensionArguments.create();
        if (qt.getAutomailSetting() == 0) {
            extArgs.put(ExtensionArguments.EXTARG_AUTO_MAIL, (Object)TicketDataConnector.MailNotification.NO_MAILS_TO_ENDUSER);
        }
        MutableApplicableActionData actionData = new MutableApplicableActionData(action.getUniqueID(), stepData, stepText, ExtensionArguments.create());
        boolean isSubjectEmptyAfterTrim = ((String)ticketData.get((TicketField)Tickets.FIELD_SUBJECT)).trim().isEmpty();
        ReaStepTextVO updatedText = ReaStepTextVO.of((String)qt.getTicketText(), (boolean)qt.isIshtml());
        if (isSubjectEmptyAfterTrim && updatedText.isEmpty()) {
            HDLogger.warn((Object)String.format("Quick-Ticket with ID=\"%d\" and name=\"%s\" will not be read because defined subject and ticket text are both empty after trim, therefore data is incomplete and considered as invalid.", qt.getQuiID(), qt.getName()));
            return null;
        }
        if (isSubjectEmptyAfterTrim) {
            String generatedSubject = updatedText.hasHtmlContent() ? HtmlConverter.html2text((String)updatedText.getText()) : updatedText.getText();
            generatedSubject = generatedSubject.replace("\r", "").replace("\n", " ").replace("\t", " ");
            generatedSubject = generatedSubject.substring(0, Math.min(50, generatedSubject.length()));
            ticketData.put((TicketField)Tickets.FIELD_SUBJECT, (Object)generatedSubject);
        } else if (updatedText.isEmpty()) {
            updatedText = ReaStepTextVO.of((String)((String)ticketData.get((TicketField)Tickets.FIELD_SUBJECT)), (boolean)false);
        }
        String actionUniqueID = ((ActionVO)ActionManager.getInstance().get(-22)).getUniqueID();
        MutableApplicableActionData editInquiryTextActionData = new MutableApplicableActionData(actionUniqueID, new MutableReaStepData(), updatedText, ExtensionArguments.create());
        return qtAction.run(qt.getName(), ticketData, extArgs, Arrays.asList(editInquiryTextActionData, actionData));
    }

    public static interface QTAction<X> {
        public X run(String var1, MutableTicketData var2, ExtensionArguments var3, List<MutableApplicableActionData> var4);
    }
}

