/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.api;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class SendMailFromQuickTicketExtensionData {
    private EmailEntry sender;
    private List<EmailEntry> an;
    private List<EmailEntry> cc;
    private List<EmailEntry> bcc;

    private SendMailFromQuickTicketExtensionData() {
    }

    public SendMailFromQuickTicketExtensionData(@Nullable EmailEntry sender, List<EmailEntry> an, List<EmailEntry> cc, List<EmailEntry> bcc) {
        this.throwIfInvalid(an, "an", 1023);
        this.throwIfInvalid(cc, "cc", 1023);
        this.throwIfInvalid(bcc, "bcc", 1023);
        this.sender = sender;
        this.an = new ArrayList<EmailEntry>(an);
        this.cc = new ArrayList<EmailEntry>(cc);
        this.bcc = new ArrayList<EmailEntry>(bcc);
    }

    private void throwIfInvalid(List<EmailEntry> list, String displayName, int concatenatedEmailsLengthLimit) {
        if (list == null) {
            throw QuickTicketException.forIAE("list '" + displayName + "' must not be null");
        }
        if (list.contains(null)) {
            throw QuickTicketException.forIAE("list '" + displayName + "' must not contain null");
        }
        String allEmails = SendMailFromQuickTicketExtensionData.concatEmailAddresses(list);
        if (allEmails.length() > concatenatedEmailsLengthLimit) {
            throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.tooManyEmailAddresses", new Object[]{displayName}));
        }
    }

    @Nullable
    public EmailEntry getSender() {
        return this.sender;
    }

    public List<EmailEntry> getAn() {
        return Collections.unmodifiableList(this.an);
    }

    public List<EmailEntry> getCc() {
        return Collections.unmodifiableList(this.cc);
    }

    public List<EmailEntry> getBcc() {
        return Collections.unmodifiableList(this.bcc);
    }

    public static String concatEmailAddresses(List<EmailEntry> entries) {
        return entries.stream().map(EmailEntry::getEmail).collect(Collectors.joining(";"));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.an == null ? 0 : this.an.hashCode());
        result = 31 * result + (this.bcc == null ? 0 : this.bcc.hashCode());
        result = 31 * result + (this.cc == null ? 0 : this.cc.hashCode());
        result = 31 * result + (this.sender == null ? 0 : this.sender.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SendMailFromQuickTicketExtensionData other = (SendMailFromQuickTicketExtensionData)obj;
        if (this.an == null ? other.an != null : !this.an.equals(other.an)) {
            return false;
        }
        if (this.bcc == null ? other.bcc != null : !this.bcc.equals(other.bcc)) {
            return false;
        }
        if (this.cc == null ? other.cc != null : !this.cc.equals(other.cc)) {
            return false;
        }
        return !(this.sender == null ? other.sender != null : !this.sender.equals(other.sender));
    }

    @JsonData
    public static class EmailEntry {
        private String id;
        private String displayName;
        private String email;
        private EmailEntryType type;

        private EmailEntry() {
        }

        public EmailEntry(@Nullable String id, @Nullable String displayName, @Nonnull String email, @Nonnull EmailEntryType type) {
            if (email.trim().isEmpty()) {
                throw QuickTicketException.forIAE("email must not be empty after trim");
            }
            this.id = id;
            this.displayName = displayName;
            this.email = email;
            this.type = type;
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        @Nullable
        public String getDisplayName() {
            return this.displayName;
        }

        @Nonnull
        public String getEmail() {
            return this.email;
        }

        @Nonnull
        public EmailEntryType getType() {
            return this.type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
            result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EmailEntry other = (EmailEntry)obj;
            if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
                return false;
            }
            if (this.email == null ? other.email != null : !this.email.equals(other.email)) {
                return false;
            }
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return this.type == other.type;
        }
    }

    public static enum EmailEntryType {
        USER,
        RESOURCE,
        MAILBOX,
        CUSTOM;

    }
}

