/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.api;

import com.inet.helpdesk.plugins.quickticket.api.QuickTicketException;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketFolderVO;
import com.inet.id.GUID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class QuickTicketFolderStructureVO {
    private List<NodeVO> nodes;

    private QuickTicketFolderStructureVO(List<NodeVO> nodes) {
        this.nodes = nodes;
    }

    public List<NodeVO> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public NodeVO find(GUID folderID) {
        if (folderID == null) {
            throw QuickTicketException.forIAE("folderID must not be null");
        }
        return this.find(folderID, this.nodes);
    }

    private NodeVO find(GUID folderID, List<NodeVO> nodesToCheck) {
        for (NodeVO node : nodesToCheck) {
            if (!node.getFolder().getID().equals((Object)folderID)) continue;
            return node;
        }
        for (NodeVO node : nodesToCheck) {
            NodeVO matchedNode = this.find(folderID, node.getChildren());
            if (matchedNode == null) continue;
            return matchedNode;
        }
        return null;
    }

    public static QuickTicketFolderStructureVO create(List<QuickTicketFolderVO> allFolders) {
        if (allFolders == null) {
            throw QuickTicketException.forIAE("list of folders must not be null");
        }
        if (allFolders.contains(null)) {
            throw QuickTicketException.forIAE("list of folders must not contain null");
        }
        ArrayList<QuickTicketFolderVO> rootFolders = new ArrayList<QuickTicketFolderVO>();
        HashMap<GUID, List> parentToChildrenMap = new HashMap<GUID, List>();
        for (QuickTicketFolderVO folder : allFolders) {
            GUID parentFolderID = folder.getParentID();
            if (parentFolderID == null) {
                rootFolders.add(folder);
                continue;
            }
            parentToChildrenMap.computeIfAbsent(parentFolderID, k -> new ArrayList()).add(folder);
        }
        List<NodeVO> rootNodes = rootFolders.stream().map(f -> QuickTicketFolderStructureVO.createNodeFor(f, null, parentToChildrenMap)).collect(Collectors.toList());
        return new QuickTicketFolderStructureVO(rootNodes);
    }

    private static NodeVO createNodeFor(QuickTicketFolderVO folder, @Nullable NodeVO parent, Map<GUID, List<QuickTicketFolderVO>> parentToChildrenMap) {
        NodeVO node = new NodeVO(folder, parent);
        ArrayList<NodeVO> children = new ArrayList<NodeVO>();
        List<QuickTicketFolderVO> subFolders = parentToChildrenMap.remove(folder.getID());
        if (subFolders != null) {
            subFolders.stream().forEach(f -> children.add(QuickTicketFolderStructureVO.createNodeFor(f, node, parentToChildrenMap)));
        }
        node.setChildren(children);
        return node;
    }

    public static class NodeVO {
        private QuickTicketFolderVO folder;
        private NodeVO parent;
        private List<NodeVO> children;

        private NodeVO(QuickTicketFolderVO folder, @Nullable NodeVO parent) {
            this.folder = folder;
            this.parent = parent;
        }

        private void setChildren(List<NodeVO> children) {
            this.children = children;
        }

        public QuickTicketFolderVO getFolder() {
            return this.folder;
        }

        @Nullable
        public NodeVO getParent() {
            return this.parent;
        }

        public List<NodeVO> getChildren() {
            return Collections.unmodifiableList(this.children);
        }

        public boolean hasDescendant(GUID folderID) {
            if (folderID == null) {
                throw QuickTicketException.forIAE("folderID must not be null");
            }
            if (this.children.stream().anyMatch(child -> folderID.equals((Object)child.getFolder().getID()))) {
                return true;
            }
            return this.children.stream().anyMatch(child -> child.hasDescendant(folderID));
        }
    }
}

