/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.api;

import com.inet.helpdesk.core.ticketmanager.TicketActionChecker;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.shared.model.Status;
import java.util.ArrayList;
import java.util.List;

public class AutoReactAndAuthChecker {
    public static AutoReactAndAuthCheckResult check(TicketVO ticket, List<Integer> idsOfActionsToApply) {
        boolean reactivationRequired = Status.isClosedOrDeletedStatus((int)ticket.getStatusID());
        boolean authorizationRequired = AutoReactAndAuthChecker.requiresAutoAuthorization(ticket, idsOfActionsToApply);
        return new AutoReactAndAuthCheckResult(reactivationRequired, authorizationRequired);
    }

    private static boolean requiresAutoAuthorization(TicketVO ticket, List<Integer> idsOfActionsToApply) {
        if (ticket.isDispatched()) {
            return false;
        }
        TicketVO dummyInquiry = AutoReactAndAuthChecker.createDummyInquiryBasedOn(ticket);
        List allActions = ActionManager.getInstance().getAll(false);
        List<Integer> idsOfActionsPossibleForInquiry = AutoReactAndAuthChecker.getPossibleActionsForTicket(dummyInquiry, allActions);
        for (int actionID : idsOfActionsToApply) {
            if (5 == actionID) {
                return false;
            }
            if (idsOfActionsPossibleForInquiry.contains(actionID)) continue;
            return true;
        }
        return false;
    }

    private static TicketVO createDummyInquiryBasedOn(TicketVO ticket) {
        MutableTicketAttributes attributes = new MutableTicketAttributes();
        ticket.getIncludedAttributes().stream().forEach(att -> attributes.put(att, ticket.getAttribute(att)));
        attributes.put((TicketAttribute)Tickets.ATTRIBUTE_STATUS_ID, (Object)0);
        attributes.put((TicketAttribute)Tickets.ATTRIBUTE_DISPATCHING_REA_STEP_ID, null);
        MutableTicketData ticketData = new MutableTicketData();
        ticket.getIncludedFields().stream().forEach(field -> ticketData.put(field, ticket.getValue(field)));
        return TicketVOSingle.create((int)Integer.MAX_VALUE, (MutableTicketAttributes)attributes, (MutableTicketData)ticketData);
    }

    private static List<Integer> getPossibleActionsForTicket(TicketVO ticket, List<ActionVO> allActions) {
        TicketActionChecker actionChecker = TicketManager.getTicketActionChecker();
        ArrayList<Integer> possibleActions = new ArrayList<Integer>();
        TicketPermissionContext ticketPermissionInfo = TicketPermissionContext.artificialFullAccess((boolean)ticket.isInquiry());
        for (ActionVO action : allActions) {
            if (actionChecker.checkAction(action, ticket, ticketPermissionInfo) != null) continue;
            possibleActions.add(action.getId());
        }
        return possibleActions;
    }

    public static class AutoReactAndAuthCheckResult {
        private boolean reactivationRequired;
        private boolean authorizationRequired;

        public AutoReactAndAuthCheckResult(boolean reactivationRequired, boolean authorizationRequired) {
            this.reactivationRequired = reactivationRequired;
            this.authorizationRequired = authorizationRequired;
        }

        public boolean isReactivationRequired() {
            return this.reactivationRequired;
        }

        public boolean isAuthorizationRequired() {
            return this.authorizationRequired;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.authorizationRequired ? 1231 : 1237);
            result = 31 * result + (this.reactivationRequired ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AutoReactAndAuthCheckResult other = (AutoReactAndAuthCheckResult)obj;
            if (this.authorizationRequired != other.authorizationRequired) {
                return false;
            }
            return this.reactivationRequired == other.reactivationRequired;
        }
    }
}

