'use strict';clearreportsApp.factory("promptFactory",function($rootScope,dataservice,errorservice){var promptCustomRenderer=[];var promptValueConverter={};var taskPlannerPlaceholdersSupported=false;var relativeDatesSupported=false;var $this=this;this.setSupportsTaskPlannerPlaceholders=function(supportsTaskPlannerPlaceholders){taskPlannerPlaceholdersSupported=supportsTaskPlannerPlaceholders};this.supportsTaskPlannerPlaceholders=function(){return taskPlannerPlaceholdersSupported};this.setSupportsRelativeDates=
function(supportsRelativeDates){relativeDatesSupported=supportsRelativeDates};this.supportsRelativeDates=function(){return relativeDatesSupported};this.registerPromptCustomRenderer=function(rendererFunction){promptCustomRenderer.push(rendererFunction)};this.getPromptCustomRenderer=function(prompt){for(var i=0;i<promptCustomRenderer.length;i++){var renderer=promptCustomRenderer[i];var result=renderer(prompt);if(result!==false)return result}return false};this.registerPromptValueConverter=function(type,
formatter,parser){var nil=function(value){return value};if(formatter==undefined)formatter=nil;if(parser==undefined)parser=nil;promptValueConverter[type]={format:formatter,parse:parser}};this.registerPromptValueConverter("prompttype_default");this.registerPromptValueConverter("prompttype_string",function(value){return"'"+value.replace(/'/g,"''")+"'"},function(value){if(value.indexOf("'")==0&&value.lastIndexOf("'")==value.length-1)return value.substring(1,value.length-1).replace(/''/g,"'");return""});
this.registerPromptValueConverter("prompttype_password",function(value){return"'"+value+"'"},function(value){if(value.indexOf("'")==0&&value.lastIndexOf("'")==value.length-1)return value.substring(1,value.length-1);return""});this.registerPromptValueConverter("prompttype_boolean",function(value){if(value.toLowerCase()=="true")return"true";if(value.toLowerCase()=="false")return"false";return""},function(value){if(value.length==0)return"";if(value.toLowerCase()=="true")value="true";else value="false";
return value});var formatNumber=function(value){var dummyLocaleNumber=(4.5).toLocaleString($("html").attr("locale"),{useGrouping:false});var decimalSeparator=dummyLocaleNumber.substring(1,2);var seperatorCount=0;var dsc=decimalSeparator.charCodeAt(0);for(var c=0;c<value.length;c++){var ch=value.charCodeAt(c);var validChar=false;validChar|=ch>=48&&ch<=57;validChar|=ch==dsc&&seperatorCount==0;validChar|=ch==45&&c==0;if(!validChar){value=value.slice(0,c)+value.slice(c+1);c--;continue}if(ch==dsc){value=
value.slice(0,c)+"."+value.slice(c+1);seperatorCount++}}if(value.length==0)return"";var floatNmbr=parseFloat(value);if(isNaN(floatNmbr))return"";return floatNmbr.toLocaleString("en-US",{useGrouping:false,minimumFractionDigits:1,maximumFractionDigits:13})};var parseNumber=function(value){var floatNmbr=parseFloat(value);if(isNaN(floatNmbr))return"";return floatNmbr.toLocaleString($("html").attr("locale"),{useGrouping:false,maximumFractionDigits:13})};this.registerPromptValueConverter("prompttype_number",
formatNumber,parseNumber);this.registerPromptValueConverter("prompttype_currency",formatNumber,parseNumber);var ensureDigestCount=function(value,timeValue){if(value==undefined)return value;var parts=value.split(",");for(var i=0;i<parts.length;i++){var p=parts[i];var minlength=i>0||timeValue===true?2:4;while(p.length<minlength)p="0"+p;parts[i]=p}return parts.join(",")};this.registerPromptValueConverter("prompttype_date",function(value){if(value=="")return"";var date=moment(value,"L");if(!date.isValid()){if(taskPlannerPlaceholdersSupported)return value;
return""}var dateStr=date.format("YYYY,MM,DD");return"Date("+dateStr+")"},function(value){if(value.indexOf("Date(")==0&&value.lastIndexOf(")")==value.length-1){var dateStr=value.substring(5,value.length-1);dateStr=ensureDigestCount(dateStr.replace(/\s/g,""));var date=moment(dateStr,"YYYY,MM,DD",true);if(!date.isValid())return"";return date.format("L")}return""});this.registerPromptValueConverter("prompttype_time",function(value){if(value=="")return"";var time=moment(value,"LTS");if(!time.isValid()){if(taskPlannerPlaceholdersSupported)return value;
return""}var timeStr=time.format("HH,mm,ss");return"Time("+timeStr+")"},function(value){if(value.indexOf("Time(")==0&&value.lastIndexOf(")")==value.length-1){var timeStr=value.substring(5,value.length-1);timeStr=ensureDigestCount(timeStr.replace(/\s/g,""),true);var time=moment(timeStr,"HH,mm,ss");if(!time.isValid())return"";return time.format("LTS")}return""});this.registerPromptValueConverter("prompttype_datetime",function(value){if(value=="")return"";var datetime=moment(value,"L LTS");if(!datetime.isValid())return"";
var dateStr=datetime.format("YYYY,MM,DD,HH,mm,ss");return"DateTime("+dateStr+")"},function(value){if(value.indexOf("DateTime(")==0&&value.lastIndexOf(")")==value.length-1){var datetimeStr=value.substring(9,value.length-1);datetimeStr=ensureDigestCount(datetimeStr.replace(/\s/g,""));var datetime=moment(datetimeStr,"YYYY,MM,DD,HH,mm,ss",true);if(!datetime.isValid())return"";return datetime.format("L")+" "+datetime.format("LTS")}return""});this.getPromptValueConverter=function(type){var valueConverter=
promptValueConverter[type];if(valueConverter==undefined)valueConverter=promptValueConverter["prompttype_default"];if(taskPlannerPlaceholdersSupported){var originalConverter=valueConverter;valueConverter={format:function(value){if(type!="prompttype_string"&&type!="prompttype_password")if(value!=undefined){var placeHolderStart=value.indexOf("{");if(placeHolderStart>=0){var placeHolderEnd=value.indexOf("}",placeHolderStart+1);if(placeHolderEnd>placeHolderStart+1)return promptValueConverter["prompttype_default"].format(value)}}return originalConverter.format(value)},
parse:function(value){if(type!="prompttype_string"&&type!="prompttype_password")if(value!=undefined){var placeHolderStart=value.indexOf("{");if(placeHolderStart>=0){var placeHolderEnd=value.indexOf("}",placeHolderStart+1);if(placeHolderEnd>placeHolderStart+1)return promptValueConverter["prompttype_default"].parse(value)}}return originalConverter.parse(value)}}}return{format:function(value){if(value==undefined)return undefined;if(value=="formula:null"||value=="null")return"formula:null";return valueConverter.format(value)},
parse:function(value){if(value==undefined)return undefined;if(value=="formula:null"||value=="null")return"formula:null";return valueConverter.parse(value)}}};this.loadPrompts=function(values,engineProperties,callback){errorservice.clearErrorContent("#promptpanelerrors");dataservice.execute("promptdialog_loadprompts",{data:JSON.stringify({plainValues:values,engineProperties:engineProperties}),alertSelector:"#promptpanelerrors",handleSuccess:function(response){callback(response.prompts)},beforeExecute:function(){},
afterExecute:function(){}})};this.loadDefaultValues=function(engineProperties,promptValues,promptName,filter,fromIndex,toIndex,callback){dataservice.execute("promptdialog_loaddefaultvalues",{alertSelector:"#prompterror",data:JSON.stringify({engineProperties:engineProperties,promptValues:promptValues,promptName:promptName,filter:filter,fromIndex:fromIndex,toIndex:toIndex}),handleSuccess:function(response){callback(response.options)}})};this.validatePrompts=function(engineproperties,values,callback){errorservice.clearErrorContent("#promptpanelerrors");
dataservice.execute("promptdialog_validateprompts",{data:JSON.stringify({engineProperties:engineproperties,promptValues:values}),alertSelector:"#promptpanelerrors",handleSuccess:function(response){callback(response.errors)}})};this.isValidValue=function(promptRenderType,promptValue,enteredValue){if(enteredValue==undefined||enteredValue.length==0)return true;if(promptValue!=undefined&&promptValue.defaultValue)return true;if(promptValue!=undefined&&promptValue.from!=undefined){var serialized=$this.serializePromptValue(promptValue,
false,true,promptRenderType=="prompttype_string");if(serialized==enteredValue)return true}var converter=$this.getPromptValueConverter(promptRenderType);var formatted=converter.format(enteredValue);var parsed=converter.parse(formatted);return parsed==enteredValue};this.serializePromptValue=function(promptValue,multi,allowDummy,acceptEmptyValues){var result="";if(promptValue==undefined)return result;var values=multi?promptValue.values:[promptValue];if(values==undefined)return result;if(multi)result+=
"[";var elementCount=0;for(var i=0;i<values.length;i++){var val=values[i];if(val.dummy===true)if(!allowDummy)continue;var currentValue="";if(val.includeFrom!=undefined){var validRange=false;if(acceptEmptyValues)validRange=val.from.value!=undefined&&val.from.value.length>0||val.to.value!=undefined&&val.to.value.length>0;else validRange=val.from.value!=undefined&&val.from.value.length>0&&val.to.value!=undefined&&val.to.value.length>0;if(validRange){currentValue=acceptEmptyValues&&val.from.value==undefined?
"''":val.from.value;currentValue+=" ";if(!val.includeFrom)currentValue+="_";currentValue+="to";if(!val.includeTo)currentValue+="_";currentValue+=" ";currentValue+=acceptEmptyValues&&val.to.value==undefined?"''":val.to.value}}else if(val.value!=undefined&&val.value.length>0)currentValue=val.value;if(multi)if("formula:null"==currentValue)currentValue="null";if(currentValue!=undefined&&currentValue.length>0){if(elementCount>0)result+=",";elementCount++;result+=currentValue}}if(multi)result+="]";return result};
this.relativeIntervals={};this.relativeIntervals["yyyy"]={label:{"discrete":"promptpanel.relative.interval.discrete.year","range":"promptpanel.relative.interval.range.year"},formula:"DateTime(Year(CurrentDateTime),1,1)"};this.relativeIntervals["q"]={label:{"discrete":"promptpanel.relative.interval.discrete.quarter","range":"promptpanel.relative.interval.range.quarter"},formula:"DateTime(Year(CurrentDateTime),floor((Month(CurrentDateTime)-1)/3)*3+1,1)"};this.relativeIntervals["m"]={label:{"discrete":"promptpanel.relative.interval.discrete.month",
"range":"promptpanel.relative.interval.range.month"},formula:"DateTime(Year(CurrentDateTime),Month(CurrentDateTime),1)"};this.relativeIntervals["ww"]={label:{"discrete":"promptpanel.relative.interval.discrete.week","range":"promptpanel.relative.interval.range.week"},formula:"DateTime(Date(DateAdd('d',-(DayOfWeek(CurrentDateTime)-2),CurrentDateTime)))"};this.relativeIntervals["d"]={label:{"discrete":"promptpanel.relative.interval.discrete.day","range":"promptpanel.relative.interval.range.day"},formula:"DateTime(Year(CurrentDateTime),Month(CurrentDateTime),Day(CurrentDateTime))"};
this.relativeIntervals["h"]={label:{"discrete":"promptpanel.relative.interval.discrete.hour","range":"promptpanel.relative.interval.range.hour"},formula:"DateTime(Year(CurrentDateTime),Month(CurrentDateTime),Day(CurrentDateTime),Hour(CurrentDateTime),0,0)"};this.parseDateTimeFormula=function(formulaValue,isDateTime){if(!relativeDatesSupported)return false;if(formulaValue==undefined||formulaValue.length==0)return false;formulaValue=formulaValue.replace(/\s/g,"");if(formulaValue.length==0)return false;
if(!isDateTime){let converter=promptValueConverter["prompttype_date"];let parsed=converter.parse(formulaValue);if(parsed!="")return false;if(formulaValue.indexOf("Date(DateAdd(")==0&&formulaValue.lastIndexOf("))")==formulaValue.length-2)formulaValue=formulaValue.substring(5,formulaValue.length-1)}if(formulaValue.indexOf("DateAdd(")==0&&formulaValue.lastIndexOf(")")==formulaValue.length-1){formulaValue=formulaValue.substring(8,formulaValue.length-1);var quote=formulaValue.substring(0,1);var interval=
formulaValue.substring(1,quote=="'"||quote=="'"?formulaValue.indexOf(quote,1):-1);formulaValue=formulaValue.substring(interval.length+3);var intervalNumber=formulaValue.substring(0,formulaValue.indexOf(","));var startFormula=formulaValue.substring(intervalNumber.length+1);var custom=true;if($this.relativeIntervals[interval]!=undefined&&$this.relativeIntervals[interval].formula==startFormula)if(parseInt(intervalNumber)+""==intervalNumber)custom=false;return{custom:custom,interval:interval,intervalNumber:parseInt(intervalNumber)}}else{let converter=
promptValueConverter[isDateTime?"prompttype_datetime":"prompttype_date"];let parsed=converter.parse(formulaValue);if(parsed=="")return{custom:true};return false}};return this});