/*
 * Decompiled with CFR 0.152.
 */
package com.inet.processbridge.jsonrpc;

import com.inet.annotations.JsonData;
import com.inet.processbridge.jsonrpc.JsonRpcRequest;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonData
public abstract class JsonRpcPacket {
    private String jsonrpc;
    private String method;
    private List<Object> params;
    private Object result;
    private HashMap<String, Object> error;
    private Object id;

    JsonRpcPacket() {
    }

    JsonRpcPacket(String method, List<Object> params, int id) {
        this.jsonrpc = "2.0";
        this.method = method;
        this.params = params;
        this.id = id;
    }

    JsonRpcPacket(JsonRpcRequest request, Object result, HashMap<String, Object> error) {
        this.jsonrpc = "2.0";
        this.result = result;
        this.error = error;
        if (request != null) {
            this.id = request.getId();
        }
    }

    public static Field[] getDeclaredFields() {
        return new Field[0];
    }

    public String getMethod() {
        return this.method;
    }

    public List<Object> getParams() {
        return this.params;
    }

    public Object getParam(int idx) {
        if (this.params != null) {
            return this.params.get(idx);
        }
        return null;
    }

    public Object getResult() {
        return this.result;
    }

    public Map<String, Object> getError() {
        return this.error;
    }

    public int getErrorCode() {
        if (this.error != null) {
            try {
                return Integer.parseInt((String)this.error.get("code"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 0;
    }

    public Object getId() {
        return this.id;
    }
}

