/*
 * Decompiled with CFR 0.152.
 */
package com.inet.processbridge;

import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.processbridge.api.DefaultProcessBridgeApi;
import com.inet.processbridge.api.ProcessBridgeApi;
import com.inet.processbridge.callback.OutputStreamCallback;
import com.inet.processbridge.handler.BridgeCoreApi;
import com.inet.processbridge.handler.f;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;

@PluginInfo(group="interfaces;integration", id="processbridge", flags="optional", version="25.10.314", packages="com.inet.processbridge.api")
public class ProcessBridgeServerPlugin
implements ServerPlugin {
    public static final String ID = "processbridge";
    public static final Logger LOGGER = LogManager.getLogger((String)"processbridge");

    public void registerExtension(ServerPluginManager spm) {
        DefaultProcessBridgeApi defaultProcessBridgeApi = new DefaultProcessBridgeApi(true){

            @Override
            public void add(@Nonnull String className, @Nonnull String methodName, @Nonnull Method method, boolean isAsynchrony) {
                switch (methodName) {
                    case "get": {
                        Class<?>[] classArray = method.getParameterTypes();
                        if (classArray.length == 1 && classArray[0] == String.class) break;
                        return;
                    }
                    case "put": {
                        Class<?>[] classArray = method.getParameterTypes();
                        if (classArray.length == 2 && classArray[0] == String.class) break;
                        return;
                    }
                }
                super.add(className, methodName, method, isAsynchrony);
            }
        };
        defaultProcessBridgeApi.add(Configuration.class);
        spm.register(ProcessBridgeApi.class, (Object)defaultProcessBridgeApi);
        defaultProcessBridgeApi = new DefaultProcessBridgeApi();
        defaultProcessBridgeApi.add(ConfigurationManager.class);
        defaultProcessBridgeApi.add(BridgeCoreApi.class);
        defaultProcessBridgeApi.add(OutputStreamCallback.class);
        spm.register(ProcessBridgeApi.class, (Object)defaultProcessBridgeApi);
    }

    public void init(ServerPluginManager spm) {
        final InputStream inputStream = (InputStream)spm.getOptionalInstance(InputStream.class);
        final OutputStream outputStream = (OutputStream)spm.getOptionalInstance(OutputStream.class);
        if (inputStream != null && outputStream != null) {
            Thread thread = new Thread(ID){

                @Override
                public void run() {
                    try (InputStream inputStream2 = inputStream;
                         OutputStream outputStream2 = outputStream;){
                        new f(inputStream, outputStream).run();
                    }
                    catch (IOException iOException) {
                        LOGGER.debug((Object)iOException);
                    }
                }
            };
            thread.start();
        }
    }

    public void reset() {
    }

    public void restart() {
    }
}

