/*
 * Decompiled with CFR 0.152.
 */
package com.inet.processbridge.api;

import com.inet.annotations.InternalApi;
import com.inet.processbridge.ProcessBridgeServerPlugin;
import com.inet.processbridge.api.ConstructorDescription;
import com.inet.processbridge.api.ExecutableDescription;
import com.inet.processbridge.api.MethodDescription;
import com.inet.processbridge.api.ProcessBridgeApi;
import com.inet.processbridge.api.a;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class DefaultProcessBridgeApi
implements ProcessBridgeApi {
    private Map<String, ExecutableDescription> d;
    private Set<Class<?>> e;
    private final boolean f;

    public DefaultProcessBridgeApi() {
        this(false);
    }

    public DefaultProcessBridgeApi(boolean isAsynchronous) {
        this.f = isAsynchronous;
    }

    @Override
    @Nullable
    public ExecutableDescription get(String methodName) {
        this.a();
        return this.d.get(methodName);
    }

    public void add(@Nonnull Class<?> clazz) {
        if (this.e == null) {
            this.e = new HashSet();
        }
        this.e.add(clazz);
    }

    public void add(@Nonnull Method method) {
        try {
            method.setAccessible(true);
        }
        catch (SecurityException securityException) {
            ProcessBridgeServerPlugin.LOGGER.error((Throwable)securityException);
        }
        String string = method.getDeclaringClass().getName();
        String string2 = method.getName();
        this.add(string, string2, method, this.f);
    }

    public void add(@Nonnull Constructor<?> constructor) {
        try {
            constructor.setAccessible(true);
        }
        catch (SecurityException securityException) {
            ProcessBridgeServerPlugin.LOGGER.error((Throwable)securityException);
        }
        String string = constructor.getDeclaringClass().getName();
        String string2 = "<init>";
        this.add(string, string2, constructor, this.f);
    }

    public void add(@Nonnull String className, @Nonnull String methodName, @Nonnull Constructor<?> constructor, boolean isAsynchrony) {
        String string;
        ExecutableDescription executableDescription;
        if (this.d == null) {
            this.d = new HashMap<String, ExecutableDescription>();
        }
        if ((executableDescription = this.d.put(string = className + "." + methodName, new ConstructorDescription(constructor, isAsynchrony))) != null) {
            this.d.put(string, new a(constructor));
        }
    }

    public void add(@Nonnull String className, @Nonnull String methodName, @Nonnull Method method, boolean isAsynchrony) {
        String string;
        ExecutableDescription executableDescription;
        if (this.d == null) {
            this.d = new HashMap<String, ExecutableDescription>();
        }
        if ((executableDescription = this.d.put(string = className + "." + methodName, new MethodDescription(method, isAsynchrony))) != null && !Objects.equals(method, executableDescription.getExecutable())) {
            this.d.put(string, new a(method));
        }
    }

    private void a() {
        if (this.e != null) {
            for (Class<?> clazz : this.e) {
                for (Constructor<?> constructor : clazz.getConstructors()) {
                    this.add(constructor);
                }
                for (Executable executable : clazz.getMethods()) {
                    this.add((Method)executable);
                }
            }
            this.e = null;
        }
    }
}

