/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.processbridge.api;

import com.inet.annotations.InternalApi;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

@InternalApi
public class LittleEndianInputStream
extends DataInputStream {
    public LittleEndianInputStream(InputStream in) {
        super(in);
    }

    public short readShortLE() throws IOException {
        int n;
        int n2 = this.in.read();
        if ((n2 | (n = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 0) + (n << 8));
    }

    public int readIntLE() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.in.read();
        if ((n4 | (n3 = this.in.read()) | (n2 = this.in.read()) | (n = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 0) + (n3 << 8) + (n2 << 16) + (n << 24);
    }

    public long readLongLE() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = this.in.read();
        if ((n8 | (n7 = this.in.read()) | (n6 = this.in.read()) | (n5 = this.in.read()) | (n4 = this.in.read()) | (n3 = this.in.read()) | (n2 = this.in.read()) | (n = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (long)((n8 << 0) + (n7 << 8) + (n6 << 16)) + ((long)n5 << 24) + ((long)n4 << 32) + ((long)n3 << 40) + ((long)n2 << 48) + ((long)n << 56);
    }

    public float readFloatLE() throws IOException {
        return Float.intBitsToFloat(this.readIntLE());
    }

    public double readDoubleLE() throws IOException {
        return Double.longBitsToDouble(this.readLongLE());
    }

    public String readString() throws IOException {
        byte[] byArray = new byte[this.a()];
        this.readFully(byArray);
        return new String(byArray, StandardCharsets.UTF_8);
    }

    private int a() throws IOException {
        int n;
        int n2 = 0;
        int n3 = 0;
        do {
            n = this.read();
            n2 |= (n & 0x7F) << n3;
            n3 += 7;
        } while ((n & 0x80) != 0);
        return n2;
    }

    public byte[] readBytesLE() throws IOException {
        byte[] byArray = new byte[this.readIntLE()];
        this.readFully(byArray);
        return byArray;
    }
}

