/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.spi.util;

import com.inet.cache.MemoryStoreMap;
import com.inet.persistence.RandomAccessRead;
import java.io.IOException;
import javax.annotation.Nonnull;

public abstract class DatabaseRandomAccessRead<T>
extends RandomAccessRead {
    @Nonnull
    private final MemoryStoreMap<Integer, byte[]> cache = new MemoryStoreMap(60, true);
    private final T chunkId;
    private final int chunkSize;
    private final long length;
    private long pos;

    protected DatabaseRandomAccessRead(T chunkId, long length, int initialChunkSize) {
        int chunkSize;
        this.chunkId = chunkId;
        this.length = length;
        try {
            chunkSize = this.getChunk(0).length;
        }
        catch (IOException e) {
            chunkSize = initialChunkSize;
        }
        this.chunkSize = chunkSize;
    }

    public void close() throws IOException {
        this.cache.clear();
    }

    public long length() throws IOException {
        return this.length;
    }

    @Nonnull
    protected MemoryStoreMap<Integer, byte[]> getCache() {
        return this.cache;
    }

    protected T getChunkId() {
        return this.chunkId;
    }

    protected abstract byte[] getChunk(int var1) throws IOException;

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.pos >= this.length) {
            return -1;
        }
        int chunkIdx = (int)(this.pos / (long)this.chunkSize);
        byte[] chunk = this.getChunk(chunkIdx);
        int chunkOff = (int)(this.pos - (long)(chunkIdx * this.chunkSize));
        int chunkLen = Math.min(len, chunk.length - chunkOff);
        System.arraycopy(chunk, chunkOff, b, off, chunkLen);
        this.pos += (long)chunkLen;
        return chunkLen;
    }

    public int read() throws IOException {
        if (this.pos >= this.length) {
            return -1;
        }
        int chunkIdx = (int)(this.pos / (long)this.chunkSize);
        byte[] chunk = this.getChunk(chunkIdx);
        int chunkOff = (int)(this.pos - (long)(chunkIdx * this.chunkSize));
        ++this.pos;
        return chunk[chunkOff];
    }

    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("Negative seek offset");
        }
        this.pos = pos;
    }
}

