/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.mongodb;

import com.inet.lib.json.Json;
import com.inet.persistence.spi.searchlistener.SearchListenerContainer;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.command.SearchCondition;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.index.ListenerTokenMatcher;
import com.inet.search.index.SearchResultHolder;
import com.inet.search.index.SearchResultListener;
import com.inet.search.index.TagIndex;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.UpdateOptions;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoDbTagIndex<ID>
extends TagIndex<ID> {
    private static final String FORMAT_VERSION = "1";
    private static final Json JSON = new Json();
    private static final Bson NO_NULL_VALUE = Filters.ne((String)"value", null);
    private static final UpdateOptions UPSERT = new UpdateOptions().upsert(true);
    private MongoCollection<Document> collection;
    private final Bson tagFilter;
    private boolean isValid;
    private Class<ID> idType;
    private SearchListenerContainer<ID> searchListeners;

    MongoDbTagIndex(MongoCollection<Document> collection, SearchTag searchTag, @Nonnull IndexSearchEngine<ID> engine, SearchListenerContainer<ID> searchListeners) {
        super(searchTag);
        String data;
        this.collection = collection;
        this.searchListeners = searchListeners;
        this.tagFilter = Filters.eq((String)"tag", (Object)this.getTag());
        this.idType = engine.getIdType().getType();
        Document doc = (Document)collection.find(Filters.eq((String)"attributes", (Object)searchTag.getTag())).limit(1).first();
        this.isValid = false;
        if (doc != null && (data = doc.getString((Object)"data")) != null) {
            Map attr = (Map)new Json().fromJson(data, Map.class);
            this.isValid = FORMAT_VERSION.equals(attr.get("version")) && Objects.equals(attr.get("datatype"), this.getDataType().toString()) && Objects.equals(attr.get("iddatatype"), this.idType.getSimpleName());
        }
    }

    void setNewCollection(@Nonnull MongoCollection<Document> collection) {
        this.collection = collection;
    }

    protected boolean isNew() {
        return !this.isValid;
    }

    private String idToJson(ID id) {
        return JSON.toJson(id);
    }

    private ID idFromJson(String serialize) {
        return (ID)JSON.fromJson(serialize, this.idType);
    }

    protected boolean addToken(ID id, @Nullable Comparable<?> value) {
        String idSerialize = this.idToJson(id);
        Document doc = new Document();
        doc.put("id", (Object)idSerialize);
        doc.put("tag", (Object)this.getTag());
        doc.put("value", value);
        doc = new Document("$setOnInsert", (Object)doc);
        this.collection.updateOne(Filters.and((Bson[])new Bson[]{this.tagFilter, Filters.eq((String)"value", value), Filters.eq((String)"id", (Object)idSerialize)}), (Bson)doc, UPSERT);
        this.notfifySearchResultListener(value);
        return true;
    }

    protected boolean removeToken(ID id, @Nullable Comparable<?> value) {
        String idSerialize = this.idToJson(id);
        Document doc = new Document();
        doc.put("id", (Object)idSerialize);
        doc.put("tag", (Object)this.getTag());
        doc.put("value", value);
        this.collection.deleteOne((Bson)doc);
        this.notfifySearchResultListener(value);
        return true;
    }

    protected void search(Object value, SearchCondition condition, SearchResultHolder<ID> map, String token) {
        Bson filter;
        switch (condition.getOperator()) {
            case StartsWith: {
                if (value.getClass() == String.class) {
                    filter = Filters.regex((String)"value", (String)("^\\Q" + String.valueOf(value) + "\\E.*"));
                    break;
                }
            }
            case Equals: {
                filter = Filters.eq((String)"value", (Object)value);
                break;
            }
            case Contains: {
                if (value.getClass() != String.class) {
                    return;
                }
                filter = Filters.regex((String)"value", (String)(".*\\Q" + String.valueOf(value) + "\\E.*"));
                break;
            }
            case GT: {
                filter = Filters.gt((String)"value", (Object)value);
                break;
            }
            case GE: {
                filter = Filters.gte((String)"value", (Object)value);
                break;
            }
            case LT: {
                filter = Filters.lt((String)"value", (Object)value);
                break;
            }
            case LE: {
                filter = Filters.lte((String)"value", (Object)value);
                break;
            }
            case Unequals: {
                filter = Filters.ne((String)"value", (Object)value);
                break;
            }
            case BETWEEN: {
                Object[] range = (Object[])value;
                filter = Filters.and((Bson[])new Bson[]{Filters.gte((String)"value", (Object)range[0]), Filters.lte((String)"value", (Object)range[1])});
                break;
            }
            case NOT_BETWEEN: {
                Object[] range = (Object[])value;
                filter = Filters.or((Bson[])new Bson[]{Filters.lt((String)"value", (Object)range[0]), Filters.gt((String)"value", (Object)range[1])});
                break;
            }
            case IN: {
                filter = Filters.in((String)"value", (Iterable)((Collection)value));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown operator: " + String.valueOf(condition.getOperator()));
            }
        }
        String tag = this.getTag();
        filter = Filters.and((Bson[])new Bson[]{this.tagFilter, filter});
        int resultLimit = map.getResultLimit();
        if (resultLimit < Integer.MAX_VALUE) {
            ++resultLimit;
        }
        FindIterable find = this.collection.find().filter(filter).limit(resultLimit);
        for (Document doc : find) {
            ID id = this.idFromJson(doc.getString((Object)"id"));
            Object val = doc.get((Object)"value");
            boolean equals = Objects.equals(val, value);
            map.add(id, equals, tag, token, condition);
        }
    }

    protected void getAllIds(SearchResultHolder<ID> map, SearchCondition condition) {
        AggregateIterable it = this.collection.aggregate(Arrays.asList(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{this.tagFilter, switch (this.getDataType()) {
            case SearchDataType.ID, SearchDataType.String, SearchDataType.StringMap -> Filters.gt((String)"value", (Object)"");
            default -> Filters.ne((String)"value", null);
        }})), Aggregates.group((Object)"$id", (BsonField[])new BsonField[0])));
        String tag = this.getTag();
        Consumer<Document> consumer = doc -> {
            ID id = this.idFromJson(doc.getString((Object)"_id"));
            map.add(id, true, tag, "", condition);
        };
        it.forEach(consumer);
    }

    protected void finishIndexing() {
        if (!this.isValid) {
            HashMap<String, String> attr = new HashMap<String, String>();
            attr.put("version", FORMAT_VERSION);
            attr.put("datatype", this.getDataType().toString());
            attr.put("iddatatype", this.idType.getSimpleName());
            Document doc = new Document();
            doc.put("attributes", (Object)this.getTag());
            doc.put("data", (Object)new Json().toJson(attr));
            doc = new Document("$setOnInsert", (Object)doc);
            this.collection.updateOne(Filters.eq((String)"attributes", (Object)this.getTag()), (Bson)doc, UPSERT);
            this.isValid = true;
        }
    }

    @Nullable
    protected Object getMinToken() {
        return this.getMinMaxToken(Sorts.ascending((String[])new String[]{"value"}));
    }

    @Nullable
    protected Object getMaxToken() {
        return this.getMinMaxToken(Sorts.descending((String[])new String[]{"value"}));
    }

    @Nullable
    private Object getMinMaxToken(Bson sort) {
        Document doc = (Document)this.collection.find().filter(Filters.and((Bson[])new Bson[]{this.tagFilter, NO_NULL_VALUE})).sort(sort).limit(1).first();
        if (doc != null) {
            return doc.get((Object)"value");
        }
        return null;
    }

    @Nonnull
    protected <T> Iterator<T> createIterator(boolean forward, final @Nonnull TagIndex.IteratorType itType, @Nullable Comparable<?> startsWith, final @Nonnull Predicate<ID> filter, final @Nullable Function<Object, String> formatter) {
        Document group = new Document("value", (Object)"$value");
        group.put("id", (Object)"$id");
        Bson sort = forward ? Sorts.ascending((String[])new String[]{"_id.value"}) : Sorts.descending((String[])new String[]{"_id.value"});
        Bson dbFilter = this.tagFilter;
        if (startsWith != null) {
            if (startsWith.getClass() == String.class) {
                if (!((String)((Object)startsWith)).isEmpty()) {
                    dbFilter = Filters.and((Bson[])new Bson[]{dbFilter, Filters.regex((String)"value", (String)("^\\Q" + String.valueOf(startsWith) + "\\E.*"))});
                }
            } else {
                dbFilter = Filters.and((Bson[])new Bson[]{dbFilter, Filters.eq((String)"value", startsWith)});
            }
        }
        AggregateIterable find = this.collection.aggregate(Arrays.asList(Aggregates.match((Bson)dbFilter), Aggregates.group((Object)group, (BsonField[])new BsonField[0]), Aggregates.sort((Bson)sort)));
        final MongoCursor it = find.iterator();
        return new Iterator<T>(){
            private boolean hasNext;
            private Object next;
            private Object last = this;
            private Object lastVal = this;
            private HashSet<ID> entryIDs;

            @Override
            public boolean hasNext() {
                block5: while (!this.hasNext && it.hasNext()) {
                    Document doc = (Document)((Document)it.next()).get((Object)"_id");
                    Object id = MongoDbTagIndex.this.idFromJson((String)doc.get((Object)"id"));
                    if (!filter.test(id)) continue;
                    Object val = doc.get((Object)"value");
                    switch (itType) {
                        case ID: {
                            this.next = id;
                            break;
                        }
                        case VALUES: {
                            this.next = formatter != null && val != null ? formatter.apply(val) : val;
                            break;
                        }
                        case ENTRY: {
                            if (this.entryIDs == null) {
                                this.entryIDs = new HashSet();
                                this.entryIDs.add(id);
                                this.last = new AbstractMap.SimpleEntry(val, this.entryIDs);
                            } else {
                                if (!Objects.equals(val, this.lastVal)) {
                                    this.next = this.last;
                                    this.hasNext = true;
                                    this.lastVal = val;
                                    this.entryIDs = new HashSet();
                                    this.entryIDs.add(id);
                                    this.last = new AbstractMap.SimpleEntry(val, this.entryIDs);
                                    return true;
                                }
                                this.entryIDs.add(id);
                            }
                            this.lastVal = val;
                            continue block5;
                        }
                        default: {
                            throw new IllegalStateException("Unkown type: " + String.valueOf(itType));
                        }
                    }
                    if (Objects.equals(this.next, this.last) && Objects.equals(val, this.lastVal)) continue;
                    this.last = this.next;
                    this.lastVal = val;
                    this.hasNext = true;
                    return true;
                }
                if (itType == TagIndex.IteratorType.ENTRY && this.last != null) {
                    this.next = this.last;
                    this.hasNext = true;
                    this.last = null;
                }
                return this.hasNext;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    this.hasNext = false;
                    return this.next;
                }
                throw new NoSuchElementException();
            }
        };
    }

    private void notfifySearchResultListener(@Nullable Comparable<?> value) {
        this.searchListeners.notifySearchResultListener(value);
    }

    protected void handleTokenChangedListener(@Nonnull Comparable<?> token, @Nonnull SearchResultListener<ID> listener, boolean add) {
        this.searchListeners.handleTokenChangedListener(token, listener, add);
    }

    protected void handleTokenChangedListener(@Nonnull ListenerTokenMatcher matcher, @Nonnull SearchResultListener<ID> listener, boolean add) {
        this.searchListeners.handleMatcherChangedListener(matcher, listener, add);
    }
}

