/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.mongodb;

import com.inet.lib.json.Json;
import com.inet.logging.LogID;
import com.inet.persistence.PersistenceListener;
import com.inet.persistence.mongodb.MongoDbPersistence;
import com.inet.persistence.spi.PersistenceLogger;
import com.inet.persistence.spi.events.PersistenceListenerContainer;
import com.mongodb.BasicDBObject;
import com.mongodb.CursorType;
import com.mongodb.MongoException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.Filters;
import javax.annotation.Nonnull;
import org.bson.Document;
import org.bson.conversions.Bson;

class MongoDbPublishSubscribe {
    private static final String CHANNEL = "inet-events";
    private static final String CLIENT = "client";
    private static final String TYPE = "type";
    private static final String MESSAGE = "message";
    private final PersistenceListenerContainer listeners;
    private MongoCollection<Document> collection;
    private boolean stopped;

    MongoDbPublishSubscribe(PersistenceListenerContainer listeners) {
        this.listeners = listeners;
    }

    void start(@Nonnull String clientID) {
        Thread thread = new Thread(() -> {
            block3: {
                try {
                    LogID.setID((String)"pubsub");
                    MongoCursor iterator = this.getCollection().find().sort((Bson)new BasicDBObject("$natural", (Object)-1)).limit(1).iterator();
                    String id = iterator.hasNext() ? ((Document)iterator.next()).get((Object)"_id") : "";
                    Bson filter = Filters.gt((String)"_id", (Object)id);
                    FindIterable find = this.getCollection().find(filter).cursorType(CursorType.TailableAwait).sort((Bson)new BasicDBObject("$natural", (Object)1));
                    iterator = find.iterator();
                    while (!this.stopped && iterator.hasNext()) {
                        Document doc = (Document)iterator.next();
                        String client = doc.getString((Object)CLIENT);
                        if (clientID.equals(client)) continue;
                        this.onMessage(doc);
                    }
                }
                catch (Throwable th) {
                    if (this.stopped) break block3;
                    PersistenceLogger.LOGGER.error(th);
                }
            }
        }, CHANNEL);
        thread.setDaemon(true);
        thread.start();
    }

    void stop() {
        this.stopped = true;
    }

    private void onMessage(Document doc) {
        try {
            String type = doc.getString((Object)TYPE);
            if (type == null) {
                return;
            }
            PersistenceListenerContainer.ListenerDescription desc = this.listeners.get(type);
            if (desc == null) {
                return;
            }
            String message = doc.getString((Object)MESSAGE);
            if (message == null) {
                return;
            }
            Object event = new Json().fromJson(message, desc.getType());
            for (PersistenceListener listener : desc) {
                listener.eventReceived(event);
            }
        }
        catch (Throwable th) {
            PersistenceLogger.LOGGER.error(th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MongoCollection<Document> getCollection() {
        if (this.collection != null) {
            return this.collection;
        }
        MongoDbPublishSubscribe mongoDbPublishSubscribe = this;
        synchronized (mongoDbPublishSubscribe) {
            if (this.collection != null) {
                return this.collection;
            }
            MongoDatabase db = MongoDbPersistence.getDatabase();
            boolean created = false;
            try {
                db.createCollection(CHANNEL, new CreateCollectionOptions().capped(true).sizeInBytes(100000L));
                created = true;
            }
            catch (MongoException ex) {
                switch (ex.getCode()) {
                    case 48: {
                        break;
                    }
                    default: {
                        throw ex;
                    }
                }
            }
            this.collection = db.getCollection(CHANNEL);
            if (created) {
                this.send("", "");
            }
        }
        return this.collection;
    }

    <T> void send(T event, String clientID) {
        String type = event.getClass().getName();
        String message = new Json().toJson(event);
        Document doc = new Document();
        doc.append(CLIENT, (Object)clientID);
        doc.append(TYPE, (Object)type);
        doc.append(MESSAGE, (Object)message);
        this.getCollection().insertOne((Object)doc);
    }
}

