/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.mongodb;

import com.inet.error.ErrorCode;
import com.inet.lib.io.ChunkedInputStream;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.util.IOFunctions;
import com.inet.persistence.PersistenceEntry;
import com.inet.persistence.RandomAccessRead;
import com.inet.persistence.mongodb.MongoDbPersistence;
import com.inet.persistence.spi.PersistenceHelper;
import com.inet.persistence.spi.util.DatabaseRandomAccessRead;
import com.inet.shared.utils.WeakValueMap;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoGridFSException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.gridfs.GridFSDownloadStream;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.bson.types.ObjectId;

class MongoDbPersistenceEntry
extends PersistenceEntry {
    private static final WeakValueMap<String, MongoDbPersistenceEntry> REFS_FOR_DELETE = new WeakValueMap(new ConcurrentHashMap());
    private static final String FILENAME = "filename";
    private static final String PARENT = "parent";
    private static final String METADATA = "metadata";
    private static final String PARENT_FIELD = "metadata.parent";
    private static final String LENGTH = "length";
    private static final String UPLOAD_DATE = "uploadDate";
    private static final String DATA = "data";
    private static final String CHUNK_ID = "chunkId";
    private static final String CHUNK_NUMBER = "chunkNumber";
    @Deprecated
    private static final String NO_DATA = "nodata";
    @Deprecated
    private static final String CHUNKSIZE_COL = "chunkSize";
    private static final int CHUNK_SIZE = 250000;
    @Nonnull
    private final String path;
    private Document mongoDbFile;

    MongoDbPersistenceEntry(String path) {
        this.path = PersistenceHelper.checkName((String)path);
    }

    private MongoDbPersistenceEntry(Document file) {
        this(file.getString((Object)FILENAME));
        this.mongoDbFile = file;
        this.putReference();
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nonnull
    public MongoDbPersistenceEntry resolve(@Nonnull String child) {
        String childPath = PersistenceHelper.resolve((String)this.path, (String)child);
        return new MongoDbPersistenceEntry(childPath);
    }

    public MongoDbPersistenceEntry getParent() {
        String parentPath = PersistenceHelper.getParentPath((String)this.path);
        if (parentPath == null) {
            return null;
        }
        return new MongoDbPersistenceEntry(parentPath);
    }

    public boolean exists() {
        return this.getMongoDbFile() != null;
    }

    @Nonnull
    public List<PersistenceEntry> getChildren() {
        MongoCollection<Document> fs = MongoDbPersistence.getFileSystem();
        FindIterable children = fs.find(Filters.eq((String)PARENT_FIELD, (Object)this.path));
        ArrayList<PersistenceEntry> entries = new ArrayList<PersistenceEntry>();
        for (Document child : children) {
            entries.add(new MongoDbPersistenceEntry(child));
        }
        return entries;
    }

    @Nonnull
    private Bson searchFilter(@Nonnull String pattern) {
        String base = this.path.length() == 1 ? ("*".equals(pattern) ? this.path + "?" : this.path) : this.path + "/";
        Bson filter = Filters.regex((String)FILENAME, (String)PersistenceHelper.searchPatternToRegex((String)(base + pattern)));
        return Filters.and((Bson[])new Bson[]{filter, Filters.exists((String)CHUNK_NUMBER, (boolean)false)});
    }

    public long searchCount(@Nonnull String pattern) {
        MongoCollection<Document> fs = MongoDbPersistence.getFileSystem();
        return fs.countDocuments(this.searchFilter(pattern));
    }

    @Nonnull
    public Iterable<PersistenceEntry> search(@Nonnull String pattern) {
        MongoCollection<Document> fs = MongoDbPersistence.getFileSystem();
        FindIterable files = fs.find(this.searchFilter(pattern));
        return () -> {
            final MongoCursor iterator = files.iterator();
            return new Iterator<PersistenceEntry>(){

                @Override
                public PersistenceEntry next() {
                    Document file = (Document)iterator.next();
                    return new MongoDbPersistenceEntry(file);
                }

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }
            };
        };
    }

    public String getString() {
        byte[] bytes = this.getBytes();
        if (bytes == null) {
            return null;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public byte[] getBytes() {
        try {
            InputStream inputStream = this.getInputStream();
            if (inputStream == null) {
                return null;
            }
            return IOFunctions.readBytes((InputStream)inputStream);
        }
        catch (IOException e) {
            return null;
        }
    }

    public InputStream getInputStream() {
        final Document file = this.getMongoDbFile();
        if (file != null) {
            Binary data = (Binary)file.get((Object)DATA);
            if (data != null) {
                return new FastByteArrayInputStream(data.getData());
            }
            final Object chunkId = file.get((Object)CHUNK_ID);
            if (chunkId != null) {
                return new ChunkedInputStream(){
                    private long length;
                    private Bson filter;
                    private MongoCollection<Document> fs;
                    private MongoCursor<Document> it;
                    private long size;
                    {
                        this.length = file.getLong((Object)MongoDbPersistenceEntry.LENGTH);
                        this.filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)MongoDbPersistenceEntry.FILENAME, (Object)MongoDbPersistenceEntry.this.path), Filters.eq((String)MongoDbPersistenceEntry.CHUNK_ID, (Object)chunkId), Filters.exists((String)MongoDbPersistenceEntry.CHUNK_NUMBER)});
                        this.fs = MongoDbPersistence.getFileSystem();
                        this.it = this.fs.find(this.filter).sort(Sorts.ascending((String[])new String[]{MongoDbPersistenceEntry.CHUNK_NUMBER})).iterator();
                    }

                    protected byte[] nextChunk() {
                        Document next;
                        if (this.it.hasNext() && (next = (Document)this.it.next()) != null) {
                            byte[] bytes = ((Binary)next.get((Object)MongoDbPersistenceEntry.DATA)).getData();
                            this.size += (long)bytes.length;
                            return bytes;
                        }
                        if (this.size != this.length) {
                            ErrorCode.throwAny((Throwable)new EOFException("Unexpected end of stream. (" + this.size + "/" + this.length + ")"));
                        }
                        return null;
                    }
                };
            }
            if (file.containsKey((Object)CHUNKSIZE_COL)) {
                Document doc = (Document)file.get((Object)METADATA);
                if (doc != null && doc.containsKey((Object)NO_DATA)) {
                    return null;
                }
                try {
                    ObjectId id = file.getObjectId((Object)"_id");
                    GridFSDownloadStream stream = MongoDbPersistence.getGridFS().openDownloadStream(id);
                    byte[] bytes = IOFunctions.readBytes((InputStream)stream);
                    MongoDbPersistence.getGridFS().delete(id);
                    this.save(this.path, PersistenceHelper.getParentPath((String)this.path), bytes);
                    return new FastByteArrayInputStream(bytes);
                }
                catch (MongoGridFSException | IOException e) {
                    this.mongoDbFile = null;
                    return this.getInputStream();
                }
            }
        }
        return null;
    }

    public void setString(@Nonnull String value) {
        this.setBytes(value.getBytes(StandardCharsets.UTF_8));
    }

    public void setBytes(byte @Nonnull [] value) {
        this.setInputStream((InputStream)new FastByteArrayInputStream(value));
    }

    public void setInputStream(@Nonnull InputStream value) {
        try (OutputStream output = this.getOutputStream();){
            IOFunctions.copyData((InputStream)value, (OutputStream)output);
        }
        catch (IOException ex) {
            ErrorCode.throwAny((Throwable)ex);
        }
    }

    @Nonnull
    public OutputStream getOutputStream() {
        String parentPath;
        MongoCollection<Document> fs = MongoDbPersistence.getFileSystem();
        String parent = parentPath = PersistenceHelper.getParentPath((String)this.path);
        while (parent != null && !MongoDbPersistenceEntry.exists(fs, parent)) {
            String parentParent = PersistenceHelper.getParentPath((String)parent);
            this.save(parent, parentParent, null);
            parent = parentParent;
        }
        return new FastByteArrayOutputStream(){
            private boolean isClosed;

            public void write(int datum) {
                if (this.isClosed) {
                    ErrorCode.throwAny((Throwable)new IOException("Stream closed"));
                }
                super.write(datum);
            }

            public void write(byte[] data, int offset, int length) {
                if (this.isClosed) {
                    ErrorCode.throwAny((Throwable)new IOException("Stream closed"));
                }
                super.write(data, offset, length);
            }

            public void close() {
                if (!this.isClosed) {
                    this.isClosed = true;
                    byte[] data = this.toByteArray();
                    MongoDbPersistenceEntry.this.save(MongoDbPersistenceEntry.this.path, parentPath, data);
                }
            }
        };
    }

    private void save(final String path, String parentPath, byte @Nullable [] data) {
        MongoCollection<Document> fs = MongoDbPersistence.getFileSystem();
        Document doc = new Document();
        doc.put(FILENAME, (Object)path);
        doc.put(UPLOAD_DATE, (Object)new Date());
        Document metadata = new Document();
        metadata.put(PARENT, (Object)parentPath);
        doc.put(METADATA, (Object)metadata);
        if (data != null) {
            doc.put(LENGTH, (Object)data.length);
            if (data.length >= 500000) {
                MongoDbPersistenceEntry.saveChunks(doc, data);
            } else {
                doc.put(DATA, (Object)new Binary(data));
            }
        }
        UpdateResult result = fs.replaceOne(MongoDbPersistenceEntry.filter(path), (Object)doc, new ReplaceOptions().upsert(true));
        this.mongoDbFile = doc;
        this.putReference();
        if (result.getMatchedCount() > 0L) {
            DefaultTimerTask cleanup = new DefaultTimerTask(){

                public void runImpl() throws Throwable {
                    ForkJoinPool.commonPool().execute(() -> {
                        Document file = MongoDbPersistenceEntry.this.getMongoDbFile();
                        if (file != null) {
                            Object chunkId = file.get((Object)MongoDbPersistenceEntry.CHUNK_ID);
                            MongoDbPersistence.getFileSystem().deleteMany(Filters.and((Bson[])new Bson[]{Filters.eq((String)MongoDbPersistenceEntry.FILENAME, (Object)path), Filters.ne((String)MongoDbPersistenceEntry.CHUNK_ID, (Object)chunkId)}));
                        }
                    });
                }
            };
            DefaultTimer.getInstance().schedule(cleanup, 100L);
        }
    }

    private static void saveChunks(Document mainDoc, byte @Nonnull [] data) {
        MongoCollection<Document> fs = MongoDbPersistence.getFileSystem();
        ObjectId id = new ObjectId();
        mainDoc.put(CHUNK_ID, (Object)id);
        int length = data.length;
        int chunks = (length + 250000 - 1) / 250000;
        for (int i = 0; i < chunks; ++i) {
            Document chunkDoc = new Document();
            chunkDoc.put(FILENAME, mainDoc.get((Object)FILENAME));
            chunkDoc.put(CHUNK_ID, (Object)id);
            chunkDoc.put(CHUNK_NUMBER, (Object)i);
            int from = 250000 * i;
            int to = i == chunks - 1 ? length : from + 250000;
            chunkDoc.put(DATA, (Object)Arrays.copyOfRange(data, from, to));
            fs.insertOne((Object)chunkDoc);
        }
    }

    public void deleteTree() {
        MongoDbPersistenceEntry.deleteFile(MongoDbPersistence.getFileSystem(), this.path, true);
        this.deleteParentIfEmpty();
    }

    public void deleteValue() {
        MongoCollection<Document> fs = MongoDbPersistence.getFileSystem();
        boolean hasChildren = MongoDbPersistenceEntry.hasChildren(fs, this.path);
        if (hasChildren) {
            String parentPath = PersistenceHelper.getParentPath((String)this.path);
            this.save(this.path, parentPath, null);
        } else {
            MongoDbPersistenceEntry.deleteFile(fs, this.path, false);
            this.deleteParentIfEmpty();
        }
    }

    private void deleteParentIfEmpty() {
        MongoCollection<Document> fs = MongoDbPersistence.getFileSystem();
        String current = this.path;
        String parentPath;
        while ((parentPath = PersistenceHelper.getParentPath((String)current)) != null) {
            Document doc;
            boolean exists = MongoDbPersistenceEntry.hasChildren(fs, parentPath);
            if (exists) {
                return;
            }
            Document file = MongoDbPersistenceEntry.find(fs, parentPath);
            if (file == null) {
                return;
            }
            Long length = file.getLong((Object)LENGTH);
            if (length != null && length > 0L) {
                return;
            }
            if (file.get((Object)CHUNKSIZE_COL) != null && (doc = (Document)file.get((Object)METADATA)) != null && !doc.containsKey((Object)NO_DATA)) {
                return;
            }
            MongoDbPersistenceEntry entry = (MongoDbPersistenceEntry)((Object)REFS_FOR_DELETE.get((Object)file.getString((Object)FILENAME)));
            if (entry != null) {
                entry.mongoDbFile = null;
            }
            fs.deleteOne(Filters.eq((Object)file.getObjectId((Object)"_id")));
            current = parentPath;
        }
        return;
    }

    private static boolean hasChildren(MongoCollection<Document> fs, String path) {
        return fs.find(Filters.eq((String)PARENT_FIELD, (Object)path)).limit(1).iterator().hasNext();
    }

    public long size() {
        Long size;
        Document file = this.getMongoDbFile();
        if (file != null && (size = file.getLong((Object)LENGTH)) != null) {
            return size;
        }
        return 0L;
    }

    private static boolean deleteFile(MongoCollection<Document> fs, String path, boolean tree) {
        Bson filter = Filters.eq((String)FILENAME, (Object)path);
        if (tree) {
            Object base = path.length() == 1 ? path : path + "/";
            filter = Filters.or((Bson[])new Bson[]{filter, Filters.regex((String)FILENAME, (String)PersistenceHelper.searchPatternToRegex((String)((String)base + "*")))});
        }
        DeleteResult result = fs.deleteMany(filter);
        if (tree) {
            for (MongoDbPersistenceEntry entry : REFS_FOR_DELETE.values()) {
                if (entry == null) continue;
                entry.mongoDbFile = null;
            }
        } else {
            MongoDbPersistenceEntry entry = (MongoDbPersistenceEntry)((Object)REFS_FOR_DELETE.get((Object)path));
            if (entry != null) {
                entry.mongoDbFile = null;
            }
        }
        return result.getDeletedCount() > 0L;
    }

    private static boolean exists(MongoCollection<Document> fs, String path) {
        return MongoDbPersistenceEntry.find(fs, path) != null;
    }

    @Nonnull
    private static Bson filter(String path) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)FILENAME, (Object)path), Filters.exists((String)CHUNK_NUMBER, (boolean)false)});
    }

    @Nullable
    private static Document find(MongoCollection<Document> fs, String path) {
        return (Document)fs.find(MongoDbPersistenceEntry.filter(path)).limit(1).first();
    }

    public long lastModified() {
        Document file = this.getMongoDbFile();
        return file == null ? 0L : file.getDate((Object)UPLOAD_DATE).getTime();
    }

    @Nullable
    private Document getMongoDbFile() {
        Document file = this.mongoDbFile;
        if (file == null) {
            this.mongoDbFile = file = MongoDbPersistenceEntry.find(MongoDbPersistence.getFileSystem(), this.path);
            this.putReference();
        }
        return file;
    }

    private void putReference() {
        MongoDbPersistenceEntry entry = (MongoDbPersistenceEntry)((Object)REFS_FOR_DELETE.put((Object)this.path, (Object)this));
        if (entry != null && entry != this) {
            entry.mongoDbFile = null;
        }
    }

    static void createIndexes(MongoCollection<Document> fs) {
        fs.createIndex((Bson)new BasicDBObject(FILENAME, (Object)1));
        fs.createIndex((Bson)new BasicDBObject(PARENT_FIELD, (Object)1));
        fs.createIndex((Bson)new BasicDBObject(CHUNK_NUMBER, (Object)1), new IndexOptions().sparse(true));
        fs.createIndex((Bson)new BasicDBObject(CHUNK_ID, (Object)1), new IndexOptions().sparse(true));
    }

    public RandomAccessRead getRandomAccessRead() {
        Document file = this.getMongoDbFile();
        if (file != null) {
            Binary data = (Binary)file.get((Object)DATA);
            if (data != null) {
                return RandomAccessRead.wrap((byte[])data.getData());
            }
            return new MongoDbRandomAccessRead(file);
        }
        return null;
    }

    public void moveTo(@Nonnull String newPath) throws IllegalStateException, IllegalArgumentException {
        String parentPath;
        if (this.path.length() <= 1) {
            throw new IllegalStateException("Persistence root can't moved");
        }
        if ((newPath = PersistenceHelper.checkName((String)PersistenceHelper.resolve((String)this.path, (String)newPath))).length() <= 1) {
            throw new IllegalArgumentException("can not moved to the root");
        }
        MongoDbPersistenceEntry newEntry = this.resolve(newPath);
        if (newEntry.exists()) {
            throw new IllegalStateException("target already exists");
        }
        if (newPath.startsWith(this.path + "/")) {
            throw new IllegalArgumentException("You can't move to a sub folder");
        }
        MongoCollection<Document> fs = MongoDbPersistence.getFileSystem();
        String parent = parentPath = PersistenceHelper.getParentPath((String)newPath);
        while (parent != null && !MongoDbPersistenceEntry.exists(fs, parent)) {
            String parentParent = PersistenceHelper.getParentPath((String)parent);
            this.save(parent, parentParent, null);
            parent = parentParent;
        }
        Bson filter = Filters.regex((String)FILENAME, (String)PersistenceHelper.searchPatternToRegex((String)(this.path + "/*")));
        filter = Filters.or((Bson[])new Bson[]{filter, Filters.eq((String)FILENAME, (Object)this.path)});
        FindIterable find = fs.find(filter).projection(Projections.fields((Bson[])new Bson[]{Projections.include((String[])new String[]{FILENAME})}));
        for (Document file : find) {
            String oldFilename = file.getString((Object)FILENAME);
            String newFilename = newPath + oldFilename.substring(this.path.length());
            BasicDBObject updateFields = new BasicDBObject();
            updateFields.append(FILENAME, (Object)newFilename);
            updateFields.append(PARENT_FIELD, (Object)PersistenceHelper.getParentPath((String)newFilename));
            BasicDBObject setQuery = new BasicDBObject();
            setQuery.append("$set", (Object)updateFields);
            fs.updateOne(Filters.eq((String)FILENAME, (Object)oldFilename), (Bson)setQuery);
            MongoDbPersistenceEntry entry = (MongoDbPersistenceEntry)((Object)REFS_FOR_DELETE.get((Object)oldFilename));
            if (entry == null) continue;
            entry.mongoDbFile = null;
        }
        this.mongoDbFile = null;
        newEntry.mongoDbFile = null;
    }

    private class MongoDbRandomAccessRead
    extends DatabaseRandomAccessRead<Object> {
        public MongoDbRandomAccessRead(Document file) {
            super(file.get((Object)MongoDbPersistenceEntry.CHUNK_ID), file.getLong((Object)MongoDbPersistenceEntry.LENGTH), 250000);
        }

        @Override
        protected byte[] getChunk(int chunkIdx) throws EOFException {
            byte[] chunk = (byte[])this.getCache().get((Object)chunkIdx);
            if (chunk == null) {
                Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)MongoDbPersistenceEntry.FILENAME, (Object)MongoDbPersistenceEntry.this.path), Filters.eq((String)MongoDbPersistenceEntry.CHUNK_ID, this.getChunkId()), Filters.eq((String)MongoDbPersistenceEntry.CHUNK_NUMBER, (Object)chunkIdx)});
                MongoCollection<Document> fs = MongoDbPersistence.getFileSystem();
                Document doc = (Document)fs.find(filter).limit(1).first();
                if (doc == null) {
                    throw new EOFException("Missing Chunk: " + chunkIdx);
                }
                chunk = ((Binary)doc.get((Object)MongoDbPersistenceEntry.DATA)).getData();
                this.getCache().put((Object)chunkIdx, (Object)chunk);
            }
            return chunk;
        }
    }
}

