/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.azure.cosmos;

import com.azure.cosmos.CosmosException;
import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import com.inet.annotations.JsonData;
import com.inet.error.ErrorCode;
import com.inet.lib.json.Json;
import com.inet.persistence.azure.cosmos.AzureCosmosPersistence;
import com.inet.persistence.azure.cosmos.AzureCosmosSearchIndexPersistence;
import com.inet.persistence.azure.cosmos.MonoQueue;
import com.inet.persistence.spi.PersistenceLogger;
import com.inet.persistence.spi.searchlistener.SearchListenerContainer;
import com.inet.search.SearchTag;
import com.inet.search.command.SearchCondition;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.index.ListenerTokenMatcher;
import com.inet.search.index.SearchResultHolder;
import com.inet.search.index.SearchResultListener;
import com.inet.search.index.TagIndex;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AzureCosmosTagIndex<ID>
extends TagIndex<ID> {
    private static final String FORMAT_VERSION = "1";
    private static final Json JSON = new Json();
    private AzureCosmosSearchIndexPersistence<ID> index;
    private boolean isValid;
    private final Class<ID> idType;
    private final Class<? extends ValuePOJO> deserializeValueClass;
    private final MonoQueue queue = new MonoQueue(10);
    private SearchListenerContainer<ID> searchListeners;

    AzureCosmosTagIndex(@Nonnull AzureCosmosSearchIndexPersistence<ID> index, @Nonnull SearchTag searchTag, @Nonnull IndexSearchEngine<ID> engine, boolean copy, SearchListenerContainer<ID> searchListeners) {
        super(searchTag);
        String data;
        AzureCosmosSearchIndexPersistence.AttributePOJO item;
        this.index = index;
        this.searchListeners = searchListeners;
        this.idType = engine.getIdType().getType();
        this.isValid = false;
        if (!copy && (item = AzureCosmosPersistence.readItem(index.getAttributeCollection(), searchTag.getTag(), AzureCosmosSearchIndexPersistence.AttributePOJO.class)) != null && (data = item.val) != null) {
            Map attr = (Map)new Json().fromJson(data, Map.class);
            this.isValid = FORMAT_VERSION.equals(attr.get("version")) && Objects.equals(attr.get("datatype"), this.getDataType().toString()) && Objects.equals(attr.get("iddatatype"), this.idType.getSimpleName());
        }
        switch (this.getDataType()) {
            case Long: {
                this.deserializeValueClass = LongValuePOJO.class;
                break;
            }
            default: {
                this.deserializeValueClass = ValuePOJO.class;
            }
        }
    }

    void setIndex(AzureCosmosSearchIndexPersistence<ID> index) {
        this.index = index;
    }

    protected boolean isNew() {
        return !this.isValid;
    }

    private String idToJson(ID id) {
        return JSON.toJson(id);
    }

    private ID idFromJson(String serialize) {
        return (ID)JSON.fromJson(serialize, this.idType);
    }

    @Nullable
    private ValuePOJO createItem(ID id, Comparable<?> value) {
        String tag;
        ValuePOJO item = new ValuePOJO();
        item.tag = tag = this.getTag();
        item.id = Base64.getUrlEncoder().encodeToString((tag + String.valueOf(id) + String.valueOf(value)).getBytes(StandardCharsets.UTF_8));
        item.idVal = this.idToJson(id);
        item.val = value;
        return item;
    }

    protected boolean addToken(ID id, Comparable<?> value) {
        ValuePOJO item = this.createItem(id, value);
        this.queue.add(this.index.getAsyncValueCollection().upsertItem((Object)item));
        this.notfifySearchResultListener(value);
        return true;
    }

    protected boolean removeToken(ID id, Comparable<?> value) {
        ValuePOJO item = this.createItem(id, value);
        this.queue.add(this.index.getAsyncValueCollection().deleteItem((Object)item, null), th -> {
            if (th instanceof CosmosException) {
                CosmosException ex = (CosmosException)((Object)th);
                if (ex.getStatusCode() != 404) {
                    throw AzureCosmosPersistence.userFriendlyException(ex);
                }
                try {
                    this.index.getValueCollection().deleteItem((Object)item, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            ErrorCode.throwAny((Throwable)th);
        });
        this.notfifySearchResultListener(value);
        return true;
    }

    protected void search(Object value, SearchCondition condition, SearchResultHolder<ID> map, String token) {
        String where;
        List<Object> params = null;
        Object pValue = value;
        switch (condition.getOperator()) {
            case StartsWith: {
                if (pValue.getClass() == String.class) {
                    pValue = AzureCosmosPersistence.escapeLikePattern((String)pValue) + "%";
                    where = "c.val like @val";
                    break;
                }
            }
            case Equals: {
                where = "c.val = @val";
                break;
            }
            case Contains: {
                if (pValue.getClass() != String.class) {
                    return;
                }
                pValue = "%" + AzureCosmosPersistence.escapeLikePattern((String)pValue) + "%";
                where = "c.val like @val";
                break;
            }
            case GT: {
                where = "c.val > @val";
                break;
            }
            case GE: {
                where = "c.val >= @val";
                break;
            }
            case LT: {
                where = "c.val < @val";
                break;
            }
            case LE: {
                where = "c.val <= @val";
                break;
            }
            case Unequals: {
                where = "c.val <> @val";
                break;
            }
            case BETWEEN: {
                Object[] range = (Object[])value;
                where = "(c.val BETWEEN @val1 AND @val2)";
                params = Arrays.asList(new SqlParameter("@val1", range[0]), new SqlParameter("@val2", range[1]));
                break;
            }
            case NOT_BETWEEN: {
                Object[] range = (Object[])value;
                where = "(c.val NOT BETWEEN @val1 AND @val2)";
                params = Arrays.asList(new SqlParameter("@val1", range[0]), new SqlParameter("@val2", range[1]));
                break;
            }
            case IN: {
                StringBuilder builder = new StringBuilder("(");
                params = new ArrayList();
                int i = 0;
                for (Object val : (Collection)value) {
                    if (i > 0) {
                        builder.append(" OR ");
                    }
                    builder.append("c.val = @v").append(i);
                    params.add(new SqlParameter("v" + i, val));
                    ++i;
                }
                builder.append(")");
                where = builder.toString();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown operator: " + String.valueOf(condition.getOperator()));
            }
        }
        String tag = this.getTag();
        if (params == null) {
            params = Arrays.asList(new SqlParameter("@val", pValue));
        }
        try {
            SqlQuerySpec sql = new SqlQuerySpec("SELECT c.idVal, c.val FROM c WHERE c.tag = '" + tag + "' AND " + where, params);
            this.queue.block();
            for (ValuePOJO item : this.index.getValueCollection().queryItems(sql, null, this.deserializeValueClass)) {
                ID id = this.idFromJson(item.idVal);
                Object val = item.val;
                boolean equals = Objects.equals(val, value);
                map.add(id, equals, tag, token, condition);
            }
        }
        catch (CosmosException ex) {
            PersistenceLogger.LOGGER.error((Object)("Search error for condition: '" + where + "' and value '" + String.valueOf(value) + "'"));
            throw AzureCosmosPersistence.userFriendlyException(ex);
        }
    }

    protected void getAllIds(SearchResultHolder<ID> map, SearchCondition condition) {
        try {
            String tag = this.getTag();
            String sql = "SELECT DISTINCT VALUE c.idVal FROM c WHERE c.tag = '" + tag + "' AND c.val ";
            switch (this.getDataType()) {
                case ID: 
                case String: 
                case StringMap: {
                    sql = sql + "> ''";
                    break;
                }
                default: {
                    sql = sql + "!= null";
                }
            }
            this.queue.block();
            for (String idVal : this.index.getValueCollection().queryItems(sql, null, String.class)) {
                ID id = this.idFromJson(idVal);
                map.add(id, true, tag, "", condition);
            }
        }
        catch (CosmosException ex) {
            throw AzureCosmosPersistence.userFriendlyException(ex);
        }
    }

    protected void finishIndexing() {
        if (!this.isValid) {
            HashMap<String, String> attr = new HashMap<String, String>();
            attr.put("version", FORMAT_VERSION);
            attr.put("datatype", this.getDataType().toString());
            attr.put("iddatatype", this.idType.getSimpleName());
            AzureCosmosSearchIndexPersistence.AttributePOJO item = new AzureCosmosSearchIndexPersistence.AttributePOJO();
            item.id = this.getTag();
            item.val = new Json().toJson(attr);
            this.index.getAttributeCollection().upsertItem((Object)item);
            this.isValid = true;
        }
        try {
            this.queue.block();
        }
        catch (Throwable th) {
            PersistenceLogger.LOGGER.error(th);
        }
    }

    protected Object getMinToken() {
        return this.getMinMaxToken("MIN");
    }

    protected Object getMaxToken() {
        return this.getMinMaxToken("MAX");
    }

    @Nullable
    private Object getMinMaxToken(String aggregate) {
        String tag = this.getTag();
        String sql = "SELECT VALUE " + aggregate + "( c.val ) FROM c WHERE c.tag = '" + tag + "' AND c.val != null";
        try {
            this.queue.block();
            Iterator iterator = this.index.getValueCollection().queryItems(sql, null, this.getDataClass()).iterator();
            if (iterator.hasNext()) {
                Object val = iterator.next();
                return val;
            }
        }
        catch (NullPointerException ex) {
            return null;
        }
        catch (CosmosException ex) {
            throw AzureCosmosPersistence.userFriendlyException(ex);
        }
        return null;
    }

    @Nonnull
    protected <T> Iterator<T> createIterator(boolean forward, final @Nonnull TagIndex.IteratorType itType, @Nullable Comparable<?> startsWith, final @Nonnull Predicate<ID> filter, final @Nullable Function<Object, String> formatter) {
        try {
            String sqlStr = "SELECT * FROM c WHERE c.tag = '" + this.getTag() + "'";
            SqlParameter param = null;
            if (startsWith != null) {
                if (startsWith.getClass() == String.class) {
                    if (!((String)((Object)startsWith)).isEmpty()) {
                        sqlStr = sqlStr + " AND c.val LIKE @val";
                        param = new SqlParameter("@val", (Object)(AzureCosmosPersistence.escapeLikePattern((String)((Object)startsWith)) + "%"));
                    }
                } else {
                    sqlStr = sqlStr + " AND c.val = @val";
                    param = new SqlParameter("@val", startsWith);
                }
            }
            sqlStr = sqlStr + " ORDER BY c.tag " + (forward ? "ASC" : "DESC") + ", c.val " + (forward ? "ASC" : "DESC");
            SqlQuerySpec sql = new SqlQuerySpec(sqlStr);
            if (param != null) {
                sql.setParameters(Arrays.asList(param));
            }
            this.queue.block();
            final Iterator it = this.index.getValueCollection().queryItems(sql, null, this.deserializeValueClass).iterator();
            return new Iterator<T>(){
                private boolean hasNext;
                private Object next;
                private Object last = this;
                private Object lastVal = this;
                private HashSet<ID> entryIDs;

                @Override
                public boolean hasNext() {
                    try {
                        block7: while (!this.hasNext && it.hasNext()) {
                            ValuePOJO item = (ValuePOJO)it.next();
                            Object id = AzureCosmosTagIndex.this.idFromJson(item.idVal);
                            if (!filter.test(id)) continue;
                            Object val = item.val;
                            switch (itType) {
                                case ID: {
                                    this.next = id;
                                    break;
                                }
                                case VALUES: {
                                    this.next = formatter != null && val != null ? formatter.apply(val) : val;
                                    break;
                                }
                                case ENTRY: {
                                    if (this.entryIDs == null) {
                                        this.entryIDs = new HashSet();
                                        this.entryIDs.add(id);
                                        this.last = new AbstractMap.SimpleEntry(val, this.entryIDs);
                                    } else {
                                        if (!Objects.equals(val, this.lastVal)) {
                                            this.next = this.last;
                                            this.hasNext = true;
                                            this.lastVal = val;
                                            this.entryIDs = new HashSet();
                                            this.entryIDs.add(id);
                                            this.last = new AbstractMap.SimpleEntry(val, this.entryIDs);
                                            return true;
                                        }
                                        this.entryIDs.add(id);
                                    }
                                    this.lastVal = val;
                                    continue block7;
                                }
                                default: {
                                    throw new IllegalStateException("Unkown type: " + String.valueOf(itType));
                                }
                            }
                            if (Objects.equals(this.next, this.last) && Objects.equals(val, this.lastVal)) continue;
                            this.last = this.next;
                            this.lastVal = val;
                            this.hasNext = true;
                            return true;
                        }
                        if (itType == TagIndex.IteratorType.ENTRY && this.last != null) {
                            this.next = this.last;
                            this.hasNext = true;
                            this.last = null;
                        }
                        return this.hasNext;
                    }
                    catch (CosmosException ex) {
                        throw AzureCosmosPersistence.userFriendlyException(ex);
                    }
                }

                @Override
                public T next() {
                    if (this.hasNext()) {
                        this.hasNext = false;
                        return this.next;
                    }
                    throw new NoSuchElementException();
                }
            };
        }
        catch (CosmosException ex) {
            throw AzureCosmosPersistence.userFriendlyException(ex);
        }
    }

    private void notfifySearchResultListener(@Nullable Comparable<?> value) {
        this.searchListeners.notifySearchResultListener(value);
    }

    protected void handleTokenChangedListener(@Nonnull Comparable<?> token, @Nonnull SearchResultListener<ID> listener, boolean add) {
        this.searchListeners.handleTokenChangedListener(token, listener, add);
    }

    protected void handleTokenChangedListener(@Nonnull ListenerTokenMatcher matcher, @Nonnull SearchResultListener<ID> listener, boolean add) {
        this.searchListeners.handleMatcherChangedListener(matcher, listener, add);
    }

    @JsonData
    private static class LongValuePOJO
    extends ValuePOJO {
        private LongValuePOJO() {
        }

        public void setVal(Long val) {
            this.val = val;
        }

        public Long getVal() {
            return (Long)this.val;
        }
    }

    @JsonData
    private static class ValuePOJO {
        public String id;
        public String tag;
        public Object val;
        public String idVal;

        private ValuePOJO() {
        }
    }
}

