/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.azure.cosmos;

import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosBridgeInternal;
import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.models.CompositePath;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.ExcludedPath;
import com.azure.cosmos.models.IndexingPolicy;
import com.azure.cosmos.models.SqlQuerySpec;
import com.inet.annotations.JsonData;
import com.inet.lib.json.Json;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceListener;
import com.inet.persistence.SearchIndexPersistence;
import com.inet.persistence.azure.cosmos.AzureCosmosPersistence;
import com.inet.persistence.azure.cosmos.AzureCosmosTagIndex;
import com.inet.persistence.spi.PersistenceLogger;
import com.inet.persistence.spi.searchlistener.SearchListenerContainer;
import com.inet.search.SearchTag;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.index.TagIndex;
import com.inet.shared.utils.WeakValueMap;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class AzureCosmosSearchIndexPersistence<ID>
implements SearchIndexPersistence<ID> {
    private static final WeakValueMap<String, AzureCosmosSearchIndexPersistence<?>> INDEXES = new WeakValueMap();
    private static final WeakHashMap<AzureCosmosTagIndex<?>, Object> TAGS = new WeakHashMap();
    private String indexName;
    private IndexSearchEngine<ID> engine;
    private CosmosContainer attrCollection;
    private CosmosContainer valueCollection;
    private CosmosAsyncContainer asyncValueCollection;
    private boolean copy;
    private static final String ATTR_NAME = ".attr";
    private static final String VAL_NAME = ".val";
    private static final String COLLECTION_ID = "collection";
    private static final String REINDEX_ID = "reindex";
    private static final String INDEX_ID = "index";
    private static final String VAL_PARTITION_KEY = "/tag/val";

    AzureCosmosSearchIndexPersistence(String indexName) {
        this.indexName = indexName;
        INDEXES.put((Object)indexName, (Object)this);
        try {
            this.getValueCollection();
        }
        catch (Exception ex) {
            PersistenceLogger.LOGGER.error((Throwable)ex);
        }
    }

    private AzureCosmosSearchIndexPersistence(String indexName, CosmosContainer valueCollection) {
        this.indexName = indexName;
        this.valueCollection = valueCollection;
        this.copy = true;
    }

    private String getCollectionBaseName() {
        return "index." + this.indexName;
    }

    @Nonnull
    CosmosContainer getAttributeCollection() {
        if (this.attrCollection == null) {
            CosmosContainerProperties props = new CosmosContainerProperties(this.getCollectionBaseName() + ATTR_NAME, "/id");
            IndexingPolicy indexing = new IndexingPolicy();
            indexing.setExcludedPaths(Arrays.asList(new ExcludedPath("/*")));
            props.setIndexingPolicy(indexing);
            this.attrCollection = AzureCosmosPersistence.getOrCreateContainer(props);
        }
        return this.attrCollection;
    }

    @Nonnull
    CosmosContainer getValueCollection() {
        CosmosContainer valueCollection = this.valueCollection;
        if (valueCollection == null) {
            Object collectionName = null;
            AttributePOJO item = AzureCosmosPersistence.readItem(this.getAttributeCollection(), COLLECTION_ID, AttributePOJO.class);
            if (item != null) {
                collectionName = item.val;
            }
            if (collectionName == null) {
                collectionName = this.getCollectionBaseName() + ".val0";
                item = new AttributePOJO();
                item.id = COLLECTION_ID;
                item.val = collectionName;
                this.getAttributeCollection().upsertItem((Object)item);
            }
            this.valueCollection = valueCollection = AzureCosmosSearchIndexPersistence.getValueCollection((String)collectionName);
        }
        return valueCollection;
    }

    @Nonnull
    CosmosAsyncContainer getAsyncValueCollection() {
        CosmosAsyncContainer asyncValueCollection = this.asyncValueCollection;
        if (asyncValueCollection == null) {
            this.asyncValueCollection = asyncValueCollection = CosmosBridgeInternal.getCosmosAsyncContainer((CosmosContainer)this.getValueCollection());
        }
        return asyncValueCollection;
    }

    @Nonnull
    private static CosmosContainer getValueCollection(String collectionName) {
        CosmosContainerProperties props = new CosmosContainerProperties(collectionName, VAL_PARTITION_KEY);
        IndexingPolicy indexing = new IndexingPolicy();
        indexing.setExcludedPaths(Arrays.asList(new ExcludedPath("/*")));
        CompositePath path1 = new CompositePath();
        path1.setPath("/tag");
        CompositePath path2 = new CompositePath();
        path2.setPath("/val");
        indexing.setCompositeIndexes(Arrays.asList(Arrays.asList(path1, path2)));
        props.setIndexingPolicy(indexing);
        return AzureCosmosPersistence.getOrCreateContainer(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AzureCosmosTagIndex<ID> createTag(@Nonnull SearchTag searchTag) {
        SearchListenerContainer searchListeners = AzureCosmosPersistence.getSearchListenerManager().createContainer(this.indexName, searchTag);
        AzureCosmosTagIndex<ID> tagIndex = new AzureCosmosTagIndex<ID>(this, searchTag, this.engine, this.copy, searchListeners);
        WeakHashMap<AzureCosmosTagIndex<?>, Object> weakHashMap = TAGS;
        synchronized (weakHashMap) {
            TAGS.put(tagIndex, null);
        }
        return tagIndex;
    }

    public void deleteTag(String tag) {
        AttributePOJO item = new AttributePOJO();
        item.id = tag;
        this.getAttributeCollection().deleteItem((Object)item, null);
        CosmosAsyncContainer collection = this.getAsyncValueCollection();
        SqlQuerySpec sql = new SqlQuerySpec("SELECT c.id FROM c WHERE c.tag = '" + tag + "'");
        for (AttributePOJO item2 : this.getValueCollection().queryItems(sql, null, AttributePOJO.class)) {
            collection.deleteItem((Object)item2, null);
        }
    }

    public void setEngine(IndexSearchEngine<ID> engine) {
        this.engine = engine;
    }

    public boolean needReindex() {
        AttributePOJO item = AzureCosmosPersistence.readItem(this.getAttributeCollection(), REINDEX_ID, AttributePOJO.class);
        return item != null;
    }

    public void markForReindex() throws IOException {
        AttributePOJO item = new AttributePOJO();
        item.id = REINDEX_ID;
        this.getAttributeCollection().upsertItem((Object)item);
    }

    public Map<String, String> loadIndexAttributes() {
        AttributePOJO item = AzureCosmosPersistence.readItem(this.getAttributeCollection(), INDEX_ID, AttributePOJO.class);
        if (item != null) {
            try {
                String data = item.val;
                if (data != null) {
                    return (Map)new Json().fromJson(data, Map.class);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new HashMap<String, String>();
    }

    public void saveIndexAttributes(@Nonnull Map<String, String> attrs) throws IOException {
        try {
            AttributePOJO item = new AttributePOJO();
            item.id = INDEX_ID;
            item.val = new Json().toJson(attrs);
            this.getAttributeCollection().upsertItem((Object)item);
        }
        catch (CosmosException ex) {
            throw AzureCosmosPersistence.userFriendlyException(ex);
        }
    }

    public String getName() {
        return this.indexName;
    }

    public void saveOutstanding() {
        AzureCosmosSearchIndexPersistence.saveOutstandingImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void saveOutstandingImpl() {
        WeakHashMap<AzureCosmosTagIndex<?>, Object> weakHashMap = TAGS;
        synchronized (weakHashMap) {
            for (AzureCosmosTagIndex<?> tagIndex : TAGS.keySet()) {
                if (tagIndex == null) continue;
                tagIndex.finishIndexing();
            }
        }
    }

    public SearchIndexPersistence<ID> copy() throws IOException {
        int count;
        this.markForReindex();
        String id = this.getValueCollection().getId();
        String valueCollectionBaseName = this.getCollectionBaseName() + VAL_NAME;
        String countStr = id.substring(valueCollectionBaseName.length());
        try {
            count = Integer.valueOf(countStr);
        }
        catch (NumberFormatException e) {
            count = 0;
        }
        ++count;
        CosmosContainer collection = AzureCosmosSearchIndexPersistence.getValueCollection(valueCollectionBaseName + (count %= 10));
        return new AzureCosmosSearchIndexPersistence<ID>(this.indexName, collection);
    }

    public void replaceWith(SearchIndexPersistence<ID> copy, Map<SearchTag, TagIndex<ID>> searchTags) throws IOException {
        try {
            AzureCosmosSearchIndexPersistence source = (AzureCosmosSearchIndexPersistence)copy;
            AttributePOJO item = new AttributePOJO();
            CosmosContainer valueColl = source.valueCollection;
            item.id = COLLECTION_ID;
            item.val = valueColl.getId();
            source.getAttributeCollection().upsertItem((Object)item);
            final CosmosContainer oldColl = this.valueCollection;
            this.valueCollection = valueColl;
            this.asyncValueCollection = null;
            for (TagIndex<ID> tagIndex : searchTags.values()) {
                if (!(tagIndex instanceof AzureCosmosTagIndex)) continue;
                ((AzureCosmosTagIndex)tagIndex).setIndex(this);
            }
            item = new AttributePOJO();
            item.id = REINDEX_ID;
            source.getAttributeCollection().deleteItem((Object)item, null);
            ReplaceIndexEvent event = new ReplaceIndexEvent();
            event.indexName = this.indexName;
            Persistence.getInstance().sendEvent((Object)event);
            DefaultTimer.getInstance().schedule(new DefaultTimerTask(){

                public void runImpl() throws Throwable {
                    oldColl.delete();
                }
            }, 1000L);
        }
        catch (CosmosException ex) {
            throw AzureCosmosPersistence.userFriendlyException(ex);
        }
    }

    public void delete() {
        block7: {
            this.saveOutstanding();
            CosmosAsyncDatabase asyncDatabase = AzureCosmosPersistence.getAsyncDatabase();
            String baseName = this.getCollectionBaseName();
            if (INDEXES.get((Object)this.indexName) != this) {
                if (this.valueCollection == null) {
                    return;
                }
                baseName = this.valueCollection.getId();
            }
            Mono mono = null;
            for (CosmosContainerProperties props : AzureCosmosPersistence.getDatabase().readAllContainers()) {
                String collectionId = props.getId();
                if (!collectionId.startsWith(baseName)) continue;
                Mono deleteMono = asyncDatabase.getContainer(collectionId).delete();
                if (mono == null) {
                    mono = deleteMono;
                    continue;
                }
                mono = mono.and((Publisher)deleteMono);
            }
            try {
                if (mono != null) {
                    mono.block();
                }
            }
            catch (CosmosException ex) {
                if (ex.getStatusCode() == 404) break block7;
                throw AzureCosmosPersistence.userFriendlyException(ex);
            }
        }
        this.attrCollection = null;
    }

    static {
        Persistence.getInstance().registerListener((PersistenceListener)new PersistenceListener<ReplaceIndexEvent>(){

            public void eventReceived(@Nonnull ReplaceIndexEvent event) {
                AzureCosmosSearchIndexPersistence index = (AzureCosmosSearchIndexPersistence)INDEXES.get((Object)event.indexName);
                if (index != null) {
                    index.valueCollection = null;
                    index.asyncValueCollection = null;
                }
            }
        });
    }

    @JsonData
    static class AttributePOJO {
        public String id;
        public String val;

        AttributePOJO() {
        }
    }

    @JsonData
    private static class ReplaceIndexEvent {
        String indexName;

        private ReplaceIndexEvent() {
        }
    }
}

