/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.azure.cosmos;

import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.ExcludedPath;
import com.azure.cosmos.models.IncludedPath;
import com.azure.cosmos.models.IndexingPolicy;
import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.lib.util.NetworkFunctions;
import com.inet.logging.EventLog;
import com.inet.persistence.EventLogPersistence;
import com.inet.persistence.azure.cosmos.AzureCosmosPersistence;
import com.inet.persistence.spi.PersistenceHelper;
import com.inet.usersandgroups.api.user.UserAccount;
import java.time.Instant;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class AzureCosmosEventLogPersistence
implements EventLogPersistence {
    private String name;
    private CosmosContainer collection;

    AzureCosmosEventLogPersistence(String name) {
        this.name = "eventlog-" + name;
    }

    public void write(EventLog.EventData eventData) {
        EventPOJO logMessage = new EventPOJO();
        Object[] extra = eventData.getExtraColumns();
        int count = 7 + (extra == null ? 0 : extra.length);
        logMessage.data = new String[count];
        String[] data = logMessage.data;
        data[0] = PersistenceHelper.ISO_INSTANT.format(Instant.ofEpochMilli(eventData.getTimeMillis()));
        UserAccount account = eventData.getAccount();
        if (account == null) {
            data[1] = "";
            data[2] = "";
        } else {
            data[1] = account.getID().toString();
            data[2] = account.getDisplayName();
        }
        data[3] = eventData.getEvent();
        data[4] = eventData.getMessage();
        data[5] = eventData.getData();
        if (extra != null) {
            for (int i = 0; i < extra.length; ++i) {
                String str;
                Object value = extra[i];
                data[6 + i] = str = value == null ? "" : value.toString();
            }
        }
        data[count - 1] = NetworkFunctions.getLocalHostName();
        try {
            this.getCollection().createItem((Object)logMessage);
        }
        catch (CosmosException ex) {
            throw AzureCosmosPersistence.userFriendlyException(ex, eventData.getEvent() + "." + eventData.getMessage());
        }
    }

    public void close() {
    }

    public void delete() {
        block3: {
            if (this.collection == null) {
                this.collection = AzureCosmosPersistence.getDatabase().getContainer(this.name);
            }
            try {
                this.collection.delete();
            }
            catch (CosmosException ex) {
                if (ex.getStatusCode() == 404) break block3;
                throw AzureCosmosPersistence.userFriendlyException(ex);
            }
        }
        this.collection = null;
    }

    public Iterator<String[]> getEvents(int columnCount) {
        return new Iterator<String[]>(){
            private Iterator<String[]> it;
            {
                this.it = AzureCosmosEventLogPersistence.this.getCollection().queryItems("SELECT VALUE c.data FROM c ORDER BY c.data[0]", null, String[].class).iterator();
            }

            @Override
            public boolean hasNext() {
                try {
                    return this.it.hasNext();
                }
                catch (CosmosException ex) {
                    throw AzureCosmosPersistence.userFriendlyException(ex);
                }
            }

            @Override
            public String[] next() {
                try {
                    return this.it.next();
                }
                catch (CosmosException ex) {
                    throw AzureCosmosPersistence.userFriendlyException(ex);
                }
            }
        };
    }

    private CosmosContainer getCollection() {
        if (this.collection == null) {
            CosmosContainerProperties props = new CosmosContainerProperties(this.name, "/id");
            props.setDefaultTimeToLiveInSeconds(Integer.valueOf((int)TimeUnit.DAYS.toSeconds(30L)));
            IndexingPolicy indexing = new IndexingPolicy();
            indexing.setExcludedPaths(Arrays.asList(new ExcludedPath("/*")));
            indexing.setIncludedPaths(Arrays.asList(new IncludedPath("/data/[0]/?")));
            props.setIndexingPolicy(indexing);
            this.collection = AzureCosmosPersistence.getOrCreateContainer(props);
        }
        return this.collection;
    }

    @JsonData
    private static class EventPOJO {
        public String id = GUID.generateNew().toString();
        public String[] data;

        private EventPOJO() {
        }
    }
}

