/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.spi.util;

import com.inet.error.ErrorCode;
import com.inet.thread.CountedReadWriteLock;
import com.inet.thread.ServerLock;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;

public abstract class BaseLocks {
    public ServerLock tryReadWriteLock(@Nonnull String key, boolean writeLock) {
        CountedReadWriteLock readWriteLock = CountedReadWriteLock.tryReadWriteLockInstance((Object)key, (boolean)writeLock);
        if (readWriteLock == null) {
            return null;
        }
        return this.tryReadWriteLock(key, readWriteLock, writeLock);
    }

    public ServerLock getReadWriteLock(@Nonnull String key, boolean writeLock, long timeout) {
        long remainingTime;
        long endTime = timeout > 0L ? System.currentTimeMillis() + timeout : 0L;
        CountedReadWriteLock readWriteLock = CountedReadWriteLock.getReadWriteLock((Object)key, (boolean)writeLock, (long)timeout);
        do {
            ServerLock serverLock;
            if ((serverLock = this.tryReadWriteLock(key, readWriteLock, writeLock)) == null) continue;
            return serverLock;
        } while (timeout <= 0L || (remainingTime = endTime - System.currentTimeMillis()) > 0L);
        throw (RuntimeException)ErrorCode.throwAny((Throwable)new TimeoutException("Timeout while waiting for remote " + (writeLock ? "write" : "read") + " lock: " + key));
    }

    protected abstract ServerLock tryReadWriteLock(@Nonnull String var1, @Nonnull CountedReadWriteLock var2, boolean var3);
}

