/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.spi.events;

import com.inet.persistence.PersistenceListener;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PersistenceListenerContainer {
    private Map<String, ListenerDescription> listeners = new ConcurrentHashMap<String, ListenerDescription>();

    private static <T> Type getPersistenceListenerType(Class<?> clazz) {
        Type[] interfaces;
        for (Type face : interfaces = clazz.getGenericInterfaces()) {
            if (face instanceof ParameterizedType && ((ParameterizedType)face).getRawType() == PersistenceListener.class) {
                Type[] actualTypeArguments = ((ParameterizedType)face).getActualTypeArguments();
                return actualTypeArguments[0];
            }
            if (!(face instanceof Class) || (face = PersistenceListenerContainer.getPersistenceListenerType((Class)face)) == null) continue;
            return face;
        }
        return null;
    }

    @Nonnull
    private static <T> Type getPersistenceListenerType(PersistenceListener<T> listener) {
        Type type = PersistenceListenerContainer.getPersistenceListenerType(listener.getClass());
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Type of listener was not detected: " + String.valueOf(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void addListener(@Nonnull PersistenceListener<T> listener) {
        Type type = PersistenceListenerContainer.getPersistenceListenerType(listener);
        String typeName = (type instanceof ParameterizedType ? ((ParameterizedType)type).getRawType() : type).getTypeName();
        Map<String, ListenerDescription> map = this.listeners;
        synchronized (map) {
            ListenerDescription desc = this.listeners.get(typeName);
            if (desc == null) {
                desc = new ListenerDescription();
                desc.type = type;
                this.listeners.put(typeName, desc);
            }
            desc.add(listener);
        }
    }

    @Nullable
    public ListenerDescription get(String typeName) {
        return this.listeners.get(typeName);
    }

    public static class ListenerDescription
    extends CopyOnWriteArrayList<PersistenceListener<?>> {
        private Type type;

        public Type getType() {
            return this.type;
        }
    }
}

