/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.dynamodb;

import com.inet.persistence.dynamodb.AsyncBatch;
import com.inet.persistence.dynamodb.DynamoDbPersistence;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;

abstract class DynamoDbUtils {
    DynamoDbUtils() {
    }

    static void iterate(QueryRequest.Builder builder, Consumer<Map<String, AttributeValue>> consumer) {
        DynamoDbClient client = DynamoDbPersistence.getClient();
        while (true) {
            QueryRequest request = (QueryRequest)builder.build();
            QueryResponse response = client.query(request);
            for (Map item : response.items()) {
                consumer.accept(item);
            }
            Map lastEvaluatedKey = response.lastEvaluatedKey();
            if (lastEvaluatedKey.isEmpty()) break;
            builder.exclusiveStartKey(lastEvaluatedKey);
        }
    }

    static void batchDelete(QueryRequest.Builder ... builders) {
        DynamoDbClient client = DynamoDbPersistence.getClient();
        AsyncBatch batch = null;
        for (int i = 0; i < builders.length; ++i) {
            Map lastEvaluatedKey;
            QueryRequest.Builder builder = builders[i];
            do {
                QueryRequest request = (QueryRequest)builder.build();
                String tableName = request.tableName();
                QueryResponse response = client.query(request);
                List items = response.items();
                lastEvaluatedKey = response.lastEvaluatedKey();
                builder.exclusiveStartKey(lastEvaluatedKey);
                if (items.isEmpty()) continue;
                if (batch == null) {
                    batch = new AsyncBatch(tableName);
                }
                for (Map item : items) {
                    batch.addDeleteItem(item);
                }
            } while (!lastEvaluatedKey.isEmpty());
        }
        if (batch != null) {
            batch.flushAndWait();
        }
    }

    static void putItem(@Nonnull String tableName, @Nonnull Map<String, AttributeValue> item) {
        PutItemRequest request = (PutItemRequest)PutItemRequest.builder().tableName(tableName).item(item).build();
        DynamoDbPersistence.getClient().putItem(request);
    }

    static void deleteItem(@Nonnull String tableName, @Nonnull Map<String, AttributeValue> key) {
        DeleteItemRequest request = (DeleteItemRequest)DeleteItemRequest.builder().tableName(tableName).key(key).build();
        DynamoDbPersistence.getClient().deleteItem(request);
    }

    @Nonnull
    static Map<String, AttributeValue> getItem(@Nonnull String tableName, @Nonnull Map<String, AttributeValue> key) {
        return DynamoDbUtils.getItem(tableName, key, null);
    }

    @Nonnull
    static Map<String, AttributeValue> getItem(@Nonnull String tableName, @Nonnull Map<String, AttributeValue> key, @Nullable String projection) {
        GetItemRequest request = (GetItemRequest)GetItemRequest.builder().tableName(tableName).key(key).projectionExpression(projection).build();
        return DynamoDbPersistence.getClient().getItem(request).item();
    }

    @Nullable
    static String getS(Map<String, AttributeValue> item, String key) {
        if (item == null) {
            return null;
        }
        AttributeValue attr = item.get(key);
        if (attr == null) {
            return null;
        }
        return attr.s();
    }
}

