/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.dynamodb;

import com.inet.lib.json.Json;
import com.inet.persistence.dynamodb.AsyncBatch;
import com.inet.persistence.dynamodb.DynamoDbPersistence;
import com.inet.persistence.dynamodb.DynamoDbSearchIndexPersistence;
import com.inet.persistence.dynamodb.DynamoDbUtils;
import com.inet.persistence.spi.searchlistener.SearchListenerContainer;
import com.inet.search.SearchTag;
import com.inet.search.command.SearchCondition;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.index.ListenerTokenMatcher;
import com.inet.search.index.SearchResultHolder;
import com.inet.search.index.SearchResultListener;
import com.inet.search.index.TagIndex;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;

class DynamoDbTagIndex<ID>
extends TagIndex<ID> {
    private static final String FORMAT_VERSION = "1";
    private static final String DELIMITER = " : ";
    private static final String NULL_NUMBER = "-9.9999999999999999999999999999999999999E+125";
    private static final String NULL_STRING = "                                             ";
    private static final String EMPTY_STRING = "\n                                           ";
    private static final Json JSON = new Json();
    private final DynamoDbSearchIndexPersistence<ID> index;
    @Nonnull
    private final String tableName;
    @Nonnull
    private final AsyncBatch batch;
    private final String valColumn;
    private final boolean isNumber;
    private boolean isValid;
    private final Class<ID> idType;
    private SearchListenerContainer<ID> searchListeners;

    protected DynamoDbTagIndex(@Nonnull DynamoDbSearchIndexPersistence<ID> index, SearchTag searchTag, @Nonnull IndexSearchEngine<ID> engine, @Nonnull String tableName, @Nonnull AsyncBatch batch, boolean copy, SearchListenerContainer<ID> searchListeners) {
        super(searchTag);
        this.index = index;
        this.tableName = tableName;
        this.batch = batch;
        this.searchListeners = searchListeners;
        switch (searchTag.getDataType()) {
            case Date: 
            case Integer: 
            case Long: 
            case Double: 
            case IntegerMap: {
                this.valColumn = "num";
                this.isNumber = true;
                break;
            }
            default: {
                this.valColumn = "str";
                this.isNumber = false;
            }
        }
        this.idType = engine.getIdType().getType();
        this.isValid = false;
        if (!copy) {
            Map<String, AttributeValue> attrs = index.getMainItem(searchTag.getTag());
            this.isValid = FORMAT_VERSION.equals(DynamoDbUtils.getS(attrs, "version")) && Objects.equals(DynamoDbUtils.getS(attrs, "datatype"), this.getDataType().toString()) && Objects.equals(DynamoDbUtils.getS(attrs, "iddatatype"), this.idType.getSimpleName());
        }
    }

    protected boolean isNew() {
        return !this.isValid;
    }

    private ID idFromItem(@Nonnull Map<String, AttributeValue> item) {
        String idValStr = item.get("id").s();
        int idx = idValStr.indexOf(DELIMITER);
        String idStr = idValStr.substring(idx + DELIMITER.length());
        return (ID)JSON.fromJson(idStr, this.idType);
    }

    private Object valFromItem(@Nonnull Map<String, AttributeValue> item) {
        String idValStr = item.get("id").s();
        int idx = idValStr.indexOf(DELIMITER);
        String valStr = idValStr.substring(0, idx);
        switch (this.getDataType()) {
            case Integer: 
            case IntegerMap: {
                if ("null".equals(valStr)) {
                    return null;
                }
                return Integer.valueOf(valStr);
            }
            case Date: 
            case Long: {
                if ("null".equals(valStr)) {
                    return null;
                }
                return Long.valueOf(valStr);
            }
            case Double: {
                if ("null".equals(valStr)) {
                    return null;
                }
                return Double.valueOf(valStr);
            }
        }
        return valStr;
    }

    @Nonnull
    private String getIdValue(@Nonnull ID id, Comparable<?> value) {
        return String.valueOf(value) + DELIMITER + JSON.toJson(id);
    }

    @Nonnull
    private Map<String, AttributeValue> getItem(@Nonnull ID id, Comparable<?> value, boolean withValue) {
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        item.put("tag", AttributeValue.fromS((String)this.getTag()));
        item.put("id", AttributeValue.fromS((String)this.getIdValue(id, value)));
        if (withValue) {
            item.put(this.valColumn, this.getValueAttr(value));
        }
        return item;
    }

    protected boolean addToken(ID id, @Nullable Comparable<?> value) {
        this.batch.addPutItem(this.getItem(id, value, true));
        this.notfifySearchResultListener(value);
        return true;
    }

    protected boolean removeToken(ID id, @Nullable Comparable<?> value) {
        this.batch.addDeleteItem(this.getItem(id, value, false));
        this.notfifySearchResultListener(value);
        return true;
    }

    @Nonnull
    private AttributeValue getValueAttr(@Nullable Object value) {
        if (value == null) {
            return this.isNumber ? AttributeValue.fromN((String)NULL_NUMBER) : AttributeValue.fromS((String)NULL_STRING);
        }
        if ("".equals(value)) {
            return AttributeValue.fromS((String)EMPTY_STRING);
        }
        return this.isNumber ? AttributeValue.fromN((String)value.toString()) : AttributeValue.fromS((String)value.toString());
    }

    protected void search(Object value, SearchCondition condition, SearchResultHolder<ID> map, String token) {
        this.batch.flushAndWait();
        HashMap<String, AttributeValue> queryParams = new HashMap<String, AttributeValue>(2);
        queryParams.put(":tag", AttributeValue.fromS((String)this.getTag()));
        queryParams.put(":val", this.getValueAttr(value));
        Object keyCondition = "tag=:tag";
        String filter = null;
        String indexName = this.valColumn;
        switch (condition.getOperator()) {
            case StartsWith: {
                if (value.getClass() == String.class) {
                    keyCondition = (String)keyCondition + " AND begins_with(" + this.valColumn + ",:val)";
                    break;
                }
            }
            case Equals: {
                keyCondition = (String)keyCondition + " AND " + this.valColumn + "=:val";
                break;
            }
            case GT: {
                keyCondition = (String)keyCondition + " AND " + this.valColumn + ">:val";
                break;
            }
            case GE: {
                keyCondition = (String)keyCondition + " AND " + this.valColumn + ">=:val";
                break;
            }
            case LT: {
                keyCondition = (String)keyCondition + " AND " + this.valColumn + "<:val";
                break;
            }
            case LE: {
                keyCondition = (String)keyCondition + " AND " + this.valColumn + "<=:val";
                break;
            }
            case BETWEEN: {
                keyCondition = (String)keyCondition + " AND " + this.valColumn + " BETWEEN :val AND :val2";
                Object[] range = (Object[])value;
                queryParams.put(":val", this.getValueAttr(range[0]));
                queryParams.put(":val2", this.getValueAttr(range[1]));
                break;
            }
            case NOT_BETWEEN: {
                Object[] range = (Object[])value;
                this.search(range[0], new SearchCondition(condition, SearchCondition.SearchTermOperator.LT), map, token);
                keyCondition = (String)keyCondition + " AND " + this.valColumn + ">:val";
                queryParams.put(":val", this.getValueAttr(range[1]));
                break;
            }
            case Unequals: {
                this.search(value, condition, map, token, indexName, (String)keyCondition + " AND " + this.valColumn + "<:val", queryParams, filter);
                keyCondition = (String)keyCondition + " AND " + this.valColumn + ">:val";
                break;
            }
            case Contains: {
                filter = "contains(" + this.valColumn + ",:val)";
                indexName = null;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown operator: " + String.valueOf(condition.getOperator()));
            }
        }
        this.search(value, condition, map, token, indexName, (String)keyCondition, queryParams, filter);
    }

    private void search(Object value, SearchCondition condition, SearchResultHolder<ID> map, String token, String indexName, String keyCondition, Map<String, AttributeValue> queryParams, String filter) {
        String tag = this.getTag();
        QueryRequest.Builder builder = QueryRequest.builder().tableName(this.tableName).indexName(indexName).projectionExpression("id").keyConditionExpression(keyCondition).filterExpression(filter).expressionAttributeValues(queryParams);
        DynamoDbUtils.iterate(builder, item -> {
            Object val = this.valFromItem((Map<String, AttributeValue>)item);
            if (val == null) {
                switch (condition.getOperator()) {
                    case Equals: 
                    case Unequals: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            boolean equals = Objects.equals(val, value);
            ID id = this.idFromItem((Map<String, AttributeValue>)item);
            map.add(id, equals, tag, token, condition);
        });
    }

    protected void getAllIds(SearchResultHolder<ID> map, SearchCondition condition) {
        String tag = this.getTag();
        HashMap<String, AttributeValue> queryParams = new HashMap<String, AttributeValue>(2);
        queryParams.put(":tag", AttributeValue.fromS((String)tag));
        queryParams.put(":nullval", AttributeValue.fromS((String)"null : "));
        queryParams.put(":emptyval", AttributeValue.fromS((String)DELIMITER));
        QueryRequest.Builder builder = QueryRequest.builder().tableName(this.tableName).indexName(this.valColumn).projectionExpression("id").keyConditionExpression("tag=:tag").filterExpression("NOT begins_with(id,:nullval) AND NOT begins_with(id,:emptyval)").expressionAttributeValues(queryParams);
        this.batch.flushAndWait();
        DynamoDbUtils.iterate(builder, item -> {
            ID id = this.idFromItem((Map<String, AttributeValue>)item);
            map.add(id, true, tag, "", condition);
        });
    }

    protected void finishIndexing() {
        this.batch.flush();
        if (!this.isValid) {
            HashMap<String, AttributeValue> attrs = new HashMap<String, AttributeValue>();
            attrs.put("version", AttributeValue.fromS((String)FORMAT_VERSION));
            attrs.put("datatype", AttributeValue.fromS((String)this.getDataType().toString()));
            attrs.put("iddatatype", AttributeValue.fromS((String)this.idType.getSimpleName()));
            this.index.putMainItem(this.tableName, attrs);
            this.isValid = true;
        }
        this.batch.flushAndWait();
    }

    protected Object getMinToken() {
        return this.getMinMaxToken(true);
    }

    protected Object getMaxToken() {
        return this.getMinMaxToken(false);
    }

    @Nullable
    private Object getMinMaxToken(boolean forward) {
        QueryRequest.Builder builder = this.createIteratorBuilder(forward, null).limit(Integer.valueOf(2));
        this.batch.flushAndWait();
        List items = DynamoDbPersistence.getClient().query((QueryRequest)builder.build()).items();
        if (!items.isEmpty()) {
            Object val = this.valFromItem((Map)items.get(0));
            if (val == null && items.size() > 1) {
                val = this.valFromItem((Map)items.get(1));
            }
            return val;
        }
        return null;
    }

    @Nonnull
    private QueryRequest.Builder createIteratorBuilder(boolean forward, Comparable<?> startsWith) {
        HashMap<String, AttributeValue> queryParams = new HashMap<String, AttributeValue>(2);
        queryParams.put(":tag", AttributeValue.fromS((String)this.getTag()));
        Object dbFilter = "tag=:tag";
        if (startsWith != null) {
            if (startsWith.getClass() == String.class) {
                if (!((String)((Object)startsWith)).isEmpty()) {
                    dbFilter = (String)dbFilter + " AND begins_with(" + this.valColumn + ",:val)";
                    queryParams.put(":val", this.getValueAttr(startsWith));
                }
            } else {
                dbFilter = (String)dbFilter + " AND " + this.valColumn + "=:val";
                queryParams.put(":val", this.getValueAttr(startsWith));
            }
        }
        return QueryRequest.builder().tableName(this.tableName).indexName(this.valColumn).scanIndexForward(Boolean.valueOf(forward)).projectionExpression("id").keyConditionExpression((String)dbFilter).expressionAttributeValues(queryParams);
    }

    @Nonnull
    protected <T> Iterator<T> createIterator(boolean forward, final @Nonnull TagIndex.IteratorType itType, @Nullable Comparable<?> startsWith, final @Nonnull Predicate<ID> filter, final @Nullable Function<Object, String> formatter) {
        final QueryRequest.Builder builder = this.createIteratorBuilder(forward, startsWith);
        this.batch.flushAndWait();
        return new Iterator<T>(){
            private Object last = this;
            private Object lastVal = this;
            private ArrayDeque<Object> list = new ArrayDeque();
            private Map<String, AttributeValue> lastEvaluatedKey;
            private HashSet<ID> entryIDs;

            @Override
            public boolean hasNext() {
                while (this.list.isEmpty() && (this.lastEvaluatedKey == null || !this.lastEvaluatedKey.isEmpty())) {
                    QueryResponse response = DynamoDbPersistence.getClient().query((QueryRequest)builder.build());
                    block6: for (Map item : response.items()) {
                        Object next;
                        Object id = DynamoDbTagIndex.this.idFromItem(item);
                        if (!filter.test(id)) continue;
                        Object val = DynamoDbTagIndex.this.valFromItem(item);
                        switch (itType) {
                            case ID: {
                                next = id;
                                break;
                            }
                            case VALUES: {
                                next = formatter != null && val != null ? formatter.apply(val) : val;
                                break;
                            }
                            case ENTRY: {
                                if (this.entryIDs == null) {
                                    this.entryIDs = new HashSet();
                                    this.last = new AbstractMap.SimpleEntry(val, this.entryIDs);
                                } else if (!Objects.equals(val, this.lastVal)) {
                                    this.list.add(this.last);
                                    this.entryIDs = new HashSet();
                                    this.last = new AbstractMap.SimpleEntry(val, this.entryIDs);
                                }
                                this.entryIDs.add(id);
                                this.lastVal = val;
                                continue block6;
                            }
                            default: {
                                throw new IllegalStateException("Unkown type: " + String.valueOf(itType));
                            }
                        }
                        if (Objects.equals(next, this.last) && Objects.equals(val, this.lastVal)) continue;
                        this.last = next;
                        this.lastVal = val;
                        this.list.add(next == null ? this : next);
                    }
                    this.lastEvaluatedKey = response.lastEvaluatedKey();
                    builder.exclusiveStartKey(this.lastEvaluatedKey);
                }
                if (itType == TagIndex.IteratorType.ENTRY && this.last != null) {
                    this.list.add(this.last);
                    this.last = null;
                }
                return !this.list.isEmpty();
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    Object val = this.list.pop();
                    return val == this ? null : val;
                }
                throw new NoSuchElementException();
            }
        };
    }

    private void notfifySearchResultListener(@Nullable Comparable<?> value) {
        this.searchListeners.notifySearchResultListener(value);
    }

    protected void handleTokenChangedListener(@Nonnull Comparable<?> token, @Nonnull SearchResultListener<ID> listener, boolean add) {
        this.searchListeners.handleTokenChangedListener(token, listener, add);
    }

    protected void handleTokenChangedListener(@Nonnull ListenerTokenMatcher matcher, @Nonnull SearchResultListener<ID> listener, boolean add) {
        this.searchListeners.handleMatcherChangedListener(matcher, listener, add);
    }
}

