/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.azure.cosmos;

import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.ExcludedPath;
import com.azure.cosmos.models.IncludedPath;
import com.azure.cosmos.models.IndexingPolicy;
import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.util.CosmosPagedIterable;
import com.inet.annotations.JsonData;
import com.inet.error.ErrorCode;
import com.inet.id.GUID;
import com.inet.lib.io.ChunkedInputStream;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.util.IOFunctions;
import com.inet.persistence.PersistenceEntry;
import com.inet.persistence.RandomAccessRead;
import com.inet.persistence.azure.cosmos.AzureCosmosPersistence;
import com.inet.persistence.azure.cosmos.MonoQueue;
import com.inet.persistence.spi.PersistenceHelper;
import com.inet.persistence.spi.util.DatabaseRandomAccessRead;
import com.inet.shared.utils.WeakValueMap;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@SuppressFBWarnings(value={"PREDICTABLE_RANDOM"}, justification="Not security relevant")
public class AzureCosmosPersistenceEntry
extends PersistenceEntry {
    private static final Random random = new Random();
    private static final WeakValueMap<String, AzureCosmosPersistenceEntry> REFS_FOR_DELETE = new WeakValueMap(new ConcurrentHashMap());
    private static final int CHUNK_SIZE = 250000;
    @Nonnull
    private String path;
    private EntryPOJO entryState;

    AzureCosmosPersistenceEntry(String path) {
        this.path = PersistenceHelper.checkName((String)path);
    }

    private AzureCosmosPersistenceEntry(EntryPOJO state) {
        this(state.filename);
        this.entryState = state;
        this.putReference();
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nonnull
    public AzureCosmosPersistenceEntry resolve(@Nonnull String child) throws NullPointerException, IllegalArgumentException {
        String childPath = PersistenceHelper.resolve((String)this.path, (String)child);
        return new AzureCosmosPersistenceEntry(childPath);
    }

    @Nullable
    public AzureCosmosPersistenceEntry getParent() {
        String parentPath = PersistenceHelper.getParentPath((String)this.path);
        if (parentPath == null) {
            return null;
        }
        return new AzureCosmosPersistenceEntry(parentPath);
    }

    public boolean exists() {
        return this.getState() != null;
    }

    @Nonnull
    public List<PersistenceEntry> getChildren() {
        CosmosContainer fs = AzureCosmosPersistence.getFileSystem();
        SqlQuerySpec sql = new SqlQuerySpec("SELECT * FROM c WHERE c.parent = @path", this.getPathParam());
        CosmosPagedIterable items = fs.queryItems(sql, null, EntryPOJO.class);
        ArrayList<PersistenceEntry> entries = new ArrayList<PersistenceEntry>();
        for (EntryPOJO entry : items) {
            entries.add(new AzureCosmosPersistenceEntry(entry));
        }
        return entries;
    }

    private List<SqlParameter> searchFilter(@Nonnull String pattern) {
        String base = this.path.length() == 1 ? ("*".equals(pattern) ? this.path + "_" : this.path) : this.path + "/";
        pattern = pattern.replace('*', '%').replace('?', '_');
        return Arrays.asList(new SqlParameter("@pattern", (Object)(base + pattern)));
    }

    public long searchCount(@Nonnull String pattern) {
        SqlQuerySpec sql = new SqlQuerySpec("SELECT VALUE COUNT(1) FROM c WHERE c.filename like @pattern AND IS_NULL(c.chunkNumber)", this.searchFilter(pattern));
        CosmosContainer fs = AzureCosmosPersistence.getFileSystem();
        return (Long)fs.queryItems(sql, null, Long.class).iterator().next();
    }

    @Nonnull
    public Iterable<PersistenceEntry> search(@Nonnull String pattern) {
        CosmosContainer fs = AzureCosmosPersistence.getFileSystem();
        SqlQuerySpec sql = new SqlQuerySpec("SELECT * FROM c WHERE c.filename like @pattern AND IS_NULL(c.chunkNumber)", this.searchFilter(pattern));
        return () -> {
            final Iterator it = fs.queryItems(sql, null, EntryPOJO.class).iterator();
            return new Iterator<PersistenceEntry>(){

                @Override
                public PersistenceEntry next() {
                    return new AzureCosmosPersistenceEntry((EntryPOJO)it.next());
                }

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }
            };
        };
    }

    @Nullable
    public String getString() {
        byte[] bytes = this.getBytes();
        if (bytes == null) {
            return null;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public void setString(@Nonnull String value) throws NullPointerException {
        this.setBytes(value.getBytes(StandardCharsets.UTF_8));
    }

    public byte @Nullable [] getBytes() {
        EntryPOJO state = this.getState();
        if (state == null) {
            return null;
        }
        if (state.data != null) {
            return state.data;
        }
        InputStream inputStream = this.getInputStream();
        if (inputStream == null) {
            return null;
        }
        try {
            return IOFunctions.readBytes((InputStream)inputStream);
        }
        catch (IOException ex) {
            ErrorCode.throwAny((Throwable)ex);
            return null;
        }
    }

    public void setBytes(byte @Nonnull [] value) throws NullPointerException {
        Objects.nonNull(value);
        EntryPOJO entry = this.getState();
        if (entry == null) {
            for (AzureCosmosPersistenceEntry parent = this.getParent(); parent != null && !parent.exists(); parent = parent.getParent()) {
                parent.save(null, null);
            }
        }
        this.save(entry, value);
    }

    private void save(@Nullable EntryPOJO entry, byte @Nullable [] value) {
        try {
            boolean isNew;
            CosmosAsyncContainer fs = AzureCosmosPersistence.getAsyncFileSystem();
            if (entry == null) {
                entry = new EntryPOJO();
                entry.id = GUID.generateNew().toString();
                entry.filename = this.path;
                entry.parent = PersistenceHelper.getParentPath((String)this.path);
                isNew = true;
            } else {
                isNew = false;
            }
            MonoQueue queue = new MonoQueue(2);
            entry.lastModified = System.currentTimeMillis();
            int length = value != null ? value.length : 0;
            entry.length = length;
            if (length >= 500000) {
                Long chunkId = entry.chunkId = Long.valueOf(random.nextLong());
                int chunks = (length + 250000 - 1) / 250000;
                for (int i = 0; i < chunks; ++i) {
                    EntryPOJO chunk = new EntryPOJO();
                    chunk.id = GUID.generateNew().toString();
                    chunk.filename = this.path;
                    int from = 250000 * i;
                    int to = i == chunks - 1 ? length : from + 250000;
                    chunk.data = Arrays.copyOfRange(value, from, to);
                    chunk.chunkId = chunkId;
                    chunk.chunkNumber = i;
                    queue.add(fs.createItem((Object)chunk));
                }
                entry.data = null;
            } else {
                entry.data = value;
            }
            queue.add(fs.upsertItem((Object)entry));
            if (!isNew) {
                DefaultTimerTask cleanup = new DefaultTimerTask(){

                    public void runImpl() throws Throwable {
                        ForkJoinPool.commonPool().execute(() -> {
                            EntryPOJO state = AzureCosmosPersistenceEntry.this.getState();
                            if (state != null) {
                                SqlQuerySpec sql = new SqlQuerySpec("SELECT c.id, c.filename FROM c WHERE c.filename = @path AND c.chunkId != " + state.chunkId, AzureCosmosPersistenceEntry.this.getPathParam());
                                AzureCosmosPersistenceEntry.deleteItems(sql);
                            }
                        });
                    }
                };
                DefaultTimer.getInstance().schedule(cleanup, 100L);
            }
            queue.block();
        }
        catch (CosmosException ex) {
            throw AzureCosmosPersistence.userFriendlyException(ex);
        }
    }

    @Nullable
    public InputStream getInputStream() {
        EntryPOJO state = this.getState();
        if (state != null) {
            if (state.data != null) {
                return new FastByteArrayInputStream(state.data);
            }
            Long chunkId = state.chunkId;
            if (chunkId != null) {
                final long length = state.length;
                try {
                    SqlQuerySpec sql = new SqlQuerySpec("SELECT * FROM c WHERE c.filename = @path AND c.chunkId = " + chunkId + " AND c.chunkNumber != null ORDER BY c.chunkNumber", this.getPathParam());
                    CosmosContainer fs = AzureCosmosPersistence.getFileSystem();
                    CosmosPagedIterable items = fs.queryItems(sql, null, EntryPOJO.class);
                    final Iterator it = items.iterator();
                    return new ChunkedInputStream(){
                        private long size;

                        protected byte[] nextChunk() {
                            try {
                                if (it.hasNext()) {
                                    EntryPOJO next = (EntryPOJO)it.next();
                                    byte[] bytes = next.data;
                                    this.size += (long)bytes.length;
                                    return bytes;
                                }
                            }
                            catch (CosmosException ex) {
                                throw AzureCosmosPersistence.userFriendlyException(ex);
                            }
                            if (this.size != length) {
                                ErrorCode.throwAny((Throwable)new EOFException("Unexpected end of stream. (" + this.size + "/" + length + ")"));
                            }
                            return null;
                        }
                    };
                }
                catch (CosmosException ex) {
                    throw AzureCosmosPersistence.userFriendlyException(ex);
                }
            }
        }
        return null;
    }

    public void setInputStream(@Nonnull InputStream value) throws NullPointerException {
        try (OutputStream output = this.getOutputStream();){
            IOFunctions.copyData((InputStream)value, (OutputStream)output);
        }
        catch (IOException ex) {
            ErrorCode.throwAny((Throwable)ex);
        }
    }

    @Nonnull
    public OutputStream getOutputStream() {
        return new FastByteArrayOutputStream(){
            private boolean isClosed;

            public void write(int datum) {
                if (this.isClosed) {
                    ErrorCode.throwAny((Throwable)new IOException("Stream closed"));
                }
                super.write(datum);
            }

            public void write(byte[] data, int offset, int length) {
                if (this.isClosed) {
                    ErrorCode.throwAny((Throwable)new IOException("Stream closed"));
                }
                super.write(data, offset, length);
            }

            public void close() {
                if (!this.isClosed) {
                    this.isClosed = true;
                    AzureCosmosPersistenceEntry.this.setBytes(this.toByteArray());
                }
            }
        };
    }

    public long size() {
        EntryPOJO state = this.getState();
        return state == null ? 0L : state.length;
    }

    public void deleteTree() {
        SqlQuerySpec sql = this.path.length() == 1 ? new SqlQuerySpec("SELECT c.id, c.filename FROM c") : new SqlQuerySpec("SELECT c.id, c.filename FROM c WHERE c.filename = @path OR STARTSWITH( c.filename, @path || '/')", this.getPathParam());
        AzureCosmosPersistenceEntry.deleteItems(sql);
        this.deleteParentIfEmpty();
    }

    public void deleteValue() {
        if (this.hasChildren()) {
            EntryPOJO entry = this.getState();
            this.save(entry, null);
        } else {
            SqlQuerySpec sql = new SqlQuerySpec("SELECT c.id, c.filename FROM c WHERE c.filename = @path", this.getPathParam());
            AzureCosmosPersistenceEntry.deleteItems(sql);
            this.entryState = null;
            this.deleteParentIfEmpty();
        }
    }

    private static void deleteItems(SqlQuerySpec sql) {
        try {
            CosmosPagedIterable items = AzureCosmosPersistence.getFileSystem().queryItems(sql, null, EntryPOJO.class);
            CosmosItemRequestOptions options = new CosmosItemRequestOptions();
            MonoQueue queue = new MonoQueue(10);
            CosmosAsyncContainer fs = AzureCosmosPersistence.getAsyncFileSystem();
            for (EntryPOJO item : items) {
                AzureCosmosPersistenceEntry entry = (AzureCosmosPersistenceEntry)((Object)REFS_FOR_DELETE.get((Object)item.filename));
                if (entry != null) {
                    entry.entryState = null;
                }
                queue.add(fs.deleteItem((Object)item, options), th -> {
                    if (th instanceof CosmosException) {
                        CosmosException ex = (CosmosException)((Object)th);
                        if (ex.getStatusCode() != 404) {
                            throw AzureCosmosPersistence.userFriendlyException(ex);
                        }
                        return;
                    }
                    ErrorCode.throwAny((Throwable)th);
                });
            }
            queue.block();
        }
        catch (CosmosException ex) {
            throw AzureCosmosPersistence.userFriendlyException(ex);
        }
    }

    private void deleteParentIfEmpty() {
        CosmosContainer fs = AzureCosmosPersistence.getFileSystem();
        AzureCosmosPersistenceEntry parent = this;
        block0: while ((parent = parent.getParent()) != null) {
            if (parent.hasChildren()) {
                return;
            }
            SqlQuerySpec sql = new SqlQuerySpec("SELECT c.id, c.filename, c.length FROM c WHERE c.filename = @path", parent.getPathParam());
            Iterator iterator = fs.queryItems(sql, null, EntryPOJO.class).iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                EntryPOJO item = (EntryPOJO)iterator.next();
                if (item.length > 0L) {
                    return;
                }
                fs.deleteItem((Object)item, null);
                AzureCosmosPersistenceEntry entry = (AzureCosmosPersistenceEntry)((Object)REFS_FOR_DELETE.get((Object)item.filename));
                if (entry == null) continue;
                entry.entryState = null;
            }
            break;
        }
        return;
    }

    private boolean hasChildren() {
        SqlQuerySpec sql;
        CosmosContainer fs = AzureCosmosPersistence.getFileSystem();
        return (Integer)fs.queryItems(sql = new SqlQuerySpec("SELECT VALUE COUNT(1) FROM c WHERE c.parent = @path", this.getPathParam()), null, Integer.class).iterator().next() > 0;
    }

    public long lastModified() {
        EntryPOJO state = this.getState();
        return state == null ? 0L : state.lastModified;
    }

    public void moveTo(@Nonnull String newPath) throws IllegalStateException, IllegalArgumentException {
        if (this.path.length() <= 1) {
            throw new IllegalStateException("Persistence root can't moved");
        }
        if ((newPath = PersistenceHelper.checkName((String)PersistenceHelper.resolve((String)this.path, (String)newPath))).length() <= 1) {
            throw new IllegalArgumentException("can not moved to the root");
        }
        AzureCosmosPersistenceEntry newEntry = this.resolve(newPath);
        if (newEntry.exists()) {
            throw new IllegalStateException("target already exists");
        }
        if (newPath.startsWith(this.path + "/")) {
            throw new IllegalArgumentException("You can't move to a sub folder");
        }
        for (AzureCosmosPersistenceEntry parent = newEntry.getParent(); parent != null && !parent.exists(); parent = parent.getParent()) {
            parent.save(null, null);
        }
        SqlQuerySpec sql = new SqlQuerySpec("SELECT * FROM c WHERE c.filename like @pattern OR c.filename = @path", Arrays.asList(new SqlParameter("@pattern", (Object)(this.path + "/%")), new SqlParameter("@path", (Object)this.path)));
        CosmosPagedIterable items = AzureCosmosPersistence.getFileSystem().queryItems(sql, null, EntryPOJO.class);
        MonoQueue queue = new MonoQueue(10);
        CosmosAsyncContainer fs = AzureCosmosPersistence.getAsyncFileSystem();
        CosmosItemRequestOptions options = new CosmosItemRequestOptions();
        for (EntryPOJO item : items) {
            String oldFilename = item.filename;
            String newFilename = newPath + oldFilename.substring(this.path.length());
            EntryPOJO deleteItem = new EntryPOJO();
            deleteItem.id = item.id;
            deleteItem.filename = item.filename;
            item.id = GUID.generateNew().toString();
            item.filename = newFilename;
            item.parent = PersistenceHelper.getParentPath((String)newFilename);
            queue.add(fs.upsertItem((Object)item));
            queue.add(fs.deleteItem((Object)deleteItem, options), th -> {
                if (th instanceof CosmosException) {
                    CosmosException ex = (CosmosException)((Object)th);
                    if (ex.getStatusCode() != 404) {
                        throw (RuntimeException)ErrorCode.throwAny((Throwable)th);
                    }
                    return;
                }
                throw (RuntimeException)ErrorCode.throwAny((Throwable)th);
            });
            AzureCosmosPersistenceEntry entry = (AzureCosmosPersistenceEntry)((Object)REFS_FOR_DELETE.get((Object)oldFilename));
            if (entry == null) continue;
            entry.entryState = null;
        }
        queue.block();
        this.entryState = null;
        newEntry.entryState = null;
    }

    @Nullable
    private EntryPOJO getState() {
        EntryPOJO state = this.entryState;
        if (state == null) {
            try {
                CosmosContainer fs = AzureCosmosPersistence.getFileSystem();
                SqlQuerySpec sql = new SqlQuerySpec("SELECT * FROM c WHERE c.filename = @path AND IS_NULL(c.chunkNumber)", this.getPathParam());
                CosmosPagedIterable items = fs.queryItems(sql, null, EntryPOJO.class);
                Iterator it = items.iterator();
                if (it.hasNext()) {
                    this.entryState = state = (EntryPOJO)it.next();
                    this.putReference();
                }
            }
            catch (CosmosException ex) {
                throw AzureCosmosPersistence.userFriendlyException(ex);
            }
        }
        return state;
    }

    private void putReference() {
        AzureCosmosPersistenceEntry entry = (AzureCosmosPersistenceEntry)((Object)REFS_FOR_DELETE.put((Object)this.path, (Object)this));
        if (entry != null && entry != this) {
            entry.entryState = null;
        }
    }

    @Nonnull
    private List<SqlParameter> getPathParam() {
        return Arrays.asList(new SqlParameter("@path", (Object)this.path));
    }

    @Nonnull
    static CosmosContainerProperties getCosmosContainerProperties() {
        CosmosContainerProperties props = new CosmosContainerProperties("files", "/filename");
        IndexingPolicy indexing = new IndexingPolicy();
        indexing.setExcludedPaths(Arrays.asList(new ExcludedPath("/*")));
        indexing.setIncludedPaths(Arrays.asList(new IncludedPath("/filename/?"), new IncludedPath("/parent/?"), new IncludedPath("/chunkId/?"), new IncludedPath("/chunkNumber/?")));
        props.setIndexingPolicy(indexing);
        return props;
    }

    public RandomAccessRead getRandomAccessRead() throws UnsupportedOperationException {
        EntryPOJO state = this.getState();
        if (state == null) {
            return null;
        }
        if (state.data != null) {
            return RandomAccessRead.wrap((byte[])state.data);
        }
        return new AzureCosmosRandomAccessRead(state);
    }

    @JsonData
    private static class EntryPOJO {
        public String id;
        public String filename;
        public String parent;
        public long lastModified;
        public long length;
        public byte[] data;
        public Long chunkId;
        public Integer chunkNumber;

        private EntryPOJO() {
        }
    }

    private class AzureCosmosRandomAccessRead
    extends DatabaseRandomAccessRead<Long> {
        AzureCosmosRandomAccessRead(EntryPOJO state) {
            super(state.chunkId, state.length, 250000);
        }

        @Override
        protected byte[] getChunk(int chunkIdx) throws EOFException {
            byte[] chunk = (byte[])this.getCache().get((Object)chunkIdx);
            if (chunk == null) {
                try {
                    SqlQuerySpec sql = new SqlQuerySpec("SELECT * FROM c WHERE c.filename = @path AND c.chunkId = " + String.valueOf(this.getChunkId()) + " AND c.chunkNumber = " + chunkIdx, AzureCosmosPersistenceEntry.this.getPathParam());
                    CosmosContainer fs = AzureCosmosPersistence.getFileSystem();
                    CosmosPagedIterable items = fs.queryItems(sql, null, EntryPOJO.class);
                    Iterator it = items.iterator();
                    if (!it.hasNext()) {
                        throw new EOFException("Missing Chunk: " + chunkIdx);
                    }
                    EntryPOJO next = (EntryPOJO)it.next();
                    chunk = next.data;
                    this.getCache().put((Object)chunkIdx, (Object)chunk);
                }
                catch (CosmosException ex) {
                    throw AzureCosmosPersistence.userFriendlyException(ex);
                }
            }
            return chunk;
        }
    }
}

