/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.azure.cosmos;

import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.ExcludedPath;
import com.azure.cosmos.models.IndexingPolicy;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.persistence.azure.cosmos.AzureCosmosPersistence;
import com.inet.persistence.spi.util.BaseLocks;
import com.inet.thread.CountedReadWriteLock;
import com.inet.thread.ServerLock;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.annotation.Nonnull;

class AzureCosmosLocks
extends BaseLocks {
    private HashMap<CountedReadWriteLock, DatabaseTimerLock> locks = new HashMap();
    private CosmosContainer collection;

    AzureCosmosLocks() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerLock tryLock(@Nonnull String key) {
        CountedReadWriteLock readWriteLock = CountedReadWriteLock.tryReadWriteLockInstance((Object)key, (boolean)true);
        if (readWriteLock != null) {
            DatabaseTimerLock databaseLock;
            HashMap<CountedReadWriteLock, DatabaseTimerLock> hashMap = this.locks;
            synchronized (hashMap) {
                databaseLock = this.tryGetDatabaseTimerLock(key, readWriteLock);
            }
            if (databaseLock != null) {
                return () -> {
                    if (readWriteLock.unlock(true)) {
                        databaseLock.unlock();
                    }
                };
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ServerLock tryReadWriteLock(@Nonnull String key, @Nonnull CountedReadWriteLock readWriteLock, boolean writeLock) {
        DatabaseTimerLock databaseLock;
        HashMap<CountedReadWriteLock, DatabaseTimerLock> hashMap = this.locks;
        synchronized (hashMap) {
            databaseLock = this.locks.get(readWriteLock);
            if (databaseLock == null) {
                try (ServerLock totalLock = this.repeatTryLock("total:" + key);){
                    SqlQuerySpec sql;
                    String subKey;
                    if (totalLock == null) {
                        ServerLock serverLock = null;
                        return serverLock;
                    }
                    if (writeLock) {
                        subKey = key + ":write";
                        sql = new SqlQuerySpec("SELECT * FROM c WHERE c.id like @key", new SqlParameter[]{new SqlParameter("@key", (Object)(AzureCosmosPersistence.escapeLikePattern(key) + ":%"))});
                    } else {
                        subKey = key + ":" + GUID.generateNew().toString();
                        sql = new SqlQuerySpec("SELECT * FROM c WHERE c.id = @key", new SqlParameter[]{new SqlParameter("@key", (Object)(key + ":write"))});
                    }
                    try {
                        Iterator keys = this.getCollection().queryItems(sql, null, LockPOJO.class).iterator();
                        if (!keys.hasNext()) {
                            databaseLock = this.tryGetDatabaseTimerLock(subKey, readWriteLock);
                        }
                    }
                    catch (CosmosException ex) {
                        throw AzureCosmosPersistence.userFriendlyException(ex);
                    }
                }
            }
        }
        if (databaseLock != null) {
            DatabaseTimerLock dbLock = databaseLock;
            return () -> {
                if (readWriteLock.unlock(writeLock)) {
                    dbLock.unlock();
                }
            };
        }
        readWriteLock.unlock(writeLock);
        return null;
    }

    private ServerLock repeatTryLock(@Nonnull String key) {
        for (int i = 0; i < 100; ++i) {
            ServerLock totalLock = this.tryLock(key);
            if (totalLock != null) {
                return totalLock;
            }
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        return null;
    }

    @Nonnull
    private CosmosContainer getCollection() {
        if (this.collection == null) {
            CosmosContainerProperties props = new CosmosContainerProperties("locks", "/id");
            props.setDefaultTimeToLiveInSeconds(Integer.valueOf(300));
            IndexingPolicy indexing = new IndexingPolicy();
            indexing.setExcludedPaths(Arrays.asList(new ExcludedPath("/*")));
            props.setIndexingPolicy(indexing);
            this.collection = AzureCosmosPersistence.getOrCreateContainer(props);
        }
        return this.collection;
    }

    private DatabaseTimerLock tryGetDatabaseTimerLock(String key, CountedReadWriteLock lock) {
        try {
            DatabaseTimerLock databaseLock = this.locks.get(lock);
            if (databaseLock == null) {
                databaseLock = new DatabaseTimerLock(key, lock);
                this.locks.put(lock, databaseLock);
            }
            return databaseLock;
        }
        catch (CosmosException ex) {
            if (ex.getStatusCode() == 409) {
                return null;
            }
            throw AzureCosmosPersistence.userFriendlyException(ex);
        }
    }

    private class DatabaseTimerLock {
        private final LockPOJO item;
        private final CountedReadWriteLock lock;
        private DefaultTimerTask timer = new DefaultTimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runImpl() throws Throwable {
                CosmosContainer collection = AzureCosmosLocks.this.getCollection();
                DatabaseTimerLock databaseTimerLock = DatabaseTimerLock.this;
                synchronized (databaseTimerLock) {
                    collection.replaceItem((Object)DatabaseTimerLock.this.item, DatabaseTimerLock.this.item.id, new PartitionKey((Object)DatabaseTimerLock.this.item.id), null);
                }
            }
        };

        private DatabaseTimerLock(String key, CountedReadWriteLock lock) {
            this.lock = lock;
            LockPOJO item = this.item = new LockPOJO();
            item.id = key;
            AzureCosmosLocks.this.getCollection().createItem((Object)item);
            DefaultTimer.getInstance().scheduleAtFixedRate(this.timer, 60000L, 60000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unlock() {
            this.timer.cancel();
            AzureCosmosLocks.this.getCollection().deleteItem((Object)this.item, null);
            HashMap<CountedReadWriteLock, DatabaseTimerLock> hashMap = AzureCosmosLocks.this.locks;
            synchronized (hashMap) {
                AzureCosmosLocks.this.locks.remove(this.lock);
            }
        }
    }

    @JsonData
    private static class LockPOJO {
        public String id;

        private LockPOJO() {
        }
    }
}

