/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.dynamodb;

import com.inet.annotations.JsonData;
import com.inet.lib.json.Json;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceListener;
import com.inet.persistence.SearchIndexPersistence;
import com.inet.persistence.dynamodb.AsyncBatch;
import com.inet.persistence.dynamodb.DynamoDbPersistence;
import com.inet.persistence.dynamodb.DynamoDbTagIndex;
import com.inet.persistence.dynamodb.DynamoDbUtils;
import com.inet.persistence.spi.PersistenceLogger;
import com.inet.persistence.spi.searchlistener.SearchListenerContainer;
import com.inet.search.SearchTag;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.index.TagIndex;
import com.inet.shared.utils.WeakValueMap;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.services.dynamodb.model.ProjectionType;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.ResourceInUseException;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.services.dynamodb.waiters.DynamoDbWaiter;

class DynamoDbSearchIndexPersistence<ID>
implements SearchIndexPersistence<ID> {
    private static final String MAIN_TABLE = "index";
    private static final String MAIN_PK = "pk";
    private static final String MAIN_SK = "sk";
    private static final String MAIN_ITEM = ":";
    private static final String TBL_NAME = "tblName";
    private static final String REINDEX = "reindex";
    private static final String ATTRS = "attrs";
    static final String TAG = "tag";
    static final String ID = "id";
    static final String STR = "str";
    static final String NUM = "num";
    private static final WeakValueMap<String, DynamoDbSearchIndexPersistence<?>> INDEXES = new WeakValueMap();
    @Nonnull
    private static String mainTable = "index";
    private final String indexName;
    private IndexSearchEngine<ID> engine;
    private String tableName;
    private AsyncBatch batch;
    private Map<String, AttributeValue> indexAttrs;

    DynamoDbSearchIndexPersistence(@Nonnull String indexName) {
        this(indexName, null);
    }

    private DynamoDbSearchIndexPersistence(@Nonnull String indexName, @Nullable String tableName) {
        this.indexName = indexName;
        if (tableName == null) {
            tableName = this.getTableName();
            INDEXES.put((Object)indexName, (Object)this);
        } else {
            this.indexAttrs = new HashMap<String, AttributeValue>();
            HashMap<String, AttributeValue> item = this.indexAttrs;
            item.put(MAIN_PK, AttributeValue.fromS((String)indexName));
            item.put(MAIN_SK, AttributeValue.fromS((String)MAIN_ITEM));
            item.put(TBL_NAME, AttributeValue.fromS((String)tableName));
        }
        this.tableName = tableName;
        this.batch = new AsyncBatch(tableName, TAG, ID);
        this.createIndexIable();
    }

    static void createMainTable(DynamoDbClient client, DynamoDbPersistence persistence) {
        try {
            mainTable = DynamoDbPersistence.getTablePrefix() + MAIN_TABLE;
            AttributeDefinition pkAttr = (AttributeDefinition)AttributeDefinition.builder().attributeName(MAIN_PK).attributeType(ScalarAttributeType.S).build();
            AttributeDefinition skAttr = (AttributeDefinition)AttributeDefinition.builder().attributeName(MAIN_SK).attributeType(ScalarAttributeType.S).build();
            KeySchemaElement pk = (KeySchemaElement)KeySchemaElement.builder().attributeName(MAIN_PK).keyType(KeyType.HASH).build();
            KeySchemaElement sk = (KeySchemaElement)KeySchemaElement.builder().attributeName(MAIN_SK).keyType(KeyType.RANGE).build();
            CreateTableRequest tableRequest = (CreateTableRequest)CreateTableRequest.builder().attributeDefinitions(new AttributeDefinition[]{pkAttr, skAttr}).keySchema(new KeySchemaElement[]{pk, sk}).billingMode(BillingMode.PAY_PER_REQUEST).tableName(mainTable).build();
            client.createTable(tableRequest);
            PersistenceLogger.LOGGER.debug((Object)("Table '" + mainTable + "' created"));
        }
        catch (ResourceInUseException ex) {
            PersistenceLogger.LOGGER.debug((Object)("Table '" + mainTable + "' already exists"));
        }
        persistence.registerListener(new PersistenceListener<ReplaceIndexEvent>(){

            public void eventReceived(@Nonnull ReplaceIndexEvent event) {
                DynamoDbSearchIndexPersistence index = (DynamoDbSearchIndexPersistence)INDEXES.get((Object)event.indexName);
                if (index != null) {
                    index.tableName = index.getTableName();
                }
            }
        });
    }

    void createIndexIable() {
        try {
            DynamoDbClient client = DynamoDbPersistence.getClient();
            AttributeDefinition tagAttr = (AttributeDefinition)AttributeDefinition.builder().attributeName(TAG).attributeType(ScalarAttributeType.S).build();
            AttributeDefinition idAttr = (AttributeDefinition)AttributeDefinition.builder().attributeName(ID).attributeType(ScalarAttributeType.S).build();
            AttributeDefinition strAttr = (AttributeDefinition)AttributeDefinition.builder().attributeName(STR).attributeType(ScalarAttributeType.S).build();
            AttributeDefinition numAttr = (AttributeDefinition)AttributeDefinition.builder().attributeName(NUM).attributeType(ScalarAttributeType.N).build();
            KeySchemaElement tag = (KeySchemaElement)KeySchemaElement.builder().attributeName(TAG).keyType(KeyType.HASH).build();
            KeySchemaElement id = (KeySchemaElement)KeySchemaElement.builder().attributeName(ID).keyType(KeyType.RANGE).build();
            KeySchemaElement str = (KeySchemaElement)KeySchemaElement.builder().attributeName(STR).keyType(KeyType.RANGE).build();
            KeySchemaElement num = (KeySchemaElement)KeySchemaElement.builder().attributeName(NUM).keyType(KeyType.RANGE).build();
            Projection projection = (Projection)Projection.builder().projectionType(ProjectionType.ALL).build();
            LocalSecondaryIndex idxStr = (LocalSecondaryIndex)LocalSecondaryIndex.builder().indexName(STR).projection(projection).keySchema(new KeySchemaElement[]{tag, str}).build();
            LocalSecondaryIndex idxNum = (LocalSecondaryIndex)LocalSecondaryIndex.builder().indexName(NUM).projection(projection).keySchema(new KeySchemaElement[]{tag, num}).build();
            CreateTableRequest tableRequest = (CreateTableRequest)CreateTableRequest.builder().attributeDefinitions(new AttributeDefinition[]{tagAttr, idAttr, strAttr, numAttr}).keySchema(new KeySchemaElement[]{tag, id}).localSecondaryIndexes(new LocalSecondaryIndex[]{idxStr, idxNum}).billingMode(BillingMode.PAY_PER_REQUEST).tableName(this.tableName).build();
            client.createTable(tableRequest);
            DynamoDbWaiter dbWaiter = client.waiter();
            dbWaiter.waitUntilTableExists((DescribeTableRequest)DescribeTableRequest.builder().tableName(this.tableName).build());
        }
        catch (ResourceInUseException ex) {
            PersistenceLogger.LOGGER.debug((Object)("Table '" + this.tableName + "' already exists"));
        }
    }

    public void setEngine(IndexSearchEngine<ID> engine) {
        this.engine = engine;
    }

    public TagIndex<ID> createTag(@Nonnull SearchTag searchTag) throws IOException {
        SearchListenerContainer searchListeners = DynamoDbPersistence.getSearchListenerManager().createContainer(this.indexName, searchTag);
        return new DynamoDbTagIndex<ID>(this, searchTag, this.engine, this.tableName, this.batch, false, searchListeners);
    }

    public void deleteTag(String tag) throws IOException {
        QueryRequest.Builder builder = QueryRequest.builder().tableName(this.tableName).projectionExpression("tag,id").keyConditionExpression("tag=:tag").expressionAttributeValues(Collections.singletonMap(":tag", AttributeValue.fromS((String)tag)));
        DynamoDbUtils.batchDelete(builder);
    }

    public boolean needReindex() {
        AttributeValue attrs = this.indexAttrs.get(REINDEX);
        if (attrs == null) {
            return false;
        }
        return attrs.bool();
    }

    public void markForReindex() throws IOException {
        this.indexAttrs.put(REINDEX, AttributeValue.fromBool((Boolean)Boolean.TRUE));
        DynamoDbUtils.putItem(mainTable, this.indexAttrs);
    }

    public Map<String, String> loadIndexAttributes() {
        AttributeValue attrs = this.indexAttrs.get(ATTRS);
        if (attrs != null) {
            try {
                String data = attrs.s();
                if (data != null) {
                    return (Map)new Json().fromJson(data, Map.class);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new HashMap<String, String>();
    }

    public void saveIndexAttributes(@Nonnull Map<String, String> attrs) throws IOException {
        this.indexAttrs.put(ATTRS, AttributeValue.fromS((String)new Json().toJson(attrs)));
        DynamoDbUtils.putItem(mainTable, this.indexAttrs);
    }

    public String getName() {
        return this.indexName;
    }

    public void saveOutstanding() {
        this.batch.flushAndWait();
    }

    @Nullable
    public SearchIndexPersistence<ID> copy() throws IOException {
        int count;
        this.markForReindex();
        String countStr = this.tableName.substring(this.tableName.length() - 1);
        try {
            count = Integer.valueOf(countStr);
        }
        catch (NumberFormatException e) {
            count = 0;
        }
        ++count;
        String newTableName = mainTable + "." + this.indexName + (count %= 10);
        return new DynamoDbSearchIndexPersistence<ID>(this.indexName, newTableName);
    }

    public void replaceWith(SearchIndexPersistence<ID> copy, Map<SearchTag, TagIndex<ID>> searchTags) throws IOException {
        DynamoDbSearchIndexPersistence source = (DynamoDbSearchIndexPersistence)copy;
        final String oldTableName = this.tableName;
        this.tableName = source.tableName;
        this.batch = source.batch;
        this.indexAttrs = source.indexAttrs;
        DynamoDbUtils.putItem(mainTable, this.indexAttrs);
        ReplaceIndexEvent event = new ReplaceIndexEvent();
        event.indexName = this.indexName;
        Persistence.getInstance().sendEvent((Object)event);
        DefaultTimer.getInstance().schedule(new DefaultTimerTask(){

            public void runImpl() throws Throwable {
                DynamoDbPersistence.getClient().deleteTable((DeleteTableRequest)DeleteTableRequest.builder().tableName(oldTableName).build());
            }
        }, 1000L);
    }

    public void delete() {
        String keyExpression;
        DynamoDbClient client = DynamoDbPersistence.getClient();
        client.deleteTable((DeleteTableRequest)DeleteTableRequest.builder().tableName(this.tableName).build());
        HashMap<String, AttributeValue> queryParams = new HashMap<String, AttributeValue>(2);
        queryParams.put(":indexName", AttributeValue.fromS((String)this.indexName));
        if (INDEXES.get((Object)this.indexName) == this) {
            keyExpression = "pk=:indexName";
        } else {
            keyExpression = "pk=:indexName AND sk=:tableName";
            queryParams.put(":tableName", AttributeValue.fromS((String)this.tableName));
        }
        QueryRequest.Builder builder = QueryRequest.builder().tableName(mainTable).keyConditionExpression(keyExpression).expressionAttributeValues(queryParams).projectionExpression("pk,sk");
        DynamoDbUtils.batchDelete(builder);
    }

    public void changesCompleted() {
        this.batch.flush();
    }

    @Nonnull
    Map<String, AttributeValue> getMainItem(String itemName) {
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put(MAIN_PK, AttributeValue.fromS((String)this.indexName));
        key.put(MAIN_SK, AttributeValue.fromS((String)itemName));
        GetItemRequest itemRequest = (GetItemRequest)GetItemRequest.builder().tableName(mainTable).key(key).build();
        return DynamoDbPersistence.getClient().getItem(itemRequest).item();
    }

    void putMainItem(String itemName, Map<String, AttributeValue> item) {
        item.put(MAIN_PK, AttributeValue.fromS((String)this.indexName));
        item.put(MAIN_SK, AttributeValue.fromS((String)itemName));
        DynamoDbUtils.putItem(mainTable, item);
    }

    @Nonnull
    private String getTableName() {
        this.indexAttrs = new HashMap<String, AttributeValue>(this.getMainItem(MAIN_ITEM));
        AttributeValue attr = this.indexAttrs.get(TBL_NAME);
        if (attr != null) {
            return attr.s();
        }
        String tableName = mainTable + "." + this.indexName + "0";
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        item.put(TBL_NAME, AttributeValue.fromS((String)tableName));
        this.putMainItem(MAIN_ITEM, item);
        this.indexAttrs = item;
        return tableName;
    }

    @JsonData
    private static class ReplaceIndexEvent {
        String indexName;

        private ReplaceIndexEvent() {
        }
    }
}

