/*
 * Decompiled with CFR 0.152.
 */
package org.bson.types;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.SecureRandom;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.assertions.Assertions;

public final class ObjectId
implements Comparable<ObjectId>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int OBJECT_ID_LENGTH = 12;
    private static final int LOW_ORDER_THREE_BYTES = 0xFFFFFF;
    private static final long RANDOM_VALUE;
    private static final AtomicInteger NEXT_COUNTER;
    private static final char[] HEX_CHARS;
    private final int timestamp;
    private final long nonce;

    public static ObjectId get() {
        return new ObjectId();
    }

    public static ObjectId getSmallestWithDate(Date date) {
        return new ObjectId(ObjectId.dateToTimestampSeconds(date), 0L);
    }

    public static boolean isValid(String hexString) {
        if (hexString == null) {
            throw new IllegalArgumentException();
        }
        int len = hexString.length();
        if (len != 24) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c = hexString.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    public ObjectId() {
        this(new Date());
    }

    public ObjectId(Date date) {
        this(ObjectId.dateToTimestampSeconds(date), RANDOM_VALUE | (long)(NEXT_COUNTER.getAndIncrement() & 0xFFFFFF));
    }

    public ObjectId(Date date, int counter) {
        this(ObjectId.dateToTimestampSeconds(date), ObjectId.getNonceFromUntrustedCounter(counter));
    }

    public ObjectId(int timestamp, int counter) {
        this(timestamp, ObjectId.getNonceFromUntrustedCounter(counter));
    }

    private ObjectId(int timestamp, long nonce) {
        this.timestamp = timestamp;
        this.nonce = nonce;
    }

    private static long getNonceFromUntrustedCounter(int counter) {
        if ((counter & 0xFF000000) != 0) {
            throw new IllegalArgumentException("The counter must be between 0 and 16777215 (it must fit in three bytes).");
        }
        return RANDOM_VALUE | (long)counter;
    }

    public ObjectId(String hexString) {
        this(ObjectId.parseHexString(hexString));
    }

    public ObjectId(byte[] bytes) {
        this(ByteBuffer.wrap(Assertions.isTrueArgument("bytes has length of 12", bytes, Assertions.notNull("bytes", bytes).length == 12)));
    }

    public ObjectId(ByteBuffer buffer) {
        Assertions.notNull("buffer", buffer);
        Assertions.isTrueArgument("buffer.remaining() >=12", buffer.remaining() >= 12);
        ByteOrder originalOrder = buffer.order();
        try {
            buffer.order(ByteOrder.BIG_ENDIAN);
            this.timestamp = buffer.getInt();
            this.nonce = buffer.getLong();
        }
        finally {
            buffer.order(originalOrder);
        }
    }

    public byte[] toByteArray() {
        return ByteBuffer.allocate(12).putInt(this.timestamp).putLong(this.nonce).array();
    }

    public void putToByteBuffer(ByteBuffer buffer) {
        Assertions.notNull("buffer", buffer);
        Assertions.isTrueArgument("buffer.remaining() >=12", buffer.remaining() >= 12);
        ByteOrder originalOrder = buffer.order();
        try {
            buffer.order(ByteOrder.BIG_ENDIAN);
            buffer.putInt(this.timestamp);
            buffer.putLong(this.nonce);
        }
        finally {
            buffer.order(originalOrder);
        }
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public Date getDate() {
        return new Date(((long)this.timestamp & 0xFFFFFFFFL) * 1000L);
    }

    public String toHexString() {
        char[] chars = new char[24];
        int i = 0;
        for (byte b : this.toByteArray()) {
            chars[i++] = HEX_CHARS[b >> 4 & 0xF];
            chars[i++] = HEX_CHARS[b & 0xF];
        }
        return new String(chars);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectId other = (ObjectId)o;
        if (this.timestamp != other.timestamp) {
            return false;
        }
        return this.nonce == other.nonce;
    }

    public int hashCode() {
        return 31 * this.timestamp + Long.hashCode(this.nonce);
    }

    @Override
    public int compareTo(ObjectId other) {
        int cmp = Integer.compareUnsigned(this.timestamp, other.timestamp);
        if (cmp != 0) {
            return cmp;
        }
        return Long.compareUnsigned(this.nonce, other.nonce);
    }

    public String toString() {
        return this.toHexString();
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static byte[] parseHexString(String s) {
        Assertions.notNull("hexString", s);
        Assertions.isTrueArgument("hexString has 24 characters", s.length() == 24);
        byte[] b = new byte[12];
        for (int i = 0; i < b.length; ++i) {
            int pos = i << 1;
            char c1 = s.charAt(pos);
            char c2 = s.charAt(pos + 1);
            b[i] = (byte)((ObjectId.hexCharToInt(c1) << 4) + ObjectId.hexCharToInt(c2));
        }
        return b;
    }

    private static int hexCharToInt(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 87;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 55;
        }
        throw new IllegalArgumentException("invalid hexadecimal character: [" + c + "]");
    }

    private static int dateToTimestampSeconds(Date time) {
        return (int)(time.getTime() / 1000L);
    }

    static {
        HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            SecureRandom secureRandom = new SecureRandom();
            RANDOM_VALUE = secureRandom.nextLong() & 0xFFFFFFFFFF000000L;
            NEXT_COUNTER = new AtomicInteger(secureRandom.nextInt());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final byte[] bytes;

        SerializationProxy(ObjectId objectId) {
            this.bytes = objectId.toByteArray();
        }

        private Object readResolve() {
            return new ObjectId(this.bytes);
        }
    }
}

