/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.ContributorInsightsStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContributorInsightsSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContributorInsightsSummary> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(ContributorInsightsSummary.getter(ContributorInsightsSummary::tableName)).setter(ContributorInsightsSummary.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexName").getter(ContributorInsightsSummary.getter(ContributorInsightsSummary::indexName)).setter(ContributorInsightsSummary.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()}).build();
    private static final SdkField<String> CONTRIBUTOR_INSIGHTS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContributorInsightsStatus").getter(ContributorInsightsSummary.getter(ContributorInsightsSummary::contributorInsightsStatusAsString)).setter(ContributorInsightsSummary.setter(Builder::contributorInsightsStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributorInsightsStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD, INDEX_NAME_FIELD, CONTRIBUTOR_INSIGHTS_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContributorInsightsSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String tableName;
    private final String indexName;
    private final String contributorInsightsStatus;

    private ContributorInsightsSummary(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.indexName = builder.indexName;
        this.contributorInsightsStatus = builder.contributorInsightsStatus;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final ContributorInsightsStatus contributorInsightsStatus() {
        return ContributorInsightsStatus.fromValue(this.contributorInsightsStatus);
    }

    public final String contributorInsightsStatusAsString() {
        return this.contributorInsightsStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.contributorInsightsStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContributorInsightsSummary)) {
            return false;
        }
        ContributorInsightsSummary other = (ContributorInsightsSummary)obj;
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.contributorInsightsStatusAsString(), other.contributorInsightsStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ContributorInsightsSummary").add("TableName", (Object)this.tableName()).add("IndexName", (Object)this.indexName()).add("ContributorInsightsStatus", (Object)this.contributorInsightsStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "ContributorInsightsStatus": {
                return Optional.ofNullable(clazz.cast(this.contributorInsightsStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("IndexName", INDEX_NAME_FIELD);
        map.put("ContributorInsightsStatus", CONTRIBUTOR_INSIGHTS_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContributorInsightsSummary, T> g) {
        return obj -> g.apply((ContributorInsightsSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tableName;
        private String indexName;
        private String contributorInsightsStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ContributorInsightsSummary model) {
            this.tableName(model.tableName);
            this.indexName(model.indexName);
            this.contributorInsightsStatus(model.contributorInsightsStatus);
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getContributorInsightsStatus() {
            return this.contributorInsightsStatus;
        }

        public final void setContributorInsightsStatus(String contributorInsightsStatus) {
            this.contributorInsightsStatus = contributorInsightsStatus;
        }

        @Override
        public final Builder contributorInsightsStatus(String contributorInsightsStatus) {
            this.contributorInsightsStatus = contributorInsightsStatus;
            return this;
        }

        @Override
        public final Builder contributorInsightsStatus(ContributorInsightsStatus contributorInsightsStatus) {
            this.contributorInsightsStatus(contributorInsightsStatus == null ? null : contributorInsightsStatus.toString());
            return this;
        }

        public ContributorInsightsSummary build() {
            return new ContributorInsightsSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContributorInsightsSummary> {
        public Builder tableName(String var1);

        public Builder indexName(String var1);

        public Builder contributorInsightsStatus(String var1);

        public Builder contributorInsightsStatus(ContributorInsightsStatus var1);
    }
}

