/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.models.SpatialType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;

public final class SpatialSpec {
    private List<SpatialType> spatialTypes;
    private JsonSerializable jsonSerializable;

    public SpatialSpec() {
        this.jsonSerializable = new JsonSerializable();
    }

    SpatialSpec(String jsonString) {
        this.jsonSerializable = new JsonSerializable(jsonString);
    }

    SpatialSpec(ObjectNode objectNode) {
        this.jsonSerializable = new JsonSerializable(objectNode);
    }

    public String getPath() {
        return this.jsonSerializable.getString("path");
    }

    public SpatialSpec setPath(String path) {
        this.jsonSerializable.set("path", path);
        return this;
    }

    public List<SpatialType> getSpatialTypes() {
        if (this.spatialTypes == null) {
            this.spatialTypes = this.jsonSerializable.getList("types", SpatialType.class, true);
            if (this.spatialTypes == null) {
                this.spatialTypes = new ArrayList<SpatialType>();
            }
        }
        return this.spatialTypes;
    }

    public SpatialSpec setSpatialTypes(List<SpatialType> spatialTypes) {
        this.spatialTypes = spatialTypes;
        ArrayList<String> spatialTypeNames = new ArrayList<String>();
        for (SpatialType spatialType : this.spatialTypes) {
            spatialTypeNames.add(spatialType.toString());
        }
        this.jsonSerializable.set("types", spatialTypeNames);
        return this;
    }

    void populatePropertyBag() {
        this.jsonSerializable.populatePropertyBag();
    }

    JsonSerializable getJsonSerializable() {
        return this.jsonSerializable;
    }
}

