/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.models.PartitionKey;
import java.util.Objects;

public final class CosmosItemIdentity {
    private final PartitionKey partitionKey;
    private final String id;

    public CosmosItemIdentity(PartitionKey partitionKey, String id) {
        if (partitionKey == null) {
            throw new IllegalArgumentException("partitionKey is null.");
        }
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("id is null or empty");
        }
        this.partitionKey = partitionKey;
        this.id = id;
    }

    public PartitionKey getPartitionKey() {
        return this.partitionKey;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CosmosItemIdentity that = (CosmosItemIdentity)o;
        return Objects.equals(this.partitionKey, that.partitionKey) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.partitionKey.toString(), this.id);
    }
}

