/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.routing;

import com.azure.cosmos.implementation.routing.UInt128;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class MurmurHash3_128 {
    private static final UInt128 zeroSeed = new UInt128(0L, 0L);

    public static UInt128 hash128(byte[] bytes, int limit) {
        return MurmurHash3_128.hash128(bytes, limit, zeroSeed);
    }

    public static <T> UInt128 hash128(T value, UInt128 seed) throws IOException {
        if (value instanceof UInt128) {
            ByteBuffer buffer = ((UInt128)value).toByteBuffer();
            return MurmurHash3_128.hash128(buffer.array(), buffer.array().length, seed);
        }
        if (value instanceof Serializable) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(out);
            os.writeObject(value);
            return MurmurHash3_128.hash128(out.toByteArray(), out.toByteArray().length, seed);
        }
        throw new IllegalArgumentException(String.format("Unexpected type: %s", value.getClass().toString()));
    }

    public static UInt128 hash128(byte[] bytes, int length, UInt128 seed) {
        long k2;
        long k1;
        int position;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        long h1 = seed.high;
        long h2 = seed.low;
        for (position = 0; position < length - 15; position += 16) {
            k1 = MurmurHash3_128.getLittleEndianLong(bytes, position);
            k2 = MurmurHash3_128.getLittleEndianLong(bytes, position + 8);
            k1 *= -8663945395140668459L;
            k1 = MurmurHash3_128.rotateLeft64(k1, 31);
            h1 ^= (k1 *= 5545529020109919103L);
            h1 = MurmurHash3_128.rotateLeft64(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            k2 *= 5545529020109919103L;
            k2 = MurmurHash3_128.rotateLeft64(k2, 33);
            h2 ^= (k2 *= -8663945395140668459L);
            h2 = MurmurHash3_128.rotateLeft64(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        k1 = 0L;
        k2 = 0L;
        int n = length & 0xF;
        if (n >= 15) {
            k2 ^= ((long)bytes[position + 14] & 0xFFL) << 48;
        }
        if (n >= 14) {
            k2 ^= ((long)bytes[position + 13] & 0xFFL) << 40;
        }
        if (n >= 13) {
            k2 ^= ((long)bytes[position + 12] & 0xFFL) << 32;
        }
        if (n >= 12) {
            k2 ^= ((long)bytes[position + 11] & 0xFFL) << 24;
        }
        if (n >= 11) {
            k2 ^= ((long)bytes[position + 10] & 0xFFL) << 16;
        }
        if (n >= 10) {
            k2 ^= ((long)bytes[position + 9] & 0xFFL) << 8;
        }
        if (n >= 9) {
            k2 ^= ((long)bytes[position + 8] & 0xFFL) << 0;
        }
        k2 *= 5545529020109919103L;
        k2 = MurmurHash3_128.rotateLeft64(k2, 33);
        h2 ^= (k2 *= -8663945395140668459L);
        if (n >= 8) {
            k1 ^= ((long)bytes[position + 7] & 0xFFL) << 56;
        }
        if (n >= 7) {
            k1 ^= ((long)bytes[position + 6] & 0xFFL) << 48;
        }
        if (n >= 6) {
            k1 ^= ((long)bytes[position + 5] & 0xFFL) << 40;
        }
        if (n >= 5) {
            k1 ^= ((long)bytes[position + 4] & 0xFFL) << 32;
        }
        if (n >= 4) {
            k1 ^= ((long)bytes[position + 3] & 0xFFL) << 24;
        }
        if (n >= 3) {
            k1 ^= ((long)bytes[position + 2] & 0xFFL) << 16;
        }
        if (n >= 2) {
            k1 ^= ((long)bytes[position + 1] & 0xFFL) << 8;
        }
        if (n >= 1) {
            k1 ^= ((long)bytes[position + 0] & 0xFFL) << 0;
        }
        k1 *= -8663945395140668459L;
        k1 = MurmurHash3_128.rotateLeft64(k1, 31);
        h1 ^= (k1 *= 5545529020109919103L);
        h1 ^= (long)length;
        h1 += (h2 ^= (long)length);
        h2 += h1;
        h1 ^= h1 >>> 33;
        h1 *= -49064778989728563L;
        h1 ^= h1 >>> 33;
        h1 *= -4265267296055464877L;
        h1 ^= h1 >>> 33;
        h2 ^= h2 >>> 33;
        h2 *= -49064778989728563L;
        h2 ^= h2 >>> 33;
        h2 *= -4265267296055464877L;
        h2 ^= h2 >>> 33;
        h1 += h2;
        h2 += h1;
        h1 = Long.reverseBytes(h1);
        h2 = Long.reverseBytes(h2);
        return new UInt128(h1, h2);
    }

    private static long rotateLeft64(long n, int numBits) {
        assert (numBits < 64);
        return Long.rotateLeft(n, numBits);
    }

    private static final long getLittleEndianLong(byte[] bytes, int offset) {
        return (long)bytes[offset + 7] << 56 | ((long)bytes[offset + 6] & 0xFFL) << 48 | ((long)bytes[offset + 5] & 0xFFL) << 40 | ((long)bytes[offset + 4] & 0xFFL) << 32 | ((long)bytes[offset + 3] & 0xFFL) << 24 | ((long)bytes[offset + 2] & 0xFFL) << 16 | ((long)bytes[offset + 1] & 0xFFL) << 8 | (long)bytes[offset] & 0xFFL;
    }
}

