/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query.metrics;

import com.azure.cosmos.implementation.apachecommons.lang.tuple.ImmutablePair;
import com.azure.cosmos.implementation.query.metrics.FetchExecutionRange;
import com.azure.cosmos.implementation.query.metrics.SchedulingTimeSpan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class ClientSideMetrics {
    public static final ClientSideMetrics ZERO = new ClientSideMetrics(0, 0.0, new ArrayList<FetchExecutionRange>(), new ArrayList<ImmutablePair<String, SchedulingTimeSpan>>());
    private final long retries;
    private final double requestCharge;
    private final List<FetchExecutionRange> fetchExecutionRanges;
    private final List<ImmutablePair<String, SchedulingTimeSpan>> partitionSchedulingTimeSpans;

    public ClientSideMetrics(int retries, double requestCharge, List<FetchExecutionRange> executionRanges, List<ImmutablePair<String, SchedulingTimeSpan>> schedulingTimeSpans) {
        if (executionRanges == null || executionRanges.contains(null)) {
            throw new NullPointerException("executionRanges");
        }
        if (schedulingTimeSpans == null || schedulingTimeSpans.contains(null)) {
            throw new NullPointerException("schedulingTimeSpans");
        }
        if (retries < 0) {
            throw new IllegalArgumentException("retries must not be negative");
        }
        if (requestCharge < 0.0) {
            throw new IllegalArgumentException("requestCharge must not be negative");
        }
        this.retries = retries;
        this.requestCharge = requestCharge;
        this.fetchExecutionRanges = executionRanges;
        this.partitionSchedulingTimeSpans = schedulingTimeSpans;
    }

    public long getRetries() {
        return this.retries;
    }

    public double getRequestCharge() {
        return this.requestCharge;
    }

    public static ClientSideMetrics createFromCollection(Collection<ClientSideMetrics> clientSideMetricsCollection) {
        if (clientSideMetricsCollection == null) {
            throw new NullPointerException("clientSideMetricsCollection");
        }
        int retries = 0;
        double requestCharge = 0.0;
        ArrayList<FetchExecutionRange> fetchExecutionRanges = new ArrayList<FetchExecutionRange>();
        ArrayList<ImmutablePair<String, SchedulingTimeSpan>> partitionSchedulingTimeSpans = new ArrayList<ImmutablePair<String, SchedulingTimeSpan>>();
        for (ClientSideMetrics clientSideQueryMetrics : clientSideMetricsCollection) {
            retries = (int)((long)retries + clientSideQueryMetrics.retries);
            requestCharge += clientSideQueryMetrics.requestCharge;
            fetchExecutionRanges.addAll(clientSideQueryMetrics.fetchExecutionRanges);
            partitionSchedulingTimeSpans.addAll(clientSideQueryMetrics.partitionSchedulingTimeSpans);
        }
        return new ClientSideMetrics(retries, requestCharge, fetchExecutionRanges, partitionSchedulingTimeSpans);
    }

    static double getOrDefault(HashMap<String, Double> metrics, String key) {
        Double doubleReference = metrics.get(key);
        return doubleReference == null ? 0.0 : doubleReference;
    }

    public List<FetchExecutionRange> getFetchExecutionRanges() {
        return this.fetchExecutionRanges;
    }

    public List<ImmutablePair<String, SchedulingTimeSpan>> getPartitionSchedulingTimeSpans() {
        return this.partitionSchedulingTimeSpans;
    }
}

