/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.query.DistinctHash;
import com.azure.cosmos.implementation.query.DistinctMap;
import com.azure.cosmos.implementation.routing.UInt128;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class UnorderedDistinctMap
extends DistinctMap {
    private final Set<UInt128> resultSet = Collections.newSetFromMap(new ConcurrentHashMap());

    @Override
    public boolean add(Object resource, Utils.ValueHolder<UInt128> outHash) {
        try {
            if (resource instanceof Resource) {
                resource = this.getSortedJsonStringValueFromResource((Resource)resource);
            }
            outHash.v = DistinctHash.getHash(resource);
            return this.resultSet.add((UInt128)outHash.v);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to add value to distinct map", e);
        }
    }
}

