/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.query.DocumentProducer;
import com.azure.cosmos.implementation.query.DocumentQueryExecutionContextBase;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionComponent;
import com.azure.cosmos.implementation.query.TriFunction;
import com.azure.cosmos.implementation.query.ValueUnwrapCosmosItemSerializer;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedRange;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.SqlQuerySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class ParallelDocumentQueryExecutionContextBase<T>
extends DocumentQueryExecutionContextBase<T>
implements IDocumentQueryExecutionComponent<T> {
    protected List<DocumentProducer<T>> documentProducers;
    protected final SqlQuerySpec querySpec;
    protected int top = -1;
    private final CosmosItemSerializer itemSerializer;

    protected ParallelDocumentQueryExecutionContextBase(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, CosmosQueryRequestOptions cosmosQueryRequestOptions, String resourceLink, String rewrittenQuery, UUID correlatedActivityId, boolean shouldUnwrapSelectValue, AtomicBoolean isQueryCancelledOnTimeout) {
        super(diagnosticsClientContext, client, resourceTypeEnum, resourceType, query, cosmosQueryRequestOptions, resourceLink, correlatedActivityId, isQueryCancelledOnTimeout);
        CosmosItemSerializer candidateSerializer = client.getEffectiveItemSerializer(this.cosmosQueryRequestOptions);
        this.itemSerializer = candidateSerializer != CosmosItemSerializer.DEFAULT_SERIALIZER ? candidateSerializer : ValueUnwrapCosmosItemSerializer.create(shouldUnwrapSelectValue);
        this.documentProducers = new ArrayList<DocumentProducer<T>>();
        this.querySpec = !Strings.isNullOrEmpty(rewrittenQuery) ? new SqlQuerySpec(rewrittenQuery, this.query.getParameters()) : this.query;
    }

    protected void initialize(DocumentCollection collection, Map<FeedRangeEpkImpl, String> feedRangeToContinuationTokenMap, int initialPageSize, SqlQuerySpec querySpecForInit) {
        Map<String, String> commonRequestHeaders = this.createCommonHeadersAsync(this.getFeedOptions(null, null));
        for (Map.Entry<FeedRangeEpkImpl, String> entry : feedRangeToContinuationTokenMap.entrySet()) {
            TriFunction<FeedRangeEpkImpl, String, Integer, RxDocumentServiceRequest> createRequestFunc = (feedRange, continuationToken, pageSize) -> {
                HashMap<String, String> headers = new HashMap<String, String>(commonRequestHeaders);
                headers.put("x-ms-continuation", (String)continuationToken);
                headers.put("x-ms-max-item-count", Strings.toString(pageSize));
                headers.put("x-ms-cosmos-correlated-activityid", this.correlatedActivityId.toString());
                PartitionKeyInternal partitionKeyInternal = null;
                if (this.cosmosQueryRequestOptions.getPartitionKey() != null && this.cosmosQueryRequestOptions.getPartitionKey() != PartitionKey.NONE && !PartitionKeyInternal.isPartialPartitionKeyQuery(collection, this.cosmosQueryRequestOptions.getPartitionKey())) {
                    partitionKeyInternal = BridgeInternal.getPartitionKeyInternal(this.cosmosQueryRequestOptions.getPartitionKey());
                    headers.put("x-ms-documentdb-partitionkey", partitionKeyInternal.toJson());
                }
                ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().setPartitionKeyDefinition(this.cosmosQueryRequestOptions, collection.getPartitionKey());
                ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().setCollectionRid(this.cosmosQueryRequestOptions, collection.getResourceId());
                return this.createDocumentServiceRequestWithFeedRange((Map<String, String>)headers, querySpecForInit, partitionKeyInternal, (FeedRange)feedRange, collection.getResourceId(), this.cosmosQueryRequestOptions.getThroughputControlGroupName());
            };
            Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeFunc = request -> this.executeRequestAsync(this.itemSerializer, (RxDocumentServiceRequest)request);
            FeedRangeEpkImpl targetRange = entry.getKey();
            String continuationToken2 = entry.getValue();
            DocumentProducer<T> dp = this.createDocumentProducer(collection.getResourceId(), continuationToken2, initialPageSize, this.cosmosQueryRequestOptions, querySpecForInit, commonRequestHeaders, createRequestFunc, executeFunc, () -> this.client.getResetSessionTokenRetryPolicy().getRequestPolicy(this.diagnosticsClientContext), targetRange, collection.getSelfLink());
            this.documentProducers.add(dp);
        }
    }

    protected abstract DocumentProducer<T> createDocumentProducer(String var1, String var2, int var3, CosmosQueryRequestOptions var4, SqlQuerySpec var5, Map<String, String> var6, TriFunction<FeedRangeEpkImpl, String, Integer, RxDocumentServiceRequest> var7, Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> var8, Supplier<DocumentClientRetryPolicy> var9, FeedRangeEpkImpl var10, String var11);

    @Override
    public abstract Flux<FeedResponse<T>> drainAsync(int var1);

    public void setTop(int newTop) {
        this.top = newTop;
        for (DocumentProducer<T> producer : this.documentProducers) {
            producer.top = newTop;
        }
    }

    protected void initializeReadMany(Map<PartitionKeyRange, SqlQuerySpec> rangeQueryMap, CosmosQueryRequestOptions cosmosQueryRequestOptions, DocumentCollection collection) {
        Map<String, String> commonRequestHeaders = this.createCommonHeadersAsync(this.getFeedOptions(null, null));
        for (Map.Entry<PartitionKeyRange, SqlQuerySpec> entry : rangeQueryMap.entrySet()) {
            PartitionKeyRange targetRange = entry.getKey();
            FeedRangeEpkImpl feedRangeEpk = new FeedRangeEpkImpl(targetRange.toRange());
            SqlQuerySpec querySpec = entry.getValue();
            TriFunction<FeedRangeEpkImpl, String, Integer, RxDocumentServiceRequest> createRequestFunc = (partitionKeyRange, continuationToken, pageSize) -> {
                HashMap<String, String> headers = new HashMap<String, String>(commonRequestHeaders);
                headers.put("x-ms-continuation", (String)continuationToken);
                headers.put("x-ms-max-item-count", Strings.toString(pageSize));
                ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().setPartitionKeyDefinition(cosmosQueryRequestOptions, collection.getPartitionKey());
                ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().setCollectionRid(cosmosQueryRequestOptions, collection.getResourceId());
                return this.createDocumentServiceRequestWithFeedRange((Map<String, String>)headers, querySpec, null, (FeedRange)partitionKeyRange, collection.getResourceId(), cosmosQueryRequestOptions.getThroughputControlGroupName());
            };
            Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeFunc = request -> this.executeRequestAsync(this.itemSerializer, (RxDocumentServiceRequest)request);
            DocumentProducer<T> dp = this.createDocumentProducer(collection.getResourceId(), null, -1, cosmosQueryRequestOptions, querySpec, commonRequestHeaders, createRequestFunc, executeFunc, () -> this.client.getResetSessionTokenRetryPolicy().getRequestPolicy(this.diagnosticsClientContext), feedRangeEpk, collection.getSelfLink());
            this.documentProducers.add(dp);
        }
    }
}

