/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.ObjectNodeMap;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.Utils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;

public class Document
extends Resource {
    private static final ObjectMapper OBJECT_MAPPER = Utils.getSimpleObjectMapper();
    private static final ImplementationBridgeHelpers.CosmosItemSerializerHelper.CosmosItemSerializerAccessor itemSerializerAccessor = ImplementationBridgeHelpers.CosmosItemSerializerHelper.getCosmosItemSerializerAccessor();

    public Document(ObjectNode objectNode) {
        super(objectNode);
    }

    public Document(byte[] content) {
        super(content);
    }

    public Document() {
    }

    @Override
    public Document setId(String id) {
        super.setId(id);
        return this;
    }

    public Document(String jsonString) {
        super(jsonString);
    }

    public static Document fromObject(Object document, CosmosItemSerializer itemSerializer) {
        if (!(document instanceof Document)) {
            Map<String, Object> jsonTreeMap = itemSerializerAccessor.serializeSafe(itemSerializer, document);
            ObjectNode objectNode = null;
            objectNode = jsonTreeMap instanceof ObjectNodeMap ? ((ObjectNodeMap)jsonTreeMap).getObjectNode() : (ObjectNode)OBJECT_MAPPER.convertValue(jsonTreeMap, ObjectNode.class);
            return new Document(objectNode);
        }
        Document typedDocument = (Document)document;
        return typedDocument;
    }

    public Integer getTimeToLive() {
        if (super.has("ttl")) {
            return super.getInt("ttl");
        }
        return null;
    }

    public void setTimeToLive(Integer timeToLive) {
        if (timeToLive != null) {
            this.set("ttl", timeToLive);
        } else if (super.has("ttl")) {
            this.remove("ttl");
        }
    }

    @Override
    public String toJson() {
        return super.toJson();
    }

    @Override
    public String getString(String propertyName) {
        return super.getString(propertyName);
    }

    @Override
    public Integer getInt(String propertyName) {
        return super.getInt(propertyName);
    }

    @Override
    public Object get(String propertyName) {
        return super.get(propertyName);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

