/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosBridgeInternal;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.RxDocumentClientImpl;
import com.azure.cosmos.implementation.caches.AsyncCache;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class CosmosClientMetadataCachesSnapshot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int ERROR_CODE = 0;
    public byte[] collectionInfoByNameCache;
    public byte[] collectionInfoByIdCache;

    public void serialize(CosmosAsyncClient client) {
        RxDocumentClientImpl documentClient = (RxDocumentClientImpl)CosmosBridgeInternal.getAsyncDocumentClient(client);
        documentClient.serialize(this);
    }

    public void serializeCollectionInfoByNameCache(AsyncCache<String, DocumentCollection> cache) {
        this.collectionInfoByNameCache = this.serializeAsyncCollectionCache(cache);
    }

    public void serializeCollectionInfoByIdCache(AsyncCache<String, DocumentCollection> cache) {
        this.collectionInfoByIdCache = this.serializeAsyncCollectionCache(cache);
    }

    private byte[] serializeAsyncCollectionCache(AsyncCache<String, DocumentCollection> cache) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(baos);
            objectOutputStream.writeObject(AsyncCache.SerializableAsyncCache.from(cache, String.class, DocumentCollection.class));
            objectOutputStream.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw CosmosBridgeInternal.cosmosException(0, e);
        }
    }

    public AsyncCache<String, DocumentCollection> getCollectionInfoByNameCache() {
        try {
            return ((AsyncCache.SerializableAsyncCache.SerializableAsyncCollectionCache)new ObjectInputStream(new ByteArrayInputStream(this.collectionInfoByNameCache)).readObject()).toAsyncCache();
        }
        catch (IOException | ClassNotFoundException e) {
            throw CosmosBridgeInternal.cosmosException(0, e);
        }
    }

    public AsyncCache<String, DocumentCollection> getCollectionInfoByIdCache() {
        try {
            return ((AsyncCache.SerializableAsyncCache.SerializableAsyncCollectionCache)new ObjectInputStream(new ByteArrayInputStream(this.collectionInfoByIdCache)).readObject()).toAsyncCache();
        }
        catch (IOException | ClassNotFoundException e) {
            throw CosmosBridgeInternal.cosmosException(0, e);
        }
    }
}

