/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.ReadConsistencyStrategy;
import com.azure.cosmos.implementation.AvailabilityStrategyContext;
import com.azure.cosmos.implementation.CrossRegionAvailabilityContextForRxDocumentServiceRequest;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.FeedOperationContextForCircuitBreaker;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.PartitionKeyRangeWrapper;
import com.azure.cosmos.implementation.RequestVerb;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentClientImpl;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.RxDocumentServiceResponse;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedState;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedStateV1;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.perPartitionAutomaticFailover.GlobalPartitionEndpointManagerForPerPartitionAutomaticFailover;
import com.azure.cosmos.implementation.perPartitionCircuitBreaker.GlobalPartitionEndpointManagerForPerPartitionCircuitBreaker;
import com.azure.cosmos.implementation.query.Paginator;
import com.azure.cosmos.implementation.routing.CollectionRoutingMap;
import com.azure.cosmos.implementation.spark.OperationContext;
import com.azure.cosmos.implementation.spark.OperationContextAndListenerTuple;
import com.azure.cosmos.implementation.spark.OperationListener;
import com.azure.cosmos.models.CosmosChangeFeedRequestOptions;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ChangeFeedQueryImpl<T> {
    private static final ImplementationBridgeHelpers.FeedResponseHelper.FeedResponseAccessor feedResponseAccessor = ImplementationBridgeHelpers.FeedResponseHelper.getFeedResponseAccessor();
    private static final ImplementationBridgeHelpers.CosmosChangeFeedRequestOptionsHelper.CosmosChangeFeedRequestOptionsAccessor changeFeedRequestOptionsAccessor = ImplementationBridgeHelpers.CosmosChangeFeedRequestOptionsHelper.getCosmosChangeFeedRequestOptionsAccessor();
    private static final int INITIAL_TOP_VALUE = -1;
    private final RxDocumentClientImpl client;
    private final DiagnosticsClientContext clientContext;
    private final Supplier<RxDocumentServiceRequest> createRequestFunc;
    private final String documentsLink;
    private final String collectionLink;
    private final Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeFunc;
    private final Class<T> klass;
    private final CosmosChangeFeedRequestOptions options;
    private final ResourceType resourceType;
    private final ChangeFeedState changeFeedState;
    private final OperationContextAndListenerTuple operationContextAndListener;
    private final CosmosItemSerializer itemSerializer;

    public ChangeFeedQueryImpl(RxDocumentClientImpl client, ResourceType resourceType, Class<T> klass, String collectionLink, String collectionRid, CosmosChangeFeedRequestOptions requestOptions) {
        Preconditions.checkNotNull(client, "Argument 'client' must not be null.");
        Preconditions.checkNotNull(resourceType, "Argument 'resourceType' must not be null.");
        Preconditions.checkNotNull(klass, "Argument 'klass' must not be null.");
        Preconditions.checkNotNull(requestOptions, "Argument 'requestOptions' must not be null.");
        Preconditions.checkNotNull(collectionLink, "Argument 'collectionLink' must not be null.");
        Preconditions.checkNotNull(collectionRid, "Argument 'collectionRid' must not be null.");
        if (Strings.isNullOrWhiteSpace(collectionLink)) {
            throw new IllegalArgumentException("Argument 'collectionLink' must not be empty");
        }
        if (Strings.isNullOrWhiteSpace(collectionRid)) {
            throw new IllegalArgumentException("Argument 'collectionRid' must not be empty");
        }
        this.createRequestFunc = this::createDocumentServiceRequest;
        this.executeFunc = this::executeRequestAsync;
        this.clientContext = client;
        this.client = client;
        this.resourceType = resourceType;
        this.klass = klass;
        this.collectionLink = collectionLink;
        this.documentsLink = Utils.joinPath(collectionLink, "docs");
        this.options = requestOptions;
        this.itemSerializer = client.getEffectiveItemSerializer(requestOptions.getCustomItemSerializer());
        this.operationContextAndListener = ImplementationBridgeHelpers.CosmosChangeFeedRequestOptionsHelper.getCosmosChangeFeedRequestOptionsAccessor().getOperationContext(this.options);
        FeedRangeInternal feedRange = (FeedRangeInternal)this.options.getFeedRange();
        ChangeFeedState state = ModelBridgeInternal.getChangeFeedContinuationState(requestOptions);
        if (state == null) {
            state = new ChangeFeedStateV1(collectionRid, feedRange, ModelBridgeInternal.getChangeFeedMode(requestOptions), ModelBridgeInternal.getChangeFeedStartFromSettings(requestOptions), null);
        }
        this.changeFeedState = state;
    }

    public Flux<FeedResponse<T>> executeAsync() {
        return Paginator.getChangeFeedQueryResultAsObservable(this.client, this.changeFeedState, ModelBridgeInternal.getPropertiesFromChangeFeedRequestOptions(this.options), this.createRequestFunc, this.executeFunc, -1, this.options.getMaxItemCount(), this.options.getMaxPrefetchPageCount(), ModelBridgeInternal.getChangeFeedIsSplitHandlingDisabled(this.options), this.options.isCompleteAfterAllCurrentChangesRetrieved(), ImplementationBridgeHelpers.CosmosChangeFeedRequestOptionsHelper.getCosmosChangeFeedRequestOptionsAccessor().getEndLSN(this.options), ImplementationBridgeHelpers.CosmosChangeFeedRequestOptionsHelper.getCosmosChangeFeedRequestOptionsAccessor().getOperationContext(this.options));
    }

    private RxDocumentServiceRequest createDocumentServiceRequest() {
        String readConsistencyStrategyName;
        HashMap<String, String> headers = new HashMap<String, String>();
        Map<String, String> customOptions = ImplementationBridgeHelpers.CosmosChangeFeedRequestOptionsHelper.getCosmosChangeFeedRequestOptionsAccessor().getHeader(this.options);
        if (customOptions != null) {
            headers.putAll(customOptions);
        }
        if (this.options.isQuotaInfoEnabled()) {
            headers.put("x-ms-documentdb-populatequotainfo", String.valueOf(true));
        }
        boolean consistencyLevelOverrideApplicable = true;
        if (this.options.getReadConsistencyStrategy() != null) {
            readConsistencyStrategyName = this.options.getReadConsistencyStrategy().toString();
            this.client.validateAndLogNonDefaultReadConsistencyStrategy(readConsistencyStrategyName);
            headers.put("x-ms-cosmos-read-consistency-strategy", readConsistencyStrategyName);
            boolean bl = consistencyLevelOverrideApplicable = this.options.getReadConsistencyStrategy() == ReadConsistencyStrategy.DEFAULT;
        }
        if (consistencyLevelOverrideApplicable && this.client.getReadConsistencyStrategy() != null) {
            readConsistencyStrategyName = this.client.getReadConsistencyStrategy().toString();
            this.client.validateAndLogNonDefaultReadConsistencyStrategy(readConsistencyStrategyName);
            headers.put("x-ms-cosmos-read-consistency-strategy", readConsistencyStrategyName);
            boolean bl = consistencyLevelOverrideApplicable = this.client.getReadConsistencyStrategy() == ReadConsistencyStrategy.DEFAULT;
        }
        if (consistencyLevelOverrideApplicable && this.client.getConsistencyLevel() != null) {
            headers.put("x-ms-consistency-level", this.client.getConsistencyLevel().toString());
        }
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(this.clientContext, OperationType.ReadFeed, this.resourceType, this.documentsLink, headers, this.options);
        if (request.requestContext != null) {
            request.requestContext.setExcludeRegions(this.options.getExcludedRegions());
            request.requestContext.setKeywordIdentifiers(this.options.getKeywordIdentifiers());
            request.requestContext.setCrossRegionAvailabilityContext(new CrossRegionAvailabilityContextForRxDocumentServiceRequest(new FeedOperationContextForCircuitBreaker(new ConcurrentHashMap<PartitionKeyRangeWrapper, PartitionKeyRangeWrapper>(), false, this.collectionLink), null, new AvailabilityStrategyContext(false, false)));
        }
        return request;
    }

    private Mono<FeedResponse<T>> executeRequestAsync(RxDocumentServiceRequest request) {
        if (this.operationContextAndListener == null) {
            return this.handlePerPartitionFailoverPrerequisites(request).flatMap(this.client::readFeed).map(rsp -> feedResponseAccessor.createChangeFeedResponse((RxDocumentServiceResponse)rsp, this.itemSerializer, this.klass, rsp.getCosmosDiagnostics()));
        }
        OperationListener listener = this.operationContextAndListener.getOperationListener();
        OperationContext operationContext = this.operationContextAndListener.getOperationContext();
        request.getHeaders().put("x-ms-cosmos-correlated-activityid", operationContext.getCorrelationActivityId());
        listener.requestListener(operationContext, request);
        return this.handlePerPartitionFailoverPrerequisites(request).flatMap(this.client::readFeed).map(rsp -> {
            listener.responseListener(operationContext, (RxDocumentServiceResponse)rsp);
            FeedResponse<T> feedResponse = feedResponseAccessor.createChangeFeedResponse((RxDocumentServiceResponse)rsp, this.itemSerializer, this.klass, rsp.getCosmosDiagnostics());
            Map<String, String> rspHeaders = feedResponse.getResponseHeaders();
            String requestPkRangeId = null;
            if (!rspHeaders.containsKey("x-ms-documentdb-partitionkeyrangeid") && (requestPkRangeId = request.getHeaders().get("x-ms-documentdb-partitionkeyrangeid")) != null) {
                rspHeaders.put("x-ms-documentdb-partitionkeyrangeid", requestPkRangeId);
            }
            listener.feedResponseReceivedListener(operationContext, feedResponse);
            return feedResponse;
        }).doOnError(ex -> listener.exceptionListener(operationContext, (Throwable)ex));
    }

    private Mono<RxDocumentServiceRequest> handlePerPartitionFailoverPrerequisites(RxDocumentServiceRequest request) {
        GlobalPartitionEndpointManagerForPerPartitionCircuitBreaker globalPartitionEndpointManagerForPerPartitionCircuitBreaker = this.client.getGlobalPartitionEndpointManagerForCircuitBreaker();
        GlobalPartitionEndpointManagerForPerPartitionAutomaticFailover globalPartitionEndpointManagerForPerPartitionAutomaticFailover = this.client.getGlobalPartitionEndpointManagerForPerPartitionAutomaticFailover();
        Preconditions.checkNotNull(globalPartitionEndpointManagerForPerPartitionCircuitBreaker, "Argument 'globalPartitionEndpointManagerForPerPartitionCircuitBreaker' must not be null!");
        if (globalPartitionEndpointManagerForPerPartitionCircuitBreaker.isPerPartitionLevelCircuitBreakingApplicable(request) || globalPartitionEndpointManagerForPerPartitionAutomaticFailover.isPerPartitionAutomaticFailoverApplicable(request)) {
            return Mono.just((Object)request).flatMap(req -> this.client.populateHeadersAsync((RxDocumentServiceRequest)req, RequestVerb.GET)).flatMap(req -> this.client.getCollectionCache().resolveCollectionAsync(null, (RxDocumentServiceRequest)req).flatMap(documentCollectionValueHolder -> {
                Preconditions.checkNotNull(documentCollectionValueHolder, "Argument 'documentCollectionValueHolder' cannot be null!");
                Preconditions.checkNotNull((DocumentCollection)documentCollectionValueHolder.v, "Argument 'documentCollectionValueHolder.v' cannot be null!");
                return this.client.getPartitionKeyRangeCache().tryLookupAsync(null, ((DocumentCollection)documentCollectionValueHolder.v).getResourceId(), null, null).flatMap(collectionRoutingMapValueHolder -> {
                    Preconditions.checkNotNull(collectionRoutingMapValueHolder, "Argument 'collectionRoutingMapValueHolder' cannot be null!");
                    Preconditions.checkNotNull((CollectionRoutingMap)collectionRoutingMapValueHolder.v, "Argument 'collectionRoutingMapValueHolder.v' cannot be null!");
                    changeFeedRequestOptionsAccessor.setPartitionKeyDefinition(this.options, ((DocumentCollection)documentCollectionValueHolder.v).getPartitionKey());
                    changeFeedRequestOptionsAccessor.setCollectionRid(this.options, ((DocumentCollection)documentCollectionValueHolder.v).getResourceId());
                    PartitionKeyRange preResolvedPartitionKeyRangeIfAny = this.client.setPartitionKeyRangeForChangeFeedOperationRequestForPerPartitionAutomaticFailover((RxDocumentServiceRequest)req, this.options, (CollectionRoutingMap)collectionRoutingMapValueHolder.v, null);
                    this.client.addPartitionLevelUnavailableRegionsForChangeFeedOperationRequestForPerPartitionCircuitBreaker((RxDocumentServiceRequest)req, this.options, (CollectionRoutingMap)collectionRoutingMapValueHolder.v, preResolvedPartitionKeyRangeIfAny);
                    if (req.requestContext.getClientRetryPolicySupplier() != null) {
                        DocumentClientRetryPolicy documentClientRetryPolicy = req.requestContext.getClientRetryPolicySupplier().get();
                        documentClientRetryPolicy.onBeforeSendRequest((RxDocumentServiceRequest)req);
                    }
                    return Mono.just((Object)req);
                });
            }));
        }
        return Mono.just((Object)request);
    }
}

