/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncTrigger;
import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.models.CosmosTriggerProperties;
import com.azure.cosmos.models.CosmosTriggerResponse;

public class CosmosTrigger {
    private final String id;
    private final CosmosContainer container;
    private final CosmosAsyncTrigger trigger;

    CosmosTrigger(String id, CosmosContainer container, CosmosAsyncTrigger trigger) {
        this.id = id;
        this.container = container;
        this.trigger = trigger;
    }

    public String getId() {
        return this.id;
    }

    public CosmosTriggerResponse read() {
        return this.container.getScripts().blockTriggerResponse(this.trigger.read());
    }

    public CosmosTriggerResponse replace(CosmosTriggerProperties triggerProperties) {
        return this.container.getScripts().blockTriggerResponse(this.trigger.replace(triggerProperties));
    }

    public CosmosTriggerResponse delete() {
        return this.container.getScripts().blockTriggerResponse(this.trigger.delete());
    }
}

