/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.ClientSideRequestStatistics;
import com.azure.cosmos.implementation.CosmosDiagnosticsSystemUsageSnapshot;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.clienttelemetry.ClientTelemetry;
import com.azure.cosmos.implementation.cpu.CpuMemoryMonitor;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdContext;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdEndpoint;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdHealthCheckRequest;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdObjectMapper;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdReporter;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestManager;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.netty.channel.Channel;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RntbdClientChannelHealthChecker
implements ChannelHealthChecker {
    private static final Logger logger = LoggerFactory.getLogger(RntbdClientChannelHealthChecker.class);
    private final ClientTelemetry clientTelemetry;
    private static final long recentReadWindowInNanos = 1000000000L;
    private static final long readHangGracePeriodInNanos = 55000000000L;
    private static final long writeHangGracePeriodInNanos = 2000000000L;
    @JsonProperty
    private final long idleConnectionTimeoutInNanos;
    @JsonProperty
    private final long readDelayLimitInNanos;
    @JsonProperty
    private final long writeDelayLimitInNanos;
    @JsonProperty
    private final boolean timeoutDetectionEnabled;
    @JsonProperty
    private final double timeoutDetectionDisableCPUThreshold;
    @JsonProperty
    private final long timeoutTimeLimitInNanos;
    @JsonProperty
    private final int timeoutHighFrequencyThreshold;
    @JsonProperty
    private final long timeoutHighFrequencyTimeLimitInNanos;
    @JsonProperty
    private final int timeoutOnWriteThreshold;
    @JsonProperty
    private final long timeoutOnWriteTimeLimitInNanos;
    @JsonProperty
    private final long nonRespondingChannelReadDelayTimeLimitInNanos;
    @JsonProperty
    private final int cancellationCountSinceLastReadThreshold;

    public RntbdClientChannelHealthChecker(RntbdEndpoint.Config config, ClientTelemetry clientTelemetry) {
        Preconditions.checkNotNull(config, "expected non-null config");
        Preconditions.checkArgument(config.receiveHangDetectionTimeInNanos() > 55000000000L, "config.receiveHangDetectionTimeInNanos: %s", config.receiveHangDetectionTimeInNanos());
        Preconditions.checkArgument(config.sendHangDetectionTimeInNanos() > 2000000000L, "config.sendHangDetectionTimeInNanos: %s", config.sendHangDetectionTimeInNanos());
        this.idleConnectionTimeoutInNanos = config.idleConnectionTimeoutInNanos();
        this.readDelayLimitInNanos = config.receiveHangDetectionTimeInNanos();
        this.writeDelayLimitInNanos = config.sendHangDetectionTimeInNanos();
        this.timeoutDetectionEnabled = config.timeoutDetectionEnabled();
        this.timeoutDetectionDisableCPUThreshold = config.timeoutDetectionDisableCPUThreshold();
        this.timeoutTimeLimitInNanos = config.timeoutDetectionTimeLimitInNanos();
        this.timeoutHighFrequencyThreshold = config.timeoutDetectionHighFrequencyThreshold();
        this.timeoutHighFrequencyTimeLimitInNanos = config.timeoutDetectionHighFrequencyTimeLimitInNanos();
        this.timeoutOnWriteThreshold = config.timeoutDetectionOnWriteThreshold();
        this.timeoutOnWriteTimeLimitInNanos = config.timeoutDetectionOnWriteTimeLimitInNanos();
        this.nonRespondingChannelReadDelayTimeLimitInNanos = config.nonRespondingChannelReadDelayTimeLimitInNanos();
        this.cancellationCountSinceLastReadThreshold = config.cancellationCountSinceLastReadThreshold();
        this.clientTelemetry = clientTelemetry;
    }

    public long idleConnectionTimeoutInNanos() {
        return this.idleConnectionTimeoutInNanos;
    }

    public long readDelayLimitInNanos() {
        return this.readDelayLimitInNanos;
    }

    public long writeDelayLimitInNanos() {
        return this.writeDelayLimitInNanos;
    }

    public Future<Boolean> isHealthy(Channel channel) {
        Preconditions.checkNotNull(channel, "expected non-null channel");
        Promise promise = channel.eventLoop().newPromise();
        this.isHealthyWithFailureReason(channel).addListener(future -> {
            if (future.isSuccess()) {
                if ("Success".equals(future.get())) {
                    promise.setSuccess((Object)Boolean.TRUE);
                } else {
                    promise.setSuccess((Object)Boolean.FALSE);
                }
            } else {
                promise.setFailure(future.cause());
            }
        });
        return promise;
    }

    public Future<String> isHealthyWithFailureReason(Channel channel) {
        Preconditions.checkNotNull(channel, "expected non-null channel");
        RntbdRequestManager requestManager = (RntbdRequestManager)channel.pipeline().get(RntbdRequestManager.class);
        Promise promise = channel.eventLoop().newPromise();
        if (requestManager == null) {
            RntbdReporter.reportIssueUnless(logger, !channel.isActive(), channel, "active with no request manager", new Object[0]);
            return promise.setSuccess((Object)"active with no request manager");
        }
        Timestamps timestamps = requestManager.snapshotTimestamps();
        Instant currentTime = Instant.now();
        if (Duration.between(timestamps.lastChannelReadTime(), currentTime).toNanos() < 1000000000L) {
            return promise.setSuccess((Object)"Success");
        }
        String writeIsHangMessage = this.isWriteHang(timestamps, currentTime, requestManager, channel);
        if (StringUtils.isNotEmpty(writeIsHangMessage)) {
            return promise.setSuccess((Object)writeIsHangMessage);
        }
        String readIsHangMessage = this.isReadHang(timestamps, currentTime, requestManager, channel);
        if (StringUtils.isNotEmpty(readIsHangMessage)) {
            return promise.setSuccess((Object)readIsHangMessage);
        }
        String transitTimeoutValidationMessage = this.transitTimeoutValidation(timestamps, currentTime, requestManager, channel);
        if (StringUtils.isNotEmpty(transitTimeoutValidationMessage)) {
            return promise.setSuccess((Object)transitTimeoutValidationMessage);
        }
        String idleConnectionValidationMessage = this.idleConnectionValidation(timestamps, currentTime, channel);
        if (StringUtils.isNotEmpty(idleConnectionValidationMessage)) {
            return promise.setSuccess((Object)idleConnectionValidationMessage);
        }
        String isCancellationProneChannelMessage = this.isCancellationProneChannel(timestamps, currentTime, requestManager, channel);
        if (StringUtils.isNotEmpty(isCancellationProneChannelMessage)) {
            return promise.setSuccess((Object)isCancellationProneChannelMessage);
        }
        channel.writeAndFlush((Object)RntbdHealthCheckRequest.MESSAGE).addListener(completed -> {
            if (completed.isSuccess()) {
                promise.setSuccess((Object)"Success");
            } else {
                String msg = MessageFormat.format("{0} health check request failed due to: {1}", channel, completed.cause().toString());
                logger.warn(msg);
                promise.setSuccess((Object)msg);
            }
        });
        return promise;
    }

    private String isWriteHang(Timestamps timestamps, Instant currentTime, RntbdRequestManager requestManager, Channel channel) {
        long writeDelayInNanos = Duration.between(timestamps.lastChannelWriteTime(), timestamps.lastChannelWriteAttemptTime()).toNanos();
        long writeHangDurationInNanos = Duration.between(timestamps.lastChannelWriteAttemptTime(), currentTime).toNanos();
        String writeHangMessage = "";
        if (writeDelayInNanos > this.writeDelayLimitInNanos && writeHangDurationInNanos > 2000000000L) {
            Optional<RntbdContext> rntbdContext = requestManager.rntbdContext();
            int pendingRequestCount = requestManager.pendingRequestCount();
            CosmosDiagnosticsSystemUsageSnapshot systemInfo = ClientSideRequestStatistics.fetchSystemInformation();
            writeHangMessage = MessageFormat.format("{0} health check failed due to non-responding write: [lastChannelWriteAttemptTime: {1}, lastChannelWriteTime: {2}, writeDelayInNanos: {3}, writeDelayLimitInNanos: {4}, rntbdContext: {5}, pendingRequestCount: {6}, clientVmId: {7}, {8}]", channel, timestamps.lastChannelWriteAttemptTime(), timestamps.lastChannelWriteTime(), writeDelayInNanos, this.writeDelayLimitInNanos, rntbdContext, pendingRequestCount, this.clientTelemetry.getClientTelemetryInfo().getMachineId(), this.getSystemDiagnostics());
            logger.warn(writeHangMessage);
        }
        return writeHangMessage;
    }

    private String isReadHang(Timestamps timestamps, Instant currentTime, RntbdRequestManager requestManager, Channel channel) {
        long readDelay = Duration.between(timestamps.lastChannelReadTime(), timestamps.lastChannelWriteTime()).toNanos();
        long readHangDuration = Duration.between(timestamps.lastChannelWriteTime(), currentTime).toNanos();
        String readHangMessage = "";
        if (readDelay > this.readDelayLimitInNanos && readHangDuration > 55000000000L) {
            Optional<RntbdContext> rntbdContext = requestManager.rntbdContext();
            int pendingRequestCount = requestManager.pendingRequestCount();
            readHangMessage = MessageFormat.format("{0} health check failed due to non-responding read: [lastChannelWrite: {1}, lastChannelRead: {2}, readDelay: {3}, readDelayLimit: {4}, rntbdContext: {5}, pendingRequestCount: {6}, clientVmId: {7}, {8}]", channel, timestamps.lastChannelWriteTime(), timestamps.lastChannelReadTime(), readDelay, this.readDelayLimitInNanos, rntbdContext, pendingRequestCount, this.clientTelemetry.getClientTelemetryInfo().getMachineId(), this.getSystemDiagnostics());
            logger.warn(readHangMessage);
        }
        return readHangMessage;
    }

    private String transitTimeoutValidation(Timestamps timestamps, Instant currentTime, RntbdRequestManager requestManager, Channel channel) {
        String transitTimeoutValidationMessage = "";
        if (this.timeoutDetectionEnabled && timestamps.transitTimeoutCount() > 0) {
            if (CpuMemoryMonitor.getCpuLoad().isCpuOverThreshold(this.timeoutDetectionDisableCPUThreshold)) {
                timestamps.resetTransitTimeout();
                return transitTimeoutValidationMessage;
            }
            Optional<RntbdContext> rntbdContext = requestManager.rntbdContext();
            long readDelay = Duration.between(timestamps.lastChannelReadTime(), currentTime).toNanos();
            if (readDelay >= this.timeoutTimeLimitInNanos) {
                transitTimeoutValidationMessage = MessageFormat.format("{0} health check failed due to transit timeout detection time limit: [rntbdContext: {1},lastChannelRead: {2}, timeoutTimeLimitInNanos: {3}, clientVmId: {4}, {5}]", channel, rntbdContext, timestamps.lastReadTime, this.timeoutTimeLimitInNanos, this.clientTelemetry.getClientTelemetryInfo().getMachineId(), this.getSystemDiagnostics());
                logger.warn(transitTimeoutValidationMessage);
                return transitTimeoutValidationMessage;
            }
            if (timestamps.transitTimeoutCount() >= this.timeoutHighFrequencyThreshold && readDelay >= this.timeoutHighFrequencyTimeLimitInNanos) {
                transitTimeoutValidationMessage = MessageFormat.format("{0} health check failed due to transit timeout high frequency threshold hit: [rntbdContext: {1},lastChannelRead: {2}, transitTimeoutCount: {3}, timeoutHighFrequencyThreshold: {4}, timeoutHighFrequencyTimeLimitInNanos: {5}clientVmId: {6}, {7}]", channel, rntbdContext, timestamps.lastReadTime, timestamps.transitTimeoutCount, this.timeoutHighFrequencyThreshold, this.timeoutHighFrequencyTimeLimitInNanos, this.clientTelemetry.getClientTelemetryInfo().getMachineId(), this.getSystemDiagnostics());
                logger.warn(transitTimeoutValidationMessage);
                return transitTimeoutValidationMessage;
            }
            if (timestamps.tansitTimeoutWriteCount() >= this.timeoutOnWriteThreshold && readDelay >= this.timeoutOnWriteTimeLimitInNanos) {
                transitTimeoutValidationMessage = MessageFormat.format("{0} health check failed due to transit timeout on write threshold hit: [rntbdContext: {1},lastChannelRead: {2}, transitTimeoutWriteCount: {3}, timeoutOnWriteThreshold: {4}, timeoutOnWriteTimeLimitInNanos: {5}]clientVmId: {6}, {7}]", channel, rntbdContext, timestamps.lastReadTime, timestamps.transitTimeoutWriteCount, this.timeoutOnWriteThreshold, this.timeoutOnWriteTimeLimitInNanos, this.clientTelemetry.getClientTelemetryInfo().getMachineId(), this.getSystemDiagnostics());
                logger.warn(transitTimeoutValidationMessage);
                return transitTimeoutValidationMessage;
            }
        }
        return transitTimeoutValidationMessage;
    }

    private String idleConnectionValidation(Timestamps timestamps, Instant currentTime, Channel channel) {
        String errorMessage = "";
        if (this.idleConnectionTimeoutInNanos > 0L && Duration.between(timestamps.lastChannelReadTime(), currentTime).toNanos() > this.idleConnectionTimeoutInNanos) {
            errorMessage = MessageFormat.format("{0} health check failed due to idle connection timeout: [lastChannelWrite: {1}, lastChannelRead: {2}, idleConnectionTimeout: {3}, currentTime: {4}, clientVmId: {5}, {6}]", channel, timestamps.lastChannelWriteTime(), timestamps.lastChannelReadTime(), this.idleConnectionTimeoutInNanos, currentTime, this.clientTelemetry.getClientTelemetryInfo().getMachineId(), this.getSystemDiagnostics());
            logger.warn(errorMessage);
        }
        return errorMessage;
    }

    private String isCancellationProneChannel(Timestamps timestamps, Instant currentTime, RntbdRequestManager requestManager, Channel channel) {
        String errorMessage = "";
        if (timestamps.cancellationCount() >= this.cancellationCountSinceLastReadThreshold) {
            if (CpuMemoryMonitor.getCpuLoad().isCpuOverThreshold(this.timeoutDetectionDisableCPUThreshold)) {
                timestamps.resetCancellationCount();
                return errorMessage;
            }
            long readSuccessRecency = Duration.between(timestamps.lastChannelReadTime(), currentTime).toNanos();
            if (readSuccessRecency >= this.nonRespondingChannelReadDelayTimeLimitInNanos) {
                Optional<RntbdContext> rntbdContext = requestManager.rntbdContext();
                errorMessage = MessageFormat.format("{0} health check failed due to channel being cancellation prone: [rntbdContext: {1}, lastChannelWrite: {2}, lastChannelRead: {3},cancellationCountSinceLastSuccessfulRead: {4}, currentTime: {5}, clientVmId: {6}, {7}]", channel, rntbdContext, timestamps.lastChannelWriteTime(), timestamps.lastChannelReadTime(), timestamps.cancellationCount(), currentTime, this.clientTelemetry.getClientTelemetryInfo().getMachineId(), this.getSystemDiagnostics());
                logger.warn(errorMessage);
                return errorMessage;
            }
        }
        return errorMessage;
    }

    private String getSystemDiagnostics() {
        CosmosDiagnosticsSystemUsageSnapshot systemInfo = ClientSideRequestStatistics.fetchSystemInformation();
        return MessageFormat.format("clientUsedMemory: {0}, clientAvailableMemory: {1}, clientSystemCpuLoad: {2}, clientAvailableProcessors: {3}", systemInfo.getUsedMemory(), systemInfo.getAvailableMemory(), systemInfo.getSystemCpuLoad(), systemInfo.getAvailableProcessors());
    }

    public String toString() {
        return RntbdObjectMapper.toString(this);
    }

    public static final class Timestamps {
        private static final AtomicReferenceFieldUpdater<Timestamps, Instant> lastPingUpdater = AtomicReferenceFieldUpdater.newUpdater(Timestamps.class, Instant.class, "lastPingTime");
        private static final AtomicReferenceFieldUpdater<Timestamps, Instant> lastReadUpdater = AtomicReferenceFieldUpdater.newUpdater(Timestamps.class, Instant.class, "lastReadTime");
        private static final AtomicReferenceFieldUpdater<Timestamps, Instant> lastWriteUpdater = AtomicReferenceFieldUpdater.newUpdater(Timestamps.class, Instant.class, "lastWriteTime");
        private static final AtomicReferenceFieldUpdater<Timestamps, Instant> lastWriteAttemptUpdater = AtomicReferenceFieldUpdater.newUpdater(Timestamps.class, Instant.class, "lastWriteAttemptTime");
        private static final AtomicIntegerFieldUpdater<Timestamps> transitTimeoutCountUpdater = AtomicIntegerFieldUpdater.newUpdater(Timestamps.class, "transitTimeoutCount");
        private static final AtomicIntegerFieldUpdater<Timestamps> transitTimeoutWriteCountUpdater = AtomicIntegerFieldUpdater.newUpdater(Timestamps.class, "transitTimeoutWriteCount");
        private static final AtomicReferenceFieldUpdater<Timestamps, Instant> transitTimeoutStartingTimeUpdater = AtomicReferenceFieldUpdater.newUpdater(Timestamps.class, Instant.class, "transitTimeoutStartingTime");
        private static final AtomicIntegerFieldUpdater<Timestamps> cancellationCountUpdater = AtomicIntegerFieldUpdater.newUpdater(Timestamps.class, "cancellationCount");
        private volatile Instant lastPingTime;
        private volatile Instant lastReadTime;
        private volatile Instant lastWriteTime;
        private volatile Instant lastWriteAttemptTime;
        private volatile int transitTimeoutCount;
        private volatile int transitTimeoutWriteCount;
        private volatile Instant transitTimeoutStartingTime;
        private volatile int cancellationCount;

        public Timestamps() {
            Instant nowSnapshot = Instant.now();
            lastPingUpdater.set(this, nowSnapshot);
            lastReadUpdater.set(this, nowSnapshot);
            lastWriteUpdater.set(this, nowSnapshot);
            lastWriteAttemptUpdater.set(this, nowSnapshot);
        }

        public Timestamps(Timestamps other) {
            Preconditions.checkNotNull(other, "other: null");
            this.lastPingTime = lastPingUpdater.get(other);
            this.lastReadTime = lastReadUpdater.get(other);
            this.lastWriteTime = lastWriteUpdater.get(other);
            this.lastWriteAttemptTime = lastWriteAttemptUpdater.get(other);
            this.transitTimeoutCount = transitTimeoutCountUpdater.get(other);
            this.transitTimeoutWriteCount = transitTimeoutWriteCountUpdater.get(other);
            this.transitTimeoutStartingTime = transitTimeoutStartingTimeUpdater.get(other);
            this.cancellationCount = cancellationCountUpdater.get(other);
        }

        public void channelPingCompleted() {
            lastPingUpdater.set(this, Instant.now());
        }

        public void channelReadCompleted() {
            lastReadUpdater.set(this, Instant.now());
            this.resetTransitTimeout();
            this.resetCancellationCount();
        }

        public void channelWriteAttempted() {
            lastWriteAttemptUpdater.set(this, Instant.now());
        }

        public void channelWriteCompleted() {
            lastWriteUpdater.set(this, Instant.now());
        }

        public void transitTimeout(boolean isReadOnly, Instant requestCreatedTime) {
            if (transitTimeoutCountUpdater.incrementAndGet(this) == 1) {
                transitTimeoutStartingTimeUpdater.set(this, requestCreatedTime);
            }
            if (!isReadOnly) {
                transitTimeoutWriteCountUpdater.incrementAndGet(this);
            }
        }

        public void resetTransitTimeout() {
            transitTimeoutCountUpdater.set(this, 0);
            transitTimeoutWriteCountUpdater.set(this, 0);
            transitTimeoutStartingTimeUpdater.set(this, null);
        }

        public void resetCancellationCount() {
            cancellationCountUpdater.set(this, 0);
        }

        @JsonProperty
        public Instant lastChannelPingTime() {
            return lastPingUpdater.get(this);
        }

        @JsonProperty
        public Instant lastChannelReadTime() {
            return lastReadUpdater.get(this);
        }

        @JsonProperty
        public Instant lastChannelWriteTime() {
            return lastWriteUpdater.get(this);
        }

        @JsonProperty
        public Instant lastChannelWriteAttemptTime() {
            return lastWriteAttemptUpdater.get(this);
        }

        @JsonProperty
        public int transitTimeoutCount() {
            return transitTimeoutCountUpdater.get(this);
        }

        @JsonProperty
        public int tansitTimeoutWriteCount() {
            return transitTimeoutWriteCountUpdater.get(this);
        }

        @JsonProperty
        public Instant transitTimeoutStartingTime() {
            return transitTimeoutStartingTimeUpdater.get(this);
        }

        @JsonProperty
        public int cancellationCount() {
            return cancellationCountUpdater.get(this);
        }

        @JsonProperty
        public void cancellation() {
            cancellationCountUpdater.incrementAndGet(this);
        }

        public String toString() {
            return RntbdObjectMapper.toString(this);
        }
    }
}

