/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.util;

import com.azure.cosmos.implementation.changefeed.common.ChangeFeedState;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedStateV1;
import com.azure.cosmos.implementation.feedranges.FeedRangeContinuation;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.query.CompositeContinuationToken;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.models.FeedRange;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class CosmosChangeFeedContinuationTokenUtils {
    private CosmosChangeFeedContinuationTokenUtils() {
    }

    public static Map<FeedRange, String> extractContinuationTokens(String changeFeedContinuationToken) {
        return CosmosChangeFeedContinuationTokenUtils.extractContinuationTokens(changeFeedContinuationToken, -1);
    }

    public static Map<FeedRange, String> extractContinuationTokens(String changeFeedContinuationToken, Integer targetedContinuationCount) {
        Preconditions.checkNotNull(changeFeedContinuationToken, "Argument 'changeFeedContinuationToken' cannot be null.");
        if (targetedContinuationCount == null) {
            targetedContinuationCount = -1;
        }
        ChangeFeedState changeFeedState = ChangeFeedState.fromString(changeFeedContinuationToken);
        List<CompositeContinuationToken> allTokens = changeFeedState.extractContinuationTokens();
        allTokens.sort(new Comparator<CompositeContinuationToken>(){

            @Override
            public int compare(CompositeContinuationToken o1, CompositeContinuationToken o2) {
                return o1.getRange().getMin().compareTo(o2.getRange().getMin());
            }
        });
        ConcurrentHashMap<FeedRange, String> extractedContinuationTokenMap = new ConcurrentHashMap<FeedRange, String>();
        int effectiveTargetedContinuationCount = targetedContinuationCount <= 0 ? allTokens.size() : Math.min(targetedContinuationCount, allTokens.size());
        List<List<CompositeContinuationToken>> segmentedTokens = CosmosChangeFeedContinuationTokenUtils.getSegmentedTokens(allTokens, effectiveTargetedContinuationCount);
        for (List<CompositeContinuationToken> segmentedToken : segmentedTokens) {
            FeedRangeEpkImpl effectiveChildRange = new FeedRangeEpkImpl(new Range<String>(segmentedToken.get(0).getRange().getMin(), segmentedToken.get(segmentedToken.size() - 1).getRange().getMax(), segmentedToken.get(0).getRange().isMinInclusive(), segmentedToken.get(segmentedToken.size() - 1).getRange().isMaxInclusive()));
            ChangeFeedStateV1 newChildFeedRangeState = new ChangeFeedStateV1(changeFeedState.getContainerRid(), effectiveChildRange, changeFeedState.getMode(), changeFeedState.getStartFromSettings(), FeedRangeContinuation.create(changeFeedState.getContainerRid(), (FeedRangeInternal)effectiveChildRange, segmentedToken));
            extractedContinuationTokenMap.put(effectiveChildRange, newChildFeedRangeState.toString());
        }
        return extractedContinuationTokenMap;
    }

    private static List<List<CompositeContinuationToken>> getSegmentedTokens(List<CompositeContinuationToken> allTokens, int targetedContinuationCount) {
        ArrayList<List<CompositeContinuationToken>> segmentedTokens = new ArrayList<List<CompositeContinuationToken>>();
        int subListMinSize = allTokens.size() / targetedContinuationCount;
        int remainingSize = allTokens.size() % targetedContinuationCount;
        int subListStartIndex = 0;
        for (int i = 1; i <= targetedContinuationCount; ++i) {
            int subListEndIndex = subListStartIndex + subListMinSize + (remainingSize > 0 ? 1 : 0);
            segmentedTokens.add(new ArrayList<CompositeContinuationToken>(allTokens.subList(subListStartIndex, subListEndIndex)));
            subListStartIndex = subListEndIndex;
            --remainingSize;
        }
        return segmentedTokens;
    }
}

