/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.apachecommons.text;

import com.azure.cosmos.implementation.apachecommons.text.translate.AggregateTranslator;
import com.azure.cosmos.implementation.apachecommons.text.translate.CharSequenceTranslator;
import com.azure.cosmos.implementation.apachecommons.text.translate.EntityArrays;
import com.azure.cosmos.implementation.apachecommons.text.translate.LookupTranslator;
import com.azure.cosmos.implementation.apachecommons.text.translate.OctalUnescaper;
import com.azure.cosmos.implementation.apachecommons.text.translate.UnicodeUnescaper;
import java.util.Collections;
import java.util.HashMap;

public class StringEscapeUtils {
    public static final CharSequenceTranslator UNESCAPE_JAVA;

    private StringEscapeUtils() {
    }

    public static Builder builder(CharSequenceTranslator translator) {
        return new Builder(translator);
    }

    public static String unescapeJava(String input) {
        return UNESCAPE_JAVA.translate(input);
    }

    static {
        HashMap<String, String> unescapeJavaMap = new HashMap<String, String>();
        unescapeJavaMap.put("\\\\", "\\");
        unescapeJavaMap.put("\\\"", "\"");
        unescapeJavaMap.put("\\'", "'");
        unescapeJavaMap.put("\\", "");
        UNESCAPE_JAVA = new AggregateTranslator(new OctalUnescaper(), new UnicodeUnescaper(), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_UNESCAPE), new LookupTranslator(Collections.unmodifiableMap(unescapeJavaMap)));
    }

    public static final class Builder {
        private final StringBuilder sb = new StringBuilder();
        private final CharSequenceTranslator translator;

        private Builder(CharSequenceTranslator translator) {
            this.translator = translator;
        }

        public Builder escape(String input) {
            this.sb.append(this.translator.translate(input));
            return this;
        }

        public Builder append(String input) {
            this.sb.append(input);
            return this;
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

