/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.CosmosError;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.directconnectivity.HttpUtils;
import com.azure.cosmos.implementation.http.HttpHeaders;
import java.net.URI;
import java.util.Map;

public class ServiceUnavailableException
extends CosmosException {
    ServiceUnavailableException() {
        this("Service is currently unavailable, please retry after a while. More info: https://aka.ms/cosmosdb-tsg-service-unavailable-java", 0);
    }

    public ServiceUnavailableException(CosmosError cosmosError, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders, int subStatusCode) {
        super(503, cosmosError, responseHeaders);
        BridgeInternal.setLSN(this, lsn);
        BridgeInternal.setPartitionKeyRangeId(this, partitionKeyRangeId);
        this.setSubStatus(subStatusCode);
    }

    ServiceUnavailableException(String message, int subStatusCode) {
        this(message, null, (String)null, subStatusCode);
    }

    ServiceUnavailableException(String message, HttpHeaders headers, String requestUriString, int subStatusCode) {
        this(message, null, headers, requestUriString, subStatusCode);
    }

    ServiceUnavailableException(String message, HttpHeaders headers, String requestUriString) {
        this(message, headers, requestUriString, 0);
    }

    public ServiceUnavailableException(String message, HttpHeaders headers, URI requestUri, int subStatusCode) {
        this(message, headers, requestUri != null ? requestUri.toString() : null, subStatusCode);
    }

    ServiceUnavailableException(Exception innerException, int subStatusCode) {
        this("Service is currently unavailable, please retry after a while. More info: https://aka.ms/cosmosdb-tsg-service-unavailable-java", innerException, null, null, subStatusCode);
    }

    public ServiceUnavailableException(String message, Exception innerException, HttpHeaders headers, String requestUriString, int subStatusCode) {
        super(String.format("%s: %s", "Service is currently unavailable, please retry after a while. More info: https://aka.ms/cosmosdb-tsg-service-unavailable-java", String.format("Message: %s", Strings.isNullOrWhiteSpace(message) ? "Service is currently unavailable, please retry after a while. More info: https://aka.ms/cosmosdb-tsg-service-unavailable-java" : message)), innerException, HttpUtils.asMap(headers), 503, requestUriString);
        this.setSubStatus(subStatusCode);
    }

    private void setSubStatus(int subStatusCode) {
        this.getResponseHeaders().put("x-ms-substatus", Integer.toString(subStatusCode));
    }
}

