/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.CosmosQueryRequestOptionsBase;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.models.CosmosRequestOptions;
import com.azure.cosmos.models.FeedRange;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.PartitionKeyDefinition;
import java.util.ArrayList;
import java.util.List;

public final class CosmosQueryRequestOptionsImpl
extends CosmosQueryRequestOptionsBase<CosmosQueryRequestOptionsImpl> {
    private static final ImplementationBridgeHelpers.CosmosDiagnosticsThresholdsHelper.CosmosDiagnosticsThresholdsAccessor thresholdsAccessor = ImplementationBridgeHelpers.CosmosDiagnosticsThresholdsHelper.getCosmosAsyncClientAccessor();
    private String partitionKeyRangeId;
    private Boolean scanInQueryEnabled;
    private Boolean emitVerboseTracesInQuery;
    private int maxDegreeOfParallelism;
    private int maxBufferedItemCount;
    private Integer maxItemCount;
    private String requestContinuation;
    private PartitionKey partitionkey;
    private PartitionKeyDefinition partitionKeyDefinition;
    private boolean emptyPagesAllowed;
    private FeedRange feedRange;
    private boolean queryPlanRetrievalDisallowed;
    private boolean emptyPageDiagnosticsEnabled;
    private String queryName;
    private Integer maxItemCountForVectorSearch;
    private Integer maxItemCountForHybridSearch;
    private List<CosmosDiagnostics> cancelledRequestDiagnosticsTracker = new ArrayList<CosmosDiagnostics>();
    private String collectionRid;

    public CosmosQueryRequestOptionsImpl() {
        this.emptyPageDiagnosticsEnabled = Configs.isEmptyPageDiagnosticsEnabled();
    }

    public CosmosQueryRequestOptionsImpl(CosmosQueryRequestOptionsBase<?> options) {
        super(options);
    }

    public CosmosQueryRequestOptionsImpl(CosmosQueryRequestOptionsImpl options) {
        super(options);
        this.partitionKeyRangeId = options.partitionKeyRangeId;
        this.scanInQueryEnabled = options.scanInQueryEnabled;
        this.emitVerboseTracesInQuery = options.emitVerboseTracesInQuery;
        this.maxDegreeOfParallelism = options.maxDegreeOfParallelism;
        this.maxBufferedItemCount = options.maxBufferedItemCount;
        this.maxItemCount = options.maxItemCount;
        this.requestContinuation = options.requestContinuation;
        this.partitionkey = options.partitionkey;
        this.partitionKeyDefinition = options.partitionKeyDefinition;
        this.emptyPagesAllowed = options.emptyPagesAllowed;
        this.queryPlanRetrievalDisallowed = options.queryPlanRetrievalDisallowed;
        this.emptyPageDiagnosticsEnabled = options.emptyPageDiagnosticsEnabled;
        this.queryName = options.queryName;
        this.feedRange = options.feedRange;
        this.cancelledRequestDiagnosticsTracker = options.cancelledRequestDiagnosticsTracker;
        this.maxItemCountForVectorSearch = options.maxItemCountForVectorSearch;
        this.maxItemCountForHybridSearch = options.maxItemCountForHybridSearch;
        this.collectionRid = options.collectionRid;
    }

    public String getPartitionKeyRangeIdInternal() {
        return this.partitionKeyRangeId;
    }

    public CosmosQueryRequestOptionsImpl setPartitionKeyRangeIdInternal(String partitionKeyRangeId) {
        this.partitionKeyRangeId = partitionKeyRangeId;
        return this;
    }

    @Override
    public Boolean isContentResponseOnWriteEnabled() {
        return null;
    }

    @Override
    public Boolean getNonIdempotentWriteRetriesEnabled() {
        return null;
    }

    @Override
    public Boolean isScanInQueryEnabled() {
        return this.scanInQueryEnabled;
    }

    public CosmosQueryRequestOptionsImpl setScanInQueryEnabled(Boolean scanInQueryEnabled) {
        this.scanInQueryEnabled = scanInQueryEnabled;
        return this;
    }

    public Boolean isEmitVerboseTracesInQuery() {
        return this.emitVerboseTracesInQuery;
    }

    public CosmosQueryRequestOptionsImpl setEmitVerboseTracesInQuery(Boolean emitVerboseTracesInQuery) {
        this.emitVerboseTracesInQuery = emitVerboseTracesInQuery;
        return this;
    }

    @Override
    public Integer getMaxDegreeOfParallelism() {
        return this.maxDegreeOfParallelism;
    }

    public CosmosQueryRequestOptionsImpl setMaxDegreeOfParallelism(int maxDegreeOfParallelism) {
        this.maxDegreeOfParallelism = maxDegreeOfParallelism;
        return this;
    }

    @Override
    public Integer getMaxBufferedItemCount() {
        return this.maxBufferedItemCount;
    }

    public CosmosQueryRequestOptionsImpl setMaxBufferedItemCount(int maxBufferedItemCount) {
        this.maxBufferedItemCount = maxBufferedItemCount;
        return this;
    }

    @Override
    public Integer getMaxItemCount() {
        return this.maxItemCount;
    }

    @Override
    public Integer getMaxPrefetchPageCount() {
        return null;
    }

    public CosmosQueryRequestOptionsImpl setMaxItemCount(Integer maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public Integer getMaxItemCountForVectorSearch() {
        if (this.maxItemCountForVectorSearch == null) {
            this.maxItemCountForVectorSearch = 50000;
        }
        return this.maxItemCountForVectorSearch;
    }

    public Integer getMaxItemCountForHybridSearch() {
        return this.maxItemCountForHybridSearch != null ? this.maxItemCountForHybridSearch : Configs.getMaxItemCountForHybridSearchSearch();
    }

    public CosmosQueryRequestOptionsImpl setMaxItemCountForVectorSearch(Integer maxItemCountForVectorSearch) {
        this.maxItemCountForVectorSearch = maxItemCountForVectorSearch;
        return this;
    }

    public String getRequestContinuation() {
        return this.requestContinuation;
    }

    public CosmosQueryRequestOptionsImpl setRequestContinuation(String requestContinuation) {
        this.requestContinuation = requestContinuation;
        return this;
    }

    public PartitionKey getPartitionKey() {
        return this.partitionkey;
    }

    public CosmosQueryRequestOptionsImpl setPartitionKey(PartitionKey partitionkey) {
        this.partitionkey = partitionkey;
        return this;
    }

    public boolean isEmptyPagesAllowed() {
        return this.emptyPagesAllowed;
    }

    public CosmosQueryRequestOptionsImpl setEmptyPagesAllowed(boolean emptyPagesAllowed) {
        this.emptyPagesAllowed = emptyPagesAllowed;
        return this;
    }

    public FeedRange getFeedRange() {
        return this.feedRange;
    }

    public CosmosQueryRequestOptionsImpl setFeedRange(FeedRange feedRange) {
        this.feedRange = feedRange;
        return this;
    }

    @Override
    public String getQueryNameOrDefault(String defaultQueryName) {
        return !Strings.isNullOrWhiteSpace(this.queryName) ? this.queryName : defaultQueryName;
    }

    public CosmosQueryRequestOptionsImpl setQueryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    public CosmosQueryRequestOptionsImpl disallowQueryPlanRetrieval() {
        this.queryPlanRetrievalDisallowed = true;
        return this;
    }

    public boolean isQueryPlanRetrievalDisallowed() {
        return this.queryPlanRetrievalDisallowed;
    }

    public boolean isEmptyPageDiagnosticsEnabled() {
        return this.emptyPageDiagnosticsEnabled;
    }

    public List<CosmosDiagnostics> getCancelledRequestDiagnosticsTracker() {
        return this.cancelledRequestDiagnosticsTracker;
    }

    public void setCancelledRequestDiagnosticsTracker(List<CosmosDiagnostics> cancelledRequestDiagnosticsTracker) {
        this.cancelledRequestDiagnosticsTracker = cancelledRequestDiagnosticsTracker;
    }

    public void setPartitionKeyDefinition(PartitionKeyDefinition partitionKeyDefinition) {
        this.partitionKeyDefinition = partitionKeyDefinition;
    }

    public PartitionKeyDefinition getPartitionKeyDefinition() {
        return this.partitionKeyDefinition;
    }

    @Override
    public void override(CosmosRequestOptions cosmosRequestOptions) {
        super.override(cosmosRequestOptions);
        this.scanInQueryEnabled = this.overrideOption(cosmosRequestOptions.isScanInQueryEnabled(), this.scanInQueryEnabled);
        this.maxDegreeOfParallelism = this.overrideOption(cosmosRequestOptions.getMaxDegreeOfParallelism(), this.maxDegreeOfParallelism);
        this.maxBufferedItemCount = this.overrideOption(cosmosRequestOptions.getMaxBufferedItemCount(), this.maxBufferedItemCount);
        this.maxItemCount = this.overrideOption(cosmosRequestOptions.getMaxItemCount(), this.maxItemCount);
        this.queryName = this.overrideOption(cosmosRequestOptions.getQueryName(), this.queryName);
    }

    public String getCollectionRid() {
        return this.collectionRid;
    }

    public void setCollectionRid(String collectionRid) {
        this.collectionRid = collectionRid;
    }
}

