/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.cosmos.ConnectionMode;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosClientBuilder;
import com.azure.cosmos.CosmosContainerProactiveInitConfig;
import com.azure.cosmos.CosmosDiagnosticsThresholds;
import com.azure.cosmos.CosmosEndToEndOperationLatencyPolicyConfig;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.CosmosOperationPolicy;
import com.azure.cosmos.GlobalThroughputControlConfigBuilder;
import com.azure.cosmos.ReadConsistencyStrategy;
import com.azure.cosmos.SessionRetryOptions;
import com.azure.cosmos.implementation.ApiType;
import com.azure.cosmos.implementation.AsyncDocumentClient;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.ConnectionPolicy;
import com.azure.cosmos.implementation.CosmosPagedFluxOptions;
import com.azure.cosmos.implementation.Database;
import com.azure.cosmos.implementation.DiagnosticsProvider;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.Permission;
import com.azure.cosmos.implementation.QueryFeedOperationState;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.WriteRetryPolicy;
import com.azure.cosmos.implementation.clienttelemetry.ClientMetricsDiagnosticsHandler;
import com.azure.cosmos.implementation.clienttelemetry.ClientTelemetryMetrics;
import com.azure.cosmos.implementation.clienttelemetry.CosmosMeterOptions;
import com.azure.cosmos.implementation.clienttelemetry.MetricCategory;
import com.azure.cosmos.implementation.clienttelemetry.TagName;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdMetrics;
import com.azure.cosmos.implementation.faultinjection.IFaultInjectorProvider;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.throughputControl.config.ThroughputControlGroupInternal;
import com.azure.cosmos.models.CosmosAuthorizationTokenResolver;
import com.azure.cosmos.models.CosmosClientTelemetryConfig;
import com.azure.cosmos.models.CosmosContainerIdentity;
import com.azure.cosmos.models.CosmosDatabaseProperties;
import com.azure.cosmos.models.CosmosDatabaseRequestOptions;
import com.azure.cosmos.models.CosmosDatabaseResponse;
import com.azure.cosmos.models.CosmosMetricName;
import com.azure.cosmos.models.CosmosPermissionProperties;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.models.ThroughputProperties;
import com.azure.cosmos.util.CosmosPagedFlux;
import com.azure.cosmos.util.UtilBridgeInternal;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.io.Closeable;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=CosmosClientBuilder.class, isAsync=true)
public final class CosmosAsyncClient
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(CosmosAsyncClient.class);
    private static final CosmosClientTelemetryConfig DEFAULT_TELEMETRY_CONFIG = new CosmosClientTelemetryConfig();
    private static final ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.CosmosQueryRequestOptionsAccessor queryOptionsAccessor = ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor();
    private static final ImplementationBridgeHelpers.FeedResponseHelper.FeedResponseAccessor feedResponseAccessor = ImplementationBridgeHelpers.FeedResponseHelper.getFeedResponseAccessor();
    private static final ImplementationBridgeHelpers.CosmosClientTelemetryConfigHelper.CosmosClientTelemetryConfigAccessor telemetryConfigAccessor = ImplementationBridgeHelpers.CosmosClientTelemetryConfigHelper.getCosmosClientTelemetryConfigAccessor();
    private static final ImplementationBridgeHelpers.ReadConsistencyStrategyHelper.ReadConsistencyStrategyAccessor readConsistencyStrategyAccessor = ImplementationBridgeHelpers.ReadConsistencyStrategyHelper.getReadConsistencyStrategyAccessor();
    private static final Function<CosmosAsyncContainer, CosmosAsyncContainer> DEFAULT_CONTAINER_FACTORY = originalContainer -> originalContainer;
    private final AsyncDocumentClient asyncDocumentClient;
    private final String serviceEndpoint;
    private final ConnectionPolicy connectionPolicy;
    private final ConsistencyLevel desiredConsistencyLevel;
    private final ReadConsistencyStrategy readConsistencyStrategy;
    private final AzureKeyCredential credential;
    private final CosmosClientTelemetryConfig clientTelemetryConfig;
    private final DiagnosticsProvider diagnosticsProvider;
    private final Tag clientCorrelationTag;
    private final String accountTagValue;
    private final MeterRegistry clientMetricRegistrySnapshot;
    private final CosmosContainerProactiveInitConfig proactiveContainerInitConfig;
    private final ConsistencyLevel accountConsistencyLevel;
    private final WriteRetryPolicy nonIdempotentWriteRetryPolicy;
    private final List<CosmosOperationPolicy> requestPolicies;
    private final CosmosItemSerializer defaultCustomSerializer;
    private final Function<CosmosAsyncContainer, CosmosAsyncContainer> containerFactory;

    CosmosAsyncClient(CosmosClientBuilder builder) {
        CosmosClientTelemetryConfig effectiveTelemetryConfig;
        Configs configs = builder.configs();
        this.serviceEndpoint = builder.getEndpoint();
        String keyOrResourceToken = builder.getKey();
        this.connectionPolicy = builder.getConnectionPolicy();
        this.desiredConsistencyLevel = builder.getConsistencyLevel();
        this.readConsistencyStrategy = builder.getReadConsistencyStrategy();
        List<CosmosPermissionProperties> permissions = builder.getPermissions();
        CosmosAuthorizationTokenResolver cosmosAuthorizationTokenResolver = builder.getAuthorizationTokenResolver();
        this.credential = builder.getCredential();
        TokenCredential tokenCredential = builder.getTokenCredential();
        boolean sessionCapturingOverride = builder.isSessionCapturingOverrideEnabled();
        boolean enableTransportClientSharing = builder.isConnectionSharingAcrossClientsEnabled();
        this.proactiveContainerInitConfig = builder.getProactiveContainerInitConfig();
        this.nonIdempotentWriteRetryPolicy = builder.getNonIdempotentWriteRetryPolicy();
        this.requestPolicies = builder.getOperationPolicies();
        this.defaultCustomSerializer = builder.getCustomItemSerializer();
        this.containerFactory = builder.containerCreationInterceptor() != null ? builder.containerCreationInterceptor() : DEFAULT_CONTAINER_FACTORY;
        CosmosEndToEndOperationLatencyPolicyConfig endToEndOperationLatencyPolicyConfig = builder.getEndToEndOperationConfig();
        SessionRetryOptions sessionRetryOptions = builder.getSessionRetryOptions();
        this.clientTelemetryConfig = effectiveTelemetryConfig = builder.getClientTelemetryConfig();
        boolean contentResponseOnWriteEnabled = builder.isContentResponseOnWriteEnabled();
        ApiType apiType = builder.apiType();
        String clientCorrelationId = telemetryConfigAccessor.getClientCorrelationId(effectiveTelemetryConfig);
        ArrayList<Permission> permissionList = new ArrayList();
        if (permissions != null) {
            permissionList = permissions.stream().map(ModelBridgeInternal::getPermission).filter(Objects::nonNull).collect(Collectors.toList());
        }
        this.asyncDocumentClient = new AsyncDocumentClient.Builder().withOperationPolicies(this.requestPolicies).withServiceEndpoint(this.serviceEndpoint).withMasterKeyOrResourceToken(keyOrResourceToken).withConnectionPolicy(this.connectionPolicy).withConsistencyLevel(this.desiredConsistencyLevel).withReadConsistencyStrategy(this.readConsistencyStrategy).withSessionCapturingOverride(sessionCapturingOverride).withConfigs(configs).withTokenResolver(cosmosAuthorizationTokenResolver).withCredential(this.credential).withTransportClientSharing(enableTransportClientSharing).withContentResponseOnWriteEnabled(contentResponseOnWriteEnabled).withTokenCredential(tokenCredential).withState(builder.metadataCaches()).withPermissionFeed(permissionList).withApiType(apiType).withClientTelemetryConfig(this.clientTelemetryConfig).withClientCorrelationId(clientCorrelationId).withEndToEndOperationLatencyPolicyConfig(endToEndOperationLatencyPolicyConfig).withSessionRetryOptions(sessionRetryOptions).withContainerProactiveInitConfig(this.proactiveContainerInitConfig).withDefaultSerializer(this.defaultCustomSerializer).withRegionScopedSessionCapturingEnabled(builder.isRegionScopedSessionCapturingEnabled()).withPerPartitionAutomaticFailoverEnabled(builder.isPerPartitionAutomaticFailoverEnabled()).build();
        this.accountConsistencyLevel = this.asyncDocumentClient.getDefaultConsistencyLevelOfAccount();
        String effectiveClientCorrelationId = this.asyncDocumentClient.getClientCorrelationId();
        String machineId = this.asyncDocumentClient.getMachineId();
        if (!Strings.isNullOrWhiteSpace(machineId) && machineId.startsWith("vmId_")) {
            machineId = machineId.replace("vmId_", "vmId_");
            effectiveClientCorrelationId = Strings.isNullOrWhiteSpace(effectiveClientCorrelationId) ? machineId : String.format("%s_%s", machineId, effectiveClientCorrelationId);
        }
        this.clientCorrelationTag = Tag.of((String)TagName.ClientCorrelationId.toString(), (String)ClientTelemetryMetrics.escape(effectiveClientCorrelationId));
        this.clientMetricRegistrySnapshot = telemetryConfigAccessor.getClientMetricRegistry(effectiveTelemetryConfig);
        CosmosMeterOptions cpuMeterOptions = telemetryConfigAccessor.getMeterOptions(effectiveTelemetryConfig, CosmosMetricName.SYSTEM_CPU);
        CosmosMeterOptions memoryMeterOptions = telemetryConfigAccessor.getMeterOptions(effectiveTelemetryConfig, CosmosMetricName.SYSTEM_MEMORY_FREE);
        if (this.clientMetricRegistrySnapshot != null) {
            ClientTelemetryMetrics.add(this.clientMetricRegistrySnapshot, cpuMeterOptions, memoryMeterOptions);
        }
        this.accountTagValue = URI.create(this.serviceEndpoint).getHost().replace(".documents.azure.com", "");
        if (this.clientMetricRegistrySnapshot != null) {
            telemetryConfigAccessor.setClientCorrelationTag(effectiveTelemetryConfig, this.clientCorrelationTag);
            telemetryConfigAccessor.setAccountName(effectiveTelemetryConfig, this.accountTagValue);
            telemetryConfigAccessor.addDiagnosticsHandler(effectiveTelemetryConfig, new ClientMetricsDiagnosticsHandler(this));
        }
        this.diagnosticsProvider = new DiagnosticsProvider(effectiveTelemetryConfig, effectiveClientCorrelationId, this.getUserAgent(), this.connectionPolicy.getConnectionMode());
    }

    AsyncDocumentClient getContextClient() {
        return this.asyncDocumentClient;
    }

    static void setMonitorTelemetry(MeterRegistry registry) {
        RntbdMetrics.add(registry);
    }

    String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    ConnectionPolicy getConnectionPolicy() {
        return this.connectionPolicy;
    }

    AsyncDocumentClient getDocClientWrapper() {
        return this.asyncDocumentClient;
    }

    AzureKeyCredential credential() {
        return this.credential;
    }

    CosmosClientTelemetryConfig getClientTelemetryConfig() {
        return this.clientTelemetryConfig;
    }

    public Mono<CosmosDatabaseResponse> createDatabaseIfNotExists(CosmosDatabaseProperties databaseProperties) {
        return FluxUtil.withContext(context -> this.createDatabaseIfNotExistsInternal(this.getDatabase(databaseProperties.getId()), null, (Context)context));
    }

    public Mono<CosmosDatabaseResponse> createDatabaseIfNotExists(String id) {
        return FluxUtil.withContext(context -> this.createDatabaseIfNotExistsInternal(this.getDatabase(id), null, (Context)context));
    }

    public Mono<CosmosDatabaseResponse> createDatabaseIfNotExists(String id, ThroughputProperties throughputProperties) {
        return FluxUtil.withContext(context -> this.createDatabaseIfNotExistsInternal(this.getDatabase(id), throughputProperties, (Context)context));
    }

    public Mono<CosmosDatabaseResponse> createDatabase(CosmosDatabaseProperties databaseProperties, CosmosDatabaseRequestOptions options) {
        CosmosDatabaseRequestOptions requestOptions = options == null ? new CosmosDatabaseRequestOptions() : options;
        Database wrappedDatabase = new Database();
        wrappedDatabase.setId(databaseProperties.getId());
        return FluxUtil.withContext(context -> this.createDatabaseInternal(wrappedDatabase, requestOptions, (Context)context));
    }

    public Mono<CosmosDatabaseResponse> createDatabase(CosmosDatabaseProperties databaseProperties) {
        return this.createDatabase(databaseProperties, new CosmosDatabaseRequestOptions());
    }

    public Mono<CosmosDatabaseResponse> createDatabase(String id) {
        return this.createDatabase(new CosmosDatabaseProperties(id), new CosmosDatabaseRequestOptions());
    }

    public Mono<CosmosDatabaseResponse> createDatabase(CosmosDatabaseProperties databaseProperties, ThroughputProperties throughputProperties, CosmosDatabaseRequestOptions options) {
        if (options == null) {
            options = new CosmosDatabaseRequestOptions();
        }
        ModelBridgeInternal.setThroughputProperties(options, throughputProperties);
        Database wrappedDatabase = new Database();
        wrappedDatabase.setId(databaseProperties.getId());
        CosmosDatabaseRequestOptions requestOptions = options;
        return FluxUtil.withContext(context -> this.createDatabaseInternal(wrappedDatabase, requestOptions, (Context)context));
    }

    public Mono<CosmosDatabaseResponse> createDatabase(CosmosDatabaseProperties databaseProperties, ThroughputProperties throughputProperties) {
        CosmosDatabaseRequestOptions options = new CosmosDatabaseRequestOptions();
        ModelBridgeInternal.setThroughputProperties(options, throughputProperties);
        return this.createDatabase(databaseProperties, options);
    }

    public Mono<CosmosDatabaseResponse> createDatabase(String id, ThroughputProperties throughputProperties) {
        CosmosDatabaseRequestOptions options = new CosmosDatabaseRequestOptions();
        ModelBridgeInternal.setThroughputProperties(options, throughputProperties);
        return this.createDatabase(new CosmosDatabaseProperties(id), options);
    }

    CosmosPagedFlux<CosmosDatabaseProperties> readAllDatabases(CosmosQueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            String spanName = "readAllDatabases";
            CosmosQueryRequestOptions nonNullOptions = options != null ? options : new CosmosQueryRequestOptions();
            QueryFeedOperationState state = new QueryFeedOperationState(this, spanName, null, null, ResourceType.Database, OperationType.ReadFeed, queryOptionsAccessor.getQueryNameOrDefault(nonNullOptions, spanName), nonNullOptions, (CosmosPagedFluxOptions)pagedFluxOptions);
            pagedFluxOptions.setFeedOperationState(state);
            return this.getDocClientWrapper().readDatabases(state).map(response -> feedResponseAccessor.createFeedResponse(ModelBridgeInternal.getCosmosDatabasePropertiesFromV2Results(response.getResults()), response.getResponseHeaders(), response.getCosmosDiagnostics()));
        });
    }

    public CosmosPagedFlux<CosmosDatabaseProperties> readAllDatabases() {
        return this.readAllDatabases(new CosmosQueryRequestOptions());
    }

    public CosmosPagedFlux<CosmosDatabaseProperties> queryDatabases(String query, CosmosQueryRequestOptions options) {
        if (options == null) {
            options = new CosmosQueryRequestOptions();
        }
        return this.queryDatabasesInternal(new SqlQuerySpec(query), options);
    }

    public CosmosPagedFlux<CosmosDatabaseProperties> queryDatabases(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        if (options == null) {
            options = new CosmosQueryRequestOptions();
        }
        return this.queryDatabasesInternal(querySpec, options);
    }

    public CosmosAsyncDatabase getDatabase(String id) {
        return new CosmosAsyncDatabase(id, this);
    }

    @Override
    public void close() {
        if (this.clientMetricRegistrySnapshot != null) {
            ClientTelemetryMetrics.remove(this.clientMetricRegistrySnapshot);
        }
        this.asyncDocumentClient.close();
    }

    DiagnosticsProvider getDiagnosticsProvider() {
        return this.diagnosticsProvider;
    }

    void enableThroughputControlGroup(ThroughputControlGroupInternal group, Mono<Integer> throughputQueryMono) {
        Preconditions.checkNotNull(group, "Throughput control group cannot be null");
        this.asyncDocumentClient.enableThroughputControlGroup(group, throughputQueryMono);
    }

    void configureFaultInjectorProvider(IFaultInjectorProvider injectorProvider) {
        Preconditions.checkNotNull(injectorProvider, "Argument 'injectorProvider' can not be null");
        this.asyncDocumentClient.configureFaultInjectorProvider(injectorProvider);
    }

    public GlobalThroughputControlConfigBuilder createGlobalThroughputControlConfigBuilder(String databaseId, String containerId) {
        return new GlobalThroughputControlConfigBuilder(this, databaseId, containerId);
    }

    WriteRetryPolicy getNonIdempotentWriteRetryPolicy() {
        return this.nonIdempotentWriteRetryPolicy;
    }

    void openConnectionsAndInitCaches() {
        this.blockVoidFlux(this.asyncDocumentClient.submitOpenConnectionTasksAndInitCaches(this.proactiveContainerInitConfig));
    }

    void openConnectionsAndInitCaches(Duration aggressiveWarmupDuration) {
        Flux<Void> submitOpenConnectionTasksFlux = this.asyncDocumentClient.submitOpenConnectionTasksAndInitCaches(this.proactiveContainerInitConfig);
        this.blockVoidFlux(this.wrapSourceFluxAndSoftCompleteAfterTimeout(submitOpenConnectionTasksFlux, aggressiveWarmupDuration));
    }

    private Flux<Void> wrapSourceFluxAndSoftCompleteAfterTimeout(Flux<Void> source, Duration timeout) {
        return Flux.create(sink -> source.doFinally(signalType -> sink.complete()).subscribe(t -> sink.next(t))).take(timeout);
    }

    private void blockVoidFlux(Flux<Void> voidFlux) {
        try {
            voidFlux.blockLast();
        }
        catch (Exception ex) {
            logger.warn("The void flux did not complete successfully", (Throwable)ex);
        }
    }

    private CosmosPagedFlux<CosmosDatabaseProperties> queryDatabasesInternal(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            String spanName = "queryDatabases";
            CosmosQueryRequestOptions nonNullOptions = options != null ? options : new CosmosQueryRequestOptions();
            QueryFeedOperationState state = new QueryFeedOperationState(this, spanName, null, null, ResourceType.Database, OperationType.Query, queryOptionsAccessor.getQueryNameOrDefault(nonNullOptions, spanName), nonNullOptions, (CosmosPagedFluxOptions)pagedFluxOptions);
            pagedFluxOptions.setFeedOperationState(state);
            return this.getDocClientWrapper().queryDatabases(querySpec, state).map(response -> feedResponseAccessor.createFeedResponse(ModelBridgeInternal.getCosmosDatabasePropertiesFromV2Results(response.getResults()), response.getResponseHeaders(), response.getCosmosDiagnostics()));
        });
    }

    private Mono<CosmosDatabaseResponse> createDatabaseIfNotExistsInternal(CosmosAsyncDatabase database, ThroughputProperties throughputProperties, Context context) {
        String spanName = "createDatabaseIfNotExists." + database.getId();
        Context nestedContext = context.addData((Object)"cosmosCallDepth", (Object)"nested");
        CosmosDatabaseRequestOptions options = new CosmosDatabaseRequestOptions();
        Mono responseMono = database.readInternal(new CosmosDatabaseRequestOptions(), nestedContext).onErrorResume(exception -> {
            CosmosException cosmosException;
            Throwable unwrappedException = Exceptions.unwrap((Throwable)exception);
            if (unwrappedException instanceof CosmosException && (cosmosException = (CosmosException)((Object)((Object)unwrappedException))).getStatusCode() == 404) {
                if (throughputProperties != null) {
                    ModelBridgeInternal.setThroughputProperties(options, throughputProperties);
                }
                Database wrappedDatabase = new Database();
                wrappedDatabase.setId(database.getId());
                return this.createDatabaseInternal(wrappedDatabase, options, nestedContext);
            }
            return Mono.error((Throwable)unwrappedException);
        });
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        return this.diagnosticsProvider.traceEnabledCosmosResponsePublisher(responseMono, context, spanName, database.getId(), null, this, null, OperationType.Create, ResourceType.Database, requestOptions);
    }

    private Mono<CosmosDatabaseResponse> createDatabaseInternal(Database database, CosmosDatabaseRequestOptions options, Context context) {
        String spanName = "createDatabase." + database.getId();
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        Mono responseMono = this.asyncDocumentClient.createDatabase(database, requestOptions).map(ModelBridgeInternal::createCosmosDatabaseResponse).single();
        return this.diagnosticsProvider.traceEnabledCosmosResponsePublisher(responseMono, context, spanName, database.getId(), null, this, null, OperationType.Create, ResourceType.Database, requestOptions);
    }

    ConsistencyLevel getEffectiveConsistencyLevel(OperationType operationType, ConsistencyLevel desiredConsistencyLevelOfOperation) {
        if (operationType.isWriteOperation()) {
            return this.accountConsistencyLevel;
        }
        if (desiredConsistencyLevelOfOperation != null) {
            return desiredConsistencyLevelOfOperation;
        }
        if (this.desiredConsistencyLevel != null) {
            return this.desiredConsistencyLevel;
        }
        return this.accountConsistencyLevel;
    }

    ReadConsistencyStrategy getEffectiveReadConsistencyStrategy(ResourceType resourceType, OperationType operationType, ReadConsistencyStrategy desiredReadConsistencyStrategyOfOperation) {
        return readConsistencyStrategyAccessor.getEffectiveReadConsistencyStrategy(resourceType, operationType, desiredReadConsistencyStrategyOfOperation, this.readConsistencyStrategy);
    }

    CosmosDiagnosticsThresholds getEffectiveDiagnosticsThresholds(CosmosDiagnosticsThresholds operationLevelThresholds) {
        if (operationLevelThresholds != null) {
            return operationLevelThresholds;
        }
        if (this.clientTelemetryConfig == null) {
            return new CosmosDiagnosticsThresholds();
        }
        CosmosDiagnosticsThresholds clientLevelThresholds = telemetryConfigAccessor.getDiagnosticsThresholds(this.clientTelemetryConfig);
        return clientLevelThresholds != null ? clientLevelThresholds : new CosmosDiagnosticsThresholds();
    }

    CosmosItemSerializer getEffectiveItemSerializer(CosmosItemSerializer requestOptionsItemSerializer) {
        return this.asyncDocumentClient.getEffectiveItemSerializer(requestOptionsItemSerializer);
    }

    boolean isTransportLevelTracingEnabled() {
        CosmosClientTelemetryConfig effectiveConfig;
        CosmosClientTelemetryConfig cosmosClientTelemetryConfig = effectiveConfig = this.clientTelemetryConfig != null ? this.clientTelemetryConfig : DEFAULT_TELEMETRY_CONFIG;
        if (telemetryConfigAccessor.isLegacyTracingEnabled(effectiveConfig)) {
            return false;
        }
        if (this.getConnectionPolicy().getConnectionMode() != ConnectionMode.DIRECT) {
            return false;
        }
        return telemetryConfigAccessor.isTransportLevelTracingEnabled(effectiveConfig);
    }

    void recordOpenConnectionsAndInitCachesCompleted(List<CosmosContainerIdentity> cosmosContainerIdentities) {
        this.asyncDocumentClient.recordOpenConnectionsAndInitCachesCompleted(cosmosContainerIdentities);
    }

    void recordOpenConnectionsAndInitCachesStarted(List<CosmosContainerIdentity> cosmosContainerIdentities) {
        this.asyncDocumentClient.recordOpenConnectionsAndInitCachesStarted(cosmosContainerIdentities);
    }

    String getAccountTagValue() {
        return this.accountTagValue;
    }

    Tag getClientCorrelationTag() {
        return this.clientCorrelationTag;
    }

    String getUserAgent() {
        return this.asyncDocumentClient.getUserAgent();
    }

    Function<CosmosAsyncContainer, CosmosAsyncContainer> getContainerCreationInterceptor() {
        return this.containerFactory;
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosAsyncClientHelper.setCosmosAsyncClientAccessor(new ImplementationBridgeHelpers.CosmosAsyncClientHelper.CosmosAsyncClientAccessor(){

            @Override
            public Tag getClientCorrelationTag(CosmosAsyncClient client) {
                return client.getClientCorrelationTag();
            }

            @Override
            public String getAccountTagValue(CosmosAsyncClient client) {
                return client.getAccountTagValue();
            }

            @Override
            public EnumSet<TagName> getMetricTagNames(CosmosAsyncClient client) {
                return telemetryConfigAccessor.getMetricTagNames(client.clientTelemetryConfig);
            }

            @Override
            public EnumSet<MetricCategory> getMetricCategories(CosmosAsyncClient client) {
                return telemetryConfigAccessor.getMetricCategories(client.clientTelemetryConfig);
            }

            @Override
            public boolean shouldEnableEmptyPageDiagnostics(CosmosAsyncClient client) {
                return client.clientMetricRegistrySnapshot != null || client.isTransportLevelTracingEnabled();
            }

            @Override
            public List<String> getPreferredRegions(CosmosAsyncClient client) {
                return client.connectionPolicy.getPreferredRegions();
            }

            @Override
            public boolean isEndpointDiscoveryEnabled(CosmosAsyncClient client) {
                return client.connectionPolicy.isEndpointDiscoveryEnabled();
            }

            @Override
            public String getConnectionMode(CosmosAsyncClient client) {
                return client.getConnectionPolicy().getConnectionMode().toString();
            }

            @Override
            public String getUserAgent(CosmosAsyncClient client) {
                return client.getUserAgent();
            }

            @Override
            public CosmosMeterOptions getMeterOptions(CosmosAsyncClient client, CosmosMetricName name) {
                return telemetryConfigAccessor.getMeterOptions(client.clientTelemetryConfig, name);
            }

            @Override
            public boolean isEffectiveContentResponseOnWriteEnabled(CosmosAsyncClient client, Boolean requestOptionsContentResponseEnabled) {
                if (requestOptionsContentResponseEnabled != null) {
                    return requestOptionsContentResponseEnabled;
                }
                return client.asyncDocumentClient.isContentResponseOnWriteEnabled();
            }

            @Override
            public ConsistencyLevel getEffectiveConsistencyLevel(CosmosAsyncClient client, OperationType operationType, ConsistencyLevel desiredConsistencyLevelOfOperation) {
                return client.getEffectiveConsistencyLevel(operationType, desiredConsistencyLevelOfOperation);
            }

            @Override
            public ReadConsistencyStrategy getEffectiveReadConsistencyStrategy(CosmosAsyncClient client, ResourceType resourceType, OperationType operationType, ReadConsistencyStrategy desiredReadConsistencyStrategy) {
                return client.getEffectiveReadConsistencyStrategy(resourceType, operationType, desiredReadConsistencyStrategy);
            }

            @Override
            public CosmosDiagnosticsThresholds getEffectiveDiagnosticsThresholds(CosmosAsyncClient client, CosmosDiagnosticsThresholds operationLevelThresholds) {
                return client.getEffectiveDiagnosticsThresholds(operationLevelThresholds);
            }

            @Override
            public DiagnosticsProvider getDiagnosticsProvider(CosmosAsyncClient client) {
                return client.getDiagnosticsProvider();
            }

            @Override
            public List<CosmosOperationPolicy> getOperationPolicies(CosmosAsyncClient client) {
                return client.requestPolicies;
            }

            @Override
            public CosmosItemSerializer getEffectiveItemSerializer(CosmosAsyncClient client, CosmosItemSerializer requestOptionsItemSerializer) {
                return client.getEffectiveItemSerializer(requestOptionsItemSerializer);
            }
        });
    }

    static {
        CosmosAsyncClient.initialize();
    }
}

