/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.CosmosMetricCategory;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;

public final class PriorityLevel {
    private final String name;
    private final byte priorityValue;
    public static final PriorityLevel HIGH = new PriorityLevel("High", 1);
    public static final PriorityLevel LOW = new PriorityLevel("Low", 2);

    private PriorityLevel(String name, byte priorityValue) {
        this.name = name;
        this.priorityValue = priorityValue;
    }

    public static PriorityLevel fromString(String name) {
        String normalizedName;
        Preconditions.checkNotNull(name, "Argument 'name' must not be null.");
        switch (normalizedName = name.trim().toLowerCase(Locale.ROOT)) {
            case "low": {
                return LOW;
            }
            case "high": {
                return HIGH;
            }
        }
        String errorMessage = String.format("Argument 'name' has invalid value '%s' - valid values are: %s", name, PriorityLevel.getValidValues());
        throw new IllegalArgumentException(errorMessage);
    }

    @JsonValue
    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(CosmosMetricCategory.class, this.name);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!PriorityLevel.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.name == null) {
            return ((PriorityLevel)obj).name == null;
        }
        return this.name.equals(((PriorityLevel)obj).name);
    }

    byte getPriorityValue() {
        return this.priorityValue;
    }

    private static String getValidValues() {
        return new StringJoiner(", ").add(PriorityLevel.HIGH.name).add(PriorityLevel.LOW.name).toString();
    }

    static void initialize() {
        ImplementationBridgeHelpers.PriorityLevelHelper.setPriorityLevelAccessor(new ImplementationBridgeHelpers.PriorityLevelHelper.PriorityLevelAccessor(){

            @Override
            public byte getPriorityValue(PriorityLevel level) {
                Preconditions.checkNotNull(level, "Argument 'level' must not be null.");
                return level.getPriorityValue();
            }
        });
    }

    static {
        PriorityLevel.initialize();
    }
}

